/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.layer.impl;

import com.ait.lienzo.client.core.event.NodeMouseDownEvent;
import com.ait.lienzo.client.core.event.NodeMouseDownHandler;
import com.ait.lienzo.client.core.event.NodeMouseMoveEvent;
import com.ait.lienzo.client.core.event.NodeMouseUpEvent;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.shape.Line;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.client.core.types.Point2DArray;
import com.ait.lienzo.client.core.types.Transform;
import com.ait.lienzo.shared.core.types.ColorName;
import com.ait.lienzo.shared.core.types.IColor;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.AbsolutePanel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseBounds;
import org.uberfire.ext.wires.core.grids.client.widget.dnd.GridWidgetDnDHandlersState;
import org.uberfire.ext.wires.core.grids.client.widget.dnd.GridWidgetDnDMouseDownHandler;
import org.uberfire.ext.wires.core.grids.client.widget.dnd.GridWidgetDnDMouseMoveHandler;
import org.uberfire.ext.wires.core.grids.client.widget.dnd.GridWidgetDnDMouseUpHandler;
import org.uberfire.ext.wires.core.grids.client.widget.dom.single.HasSingletonDOMElementResource;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.animation.GridWidgetScrollIntoViewAnimation;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.GridWidgetConnector;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLayerRedrawManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.TransformMediator;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl.BoundaryTransformMediator;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl.DefaultPinnedModeManager;

public class DefaultGridLayer
extends Layer
implements GridLayer {
    private static final int PADDING = 0;
    private Set<GridWidget> gridWidgets = new HashSet<GridWidget>();
    private Map<GridWidgetConnector, Line> gridWidgetConnectors = new HashMap<GridWidgetConnector, Line>();
    private AbsolutePanel domElementContainer;
    private Bounds bounds;
    private final GridWidgetDnDMouseDownHandler mouseDownHandler;
    private final GridWidgetDnDMouseMoveHandler mouseMoveHandler;
    private final GridWidgetDnDMouseUpHandler mouseUpHandler;
    private final GridWidgetDnDHandlersState state = new GridWidgetDnDHandlersState();
    private final TransformMediator defaultTransformMediator = new BoundaryTransformMediator();
    private final DefaultPinnedModeManager pinnedModeManager = new DefaultPinnedModeManager(this);
    private final GridLayerRedrawManager.PrioritizedCommand REDRAW = new GridLayerRedrawManager.PrioritizedCommand(Integer.MIN_VALUE){

        public void execute() {
            DefaultGridLayer.this.draw();
        }
    };

    public DefaultGridLayer() {
        this.bounds = new BaseBounds(0.0, 0.0, 0.0, 0.0);
        this.mouseDownHandler = new GridWidgetDnDMouseDownHandler(this, this.state);
        this.mouseMoveHandler = new GridWidgetDnDMouseMoveHandler(this, this.state);
        this.mouseUpHandler = new GridWidgetDnDMouseUpHandler(this, this.state);
        this.addNodeMouseDownHandler(this.mouseDownHandler);
        this.addNodeMouseMoveHandler(this.mouseMoveHandler);
        this.addNodeMouseUpHandler(this.mouseUpHandler);
        this.addNodeMouseDownHandler(new NodeMouseDownHandler(){

            public void onNodeMouseDown(NodeMouseDownEvent event) {
                for (GridWidget gridWidget : DefaultGridLayer.this.gridWidgets) {
                    for (GridColumn<?> gridColumn : gridWidget.getModel().getColumns()) {
                        if (!(gridColumn instanceof HasSingletonDOMElementResource)) continue;
                        ((HasSingletonDOMElementResource)((Object)gridColumn)).flush();
                        ((HasSingletonDOMElementResource)((Object)gridColumn)).destroyResources();
                        DefaultGridLayer.this.batch();
                    }
                }
            }
        });
    }

    public void onNodeMouseDown(NodeMouseDownEvent event) {
        this.mouseDownHandler.onNodeMouseDown(event);
    }

    public void onNodeMouseMove(NodeMouseMoveEvent event) {
        this.mouseMoveHandler.onNodeMouseMove(event);
    }

    public void onNodeMouseUp(NodeMouseUpEvent event) {
        this.mouseUpHandler.onNodeMouseUp(event);
    }

    public Layer draw() {
        this.updateGridWidgetConnectors();
        return super.draw();
    }

    public Layer batch() {
        return this.batch(this.REDRAW);
    }

    @Override
    public Layer batch(GridLayerRedrawManager.PrioritizedCommand command) {
        GridLayerRedrawManager.get().schedule(command);
        return this;
    }

    @Override
    public Set<IPrimitive<?>> getGridWidgetConnectors() {
        return Collections.unmodifiableSet(new HashSet<Line>(this.gridWidgetConnectors.values()));
    }

    private void updateGridWidgetConnectors() {
        for (Map.Entry<GridWidgetConnector, Line> e : this.gridWidgetConnectors.entrySet()) {
            GridWidgetConnector connector = e.getKey();
            Line line = e.getValue();
            GridColumn<?> sourceGridColumn = connector.getSourceColumn();
            GridColumn<?> targetGridColumn = connector.getTargetColumn();
            GridWidget sourceGridWidget = this.getLinkedGridWidget(sourceGridColumn);
            GridWidget targetGridWidget = this.getLinkedGridWidget(targetGridColumn);
            Point2D sp = new Point2D(sourceGridWidget.getX() + sourceGridWidget.getWidth() / 2.0, sourceGridWidget.getY() + sourceGridWidget.getHeight() / 2.0);
            Point2D ep = new Point2D(targetGridWidget.getX() + targetGridWidget.getWidth() / 2.0, targetGridWidget.getY() + targetGridWidget.getHeight() / 2.0);
            line.setPoints(new Point2DArray(sp, new Point2D[]{ep}));
        }
    }

    public Layer add(IPrimitive<?> child) {
        this.addGridWidget(child, new IPrimitive[0]);
        return super.add(child);
    }

    private void addGridWidget(IPrimitive<?> child, IPrimitive<?> ... children) {
        ArrayList all = new ArrayList();
        all.add(child);
        all.addAll(Arrays.asList(children));
        for (IPrimitive iPrimitive : all) {
            if (!(iPrimitive instanceof GridWidget)) continue;
            GridWidget gridWidget = (GridWidget)iPrimitive;
            this.gridWidgets.add(gridWidget);
            this.addGridWidgetConnectors();
        }
    }

    @Override
    public void refreshGridWidgetConnectors() {
        for (Line line : this.gridWidgetConnectors.values()) {
            this.remove((IPrimitive<?>)line);
        }
        this.gridWidgetConnectors.clear();
        this.addGridWidgetConnectors();
    }

    private void addGridWidgetConnectors() {
        for (GridWidget gridWidget : this.gridWidgets) {
            GridData gridModel = gridWidget.getModel();
            for (GridColumn<?> gridColumn : gridModel.getColumns()) {
                GridWidget linkedGridWidget;
                if (!gridColumn.isVisible() || !gridColumn.isLinked() || (linkedGridWidget = this.getLinkedGridWidget(gridColumn.getLink())) == null) continue;
                Point2D sp = new Point2D(gridWidget.getX() + gridWidget.getWidth() / 2.0, gridWidget.getY() + gridWidget.getHeight() / 2.0);
                Point2D ep = new Point2D(linkedGridWidget.getX() + linkedGridWidget.getWidth() / 2.0, linkedGridWidget.getY() + linkedGridWidget.getHeight() / 2.0);
                GridWidgetConnector connector = new GridWidgetConnector(gridColumn, gridColumn.getLink());
                if (this.gridWidgetConnectors.containsKey(connector)) continue;
                Line line = (Line)((Line)((Line)((Line)new Line(sp, ep).setVisible(!this.isGridPinned())).setStrokeColor((IColor)ColorName.DARKGRAY)).setFillColor((IColor)ColorName.TAN)).setStrokeWidth(2.0);
                this.gridWidgetConnectors.put(connector, line);
                super.add((IPrimitive)line);
                line.moveToBottom();
            }
        }
    }

    private GridWidget getLinkedGridWidget(GridColumn<?> linkedGridColumn) {
        GridWidget linkedGridWidget = null;
        for (GridWidget gridWidget : this.gridWidgets) {
            GridData gridModel = gridWidget.getModel();
            if (!gridModel.getColumns().contains(linkedGridColumn)) continue;
            linkedGridWidget = gridWidget;
            break;
        }
        return linkedGridWidget;
    }

    public Layer add(IPrimitive<?> child, IPrimitive<?> ... children) {
        this.addGridWidget(child, children);
        return super.add(child, children);
    }

    public Layer remove(IPrimitive<?> child) {
        this.removeGridWidget(child, new IPrimitive[0]);
        return super.remove(child);
    }

    private void removeGridWidget(IPrimitive<?> child, IPrimitive<?> ... children) {
        ArrayList all = new ArrayList();
        all.add(child);
        all.addAll(Arrays.asList(children));
        for (IPrimitive iPrimitive : all) {
            if (!(iPrimitive instanceof GridWidget)) continue;
            GridWidget gridWidget = (GridWidget)iPrimitive;
            this.gridWidgets.remove(gridWidget);
            this.removeGridWidgetConnectors(gridWidget);
        }
    }

    private void removeGridWidgetConnectors(GridWidget gridWidget) {
        GridData gridModel = gridWidget.getModel();
        ArrayList<GridWidgetConnector> removedConnectors = new ArrayList<GridWidgetConnector>();
        for (Map.Entry<GridWidgetConnector, Line> e : this.gridWidgetConnectors.entrySet()) {
            if (!gridModel.getColumns().contains(e.getKey().getSourceColumn()) && !gridModel.getColumns().contains(e.getKey().getTargetColumn())) continue;
            this.remove((IPrimitive)e.getValue());
            removedConnectors.add(e.getKey());
        }
        for (GridWidgetConnector c : removedConnectors) {
            this.gridWidgetConnectors.remove(c);
        }
    }

    public Layer removeAll() {
        this.gridWidgets.clear();
        this.gridWidgetConnectors.clear();
        return super.removeAll();
    }

    @Override
    public void select(GridWidget selectedGridWidget) {
        boolean selectionChanged = false;
        for (GridWidget gridWidget : this.gridWidgets) {
            if (gridWidget.isSelected()) {
                if (gridWidget.equals(selectedGridWidget)) continue;
                selectionChanged = true;
                gridWidget.deselect();
                continue;
            }
            if (!gridWidget.equals(selectedGridWidget)) continue;
            selectionChanged = true;
            gridWidget.select();
        }
        if (selectionChanged) {
            this.batch();
        }
    }

    @Override
    public void selectLinkedColumn(GridColumn<?> selectedGridColumn) {
        GridWidget gridWidget = this.getLinkedGridWidget(selectedGridColumn);
        if (gridWidget == null) {
            return;
        }
        if (this.isGridPinned()) {
            this.flipToGridWidget(gridWidget);
        } else {
            this.scrollToGridWidget(gridWidget);
        }
    }

    @Override
    public void flipToGridWidget(final GridWidget gridWidget) {
        if (!this.isGridPinned()) {
            return;
        }
        for (GridWidget gw : this.gridWidgets) {
            gw.setAlpha(gw.equals(gridWidget) ? 1.0 : 0.0);
            gw.setVisible(gw.equals(gridWidget));
        }
        Point2D translation = new Point2D(gridWidget.getX(), gridWidget.getY()).mul(-1.0);
        Viewport vp = gridWidget.getViewport();
        Transform transform = vp.getTransform();
        transform.reset();
        transform.translate(translation.getX(), translation.getY());
        this.updatePinnedContext(gridWidget);
        this.batch(new GridLayerRedrawManager.PrioritizedCommand(0){

            public void execute() {
                DefaultGridLayer.this.select(gridWidget);
            }
        });
    }

    @Override
    public void scrollToGridWidget(final GridWidget gridWidget) {
        if (this.isGridPinned()) {
            return;
        }
        GridWidgetScrollIntoViewAnimation a = new GridWidgetScrollIntoViewAnimation(gridWidget, new Command(){

            public void execute() {
                DefaultGridLayer.this.select(gridWidget);
            }
        });
        a.run();
    }

    @Override
    public Set<GridWidget> getGridWidgets() {
        return Collections.unmodifiableSet(this.gridWidgets);
    }

    @Override
    public void enterPinnedMode(GridWidget gridWidget, Command onStartCommand) {
        this.pinnedModeManager.enterPinnedMode(gridWidget, onStartCommand);
    }

    @Override
    public void exitPinnedMode(Command onCompleteCommand) {
        this.pinnedModeManager.exitPinnedMode(onCompleteCommand);
    }

    @Override
    public void updatePinnedContext(GridWidget gridWidget) throws IllegalStateException {
        this.pinnedModeManager.updatePinnedContext(gridWidget);
    }

    @Override
    public GridPinnedModeManager.PinnedContext getPinnedContext() {
        return this.pinnedModeManager.getPinnedContext();
    }

    @Override
    public boolean isGridPinned() {
        return this.pinnedModeManager.isGridPinned();
    }

    @Override
    public TransformMediator getDefaultTransformMediator() {
        return this.defaultTransformMediator;
    }

    @Override
    public Bounds getVisibleBounds() {
        this.updateVisibleBounds();
        return this.bounds;
    }

    private void updateVisibleBounds() {
        Viewport viewport = this.getViewport();
        Transform transform = viewport.getTransform();
        if (transform == null) {
            transform = new Transform();
            viewport.setTransform(transform);
        }
        double x = (0.0 - transform.getTranslateX()) / transform.getScaleX();
        double y = (0.0 - transform.getTranslateY()) / transform.getScaleY();
        this.bounds.setX(x);
        this.bounds.setY(y);
        this.bounds.setHeight(Math.max(0.0, (double)(viewport.getHeight() - 0) / transform.getScaleX()));
        this.bounds.setWidth(Math.max(0.0, (double)(viewport.getWidth() - 0) / transform.getScaleY()));
    }

    @Override
    public GridWidgetDnDHandlersState getGridWidgetHandlersState() {
        return this.state;
    }

    @Override
    public void setDomElementContainer(AbsolutePanel domElementContainer) {
        this.domElementContainer = domElementContainer;
    }

    @Override
    public AbsolutePanel getDomElementContainer() {
        return this.domElementContainer;
    }
}

