/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridTest;

public class GridColumnIndexingTest
extends BaseGridTest {
    @Test
    public void testAddInitialColumns() {
        BaseGridData grid = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        grid.appendColumn(gc1);
        grid.appendColumn(gc2);
        List columns = grid.getColumns();
        Assert.assertEquals((long)2L, (long)columns.size());
        Assert.assertEquals((long)0L, (long)gc1.getIndex());
        Assert.assertEquals((long)1L, (long)gc2.getIndex());
        Assert.assertEquals(columns.get(0), gc1);
        Assert.assertEquals(columns.get(1), gc2);
    }

    @Test
    public void testAddColumn() {
        BaseGridData grid = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        grid.appendColumn(gc1);
        grid.appendColumn(gc2);
        grid.insertColumn(1, gc3);
        List columns = grid.getColumns();
        Assert.assertEquals((long)3L, (long)columns.size());
        Assert.assertEquals((long)0L, (long)gc1.getIndex());
        Assert.assertEquals((long)1L, (long)gc2.getIndex());
        Assert.assertEquals((long)2L, (long)gc3.getIndex());
        Assert.assertEquals(columns.get(0), gc1);
        Assert.assertEquals(columns.get(1), gc3);
        Assert.assertEquals(columns.get(2), gc2);
    }

    @Test
    public void testRemoveColumn() {
        BaseGridData grid = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        grid.appendColumn(gc1);
        grid.appendColumn(gc2);
        grid.appendColumn(gc3);
        grid.deleteColumn(gc2);
        List columns = grid.getColumns();
        Assert.assertEquals((long)2L, (long)columns.size());
        Assert.assertEquals((long)0L, (long)gc1.getIndex());
        Assert.assertEquals((long)1L, (long)gc3.getIndex());
        Assert.assertEquals(columns.get(0), gc1);
        Assert.assertEquals(columns.get(1), gc3);
    }

    @Test
    public void testMoveColumnToLeft() {
        BaseGridData grid = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        BaseGridTest.MockMergableGridColumn gc4 = new BaseGridTest.MockMergableGridColumn("col4", 100.0);
        grid.appendColumn(gc1);
        grid.appendColumn(gc2);
        grid.appendColumn(gc3);
        grid.appendColumn(gc4);
        grid.moveColumnTo(1, gc4);
        List columns = grid.getColumns();
        Assert.assertEquals((long)4L, (long)columns.size());
        Assert.assertEquals((long)0L, (long)gc1.getIndex());
        Assert.assertEquals((long)1L, (long)gc2.getIndex());
        Assert.assertEquals((long)2L, (long)gc3.getIndex());
        Assert.assertEquals((long)3L, (long)gc4.getIndex());
        Assert.assertEquals(columns.get(0), gc1);
        Assert.assertEquals(columns.get(1), gc4);
        Assert.assertEquals(columns.get(2), gc2);
        Assert.assertEquals(columns.get(3), gc3);
    }

    @Test
    public void testMoveColumnsToLeft_RightMostTwoColumns() {
        BaseGridData grid = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        BaseGridTest.MockMergableGridColumn gc4 = new BaseGridTest.MockMergableGridColumn("col4", 100.0);
        grid.appendColumn(gc1);
        grid.appendColumn(gc2);
        grid.appendColumn(gc3);
        grid.appendColumn(gc4);
        grid.moveColumnsTo(1, (List)new ArrayList<GridColumn<?>>((GridColumn)gc3, (GridColumn)gc4){
            final /* synthetic */ GridColumn val$gc3;
            final /* synthetic */ GridColumn val$gc4;
            {
                this.val$gc3 = gridColumn;
                this.val$gc4 = gridColumn2;
                this.add(this.val$gc3);
                this.add(this.val$gc4);
            }
        });
        List columns = grid.getColumns();
        Assert.assertEquals((long)4L, (long)columns.size());
        Assert.assertEquals((long)0L, (long)gc1.getIndex());
        Assert.assertEquals((long)1L, (long)gc2.getIndex());
        Assert.assertEquals((long)2L, (long)gc3.getIndex());
        Assert.assertEquals((long)3L, (long)gc4.getIndex());
        Assert.assertEquals(columns.get(0), gc1);
        Assert.assertEquals(columns.get(1), gc3);
        Assert.assertEquals(columns.get(2), gc4);
        Assert.assertEquals(columns.get(3), gc2);
    }

    @Test
    public void testMoveColumnsToLeft_MiddleTwoColumns() {
        BaseGridData grid = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        BaseGridTest.MockMergableGridColumn gc4 = new BaseGridTest.MockMergableGridColumn("col4", 100.0);
        grid.appendColumn(gc1);
        grid.appendColumn(gc2);
        grid.appendColumn(gc3);
        grid.appendColumn(gc4);
        grid.moveColumnsTo(0, (List)new ArrayList<GridColumn<?>>((GridColumn)gc2, (GridColumn)gc3){
            final /* synthetic */ GridColumn val$gc2;
            final /* synthetic */ GridColumn val$gc3;
            {
                this.val$gc2 = gridColumn;
                this.val$gc3 = gridColumn2;
                this.add(this.val$gc2);
                this.add(this.val$gc3);
            }
        });
        List columns = grid.getColumns();
        Assert.assertEquals((long)4L, (long)columns.size());
        Assert.assertEquals((long)0L, (long)gc1.getIndex());
        Assert.assertEquals((long)1L, (long)gc2.getIndex());
        Assert.assertEquals((long)2L, (long)gc3.getIndex());
        Assert.assertEquals((long)3L, (long)gc4.getIndex());
        Assert.assertEquals(columns.get(0), gc2);
        Assert.assertEquals(columns.get(1), gc3);
        Assert.assertEquals(columns.get(2), gc1);
        Assert.assertEquals(columns.get(3), gc4);
    }

    @Test
    public void testMoveColumnToRight_LeftMostColumn() {
        BaseGridData grid = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        BaseGridTest.MockMergableGridColumn gc4 = new BaseGridTest.MockMergableGridColumn("col4", 100.0);
        grid.appendColumn(gc1);
        grid.appendColumn(gc2);
        grid.appendColumn(gc3);
        grid.appendColumn(gc4);
        grid.moveColumnTo(3, gc1);
        List columns = grid.getColumns();
        Assert.assertEquals((long)4L, (long)columns.size());
        Assert.assertEquals((long)0L, (long)gc1.getIndex());
        Assert.assertEquals((long)1L, (long)gc2.getIndex());
        Assert.assertEquals((long)2L, (long)gc3.getIndex());
        Assert.assertEquals((long)3L, (long)gc4.getIndex());
        Assert.assertEquals(columns.get(0), gc2);
        Assert.assertEquals(columns.get(1), gc3);
        Assert.assertEquals(columns.get(2), gc4);
        Assert.assertEquals(columns.get(3), gc1);
    }

    @Test
    public void testMoveColumnsToRight_LeftMostTwoColumns() {
        BaseGridData grid = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        BaseGridTest.MockMergableGridColumn gc4 = new BaseGridTest.MockMergableGridColumn("col4", 100.0);
        grid.appendColumn(gc1);
        grid.appendColumn(gc2);
        grid.appendColumn(gc3);
        grid.appendColumn(gc4);
        grid.moveColumnsTo(2, (List)new ArrayList<GridColumn<?>>((GridColumn)gc1, (GridColumn)gc2){
            final /* synthetic */ GridColumn val$gc1;
            final /* synthetic */ GridColumn val$gc2;
            {
                this.val$gc1 = gridColumn;
                this.val$gc2 = gridColumn2;
                this.add(this.val$gc1);
                this.add(this.val$gc2);
            }
        });
        List columns = grid.getColumns();
        Assert.assertEquals((long)4L, (long)columns.size());
        Assert.assertEquals((long)0L, (long)gc1.getIndex());
        Assert.assertEquals((long)1L, (long)gc2.getIndex());
        Assert.assertEquals((long)2L, (long)gc3.getIndex());
        Assert.assertEquals((long)3L, (long)gc4.getIndex());
        Assert.assertEquals(columns.get(0), gc3);
        Assert.assertEquals(columns.get(1), gc1);
        Assert.assertEquals(columns.get(2), gc2);
        Assert.assertEquals(columns.get(3), gc4);
    }

    @Test
    public void testMoveColumnsToRight_LeftMostTwoColumns_ToRightExtent() {
        BaseGridData grid = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        BaseGridTest.MockMergableGridColumn gc4 = new BaseGridTest.MockMergableGridColumn("col4", 100.0);
        grid.appendColumn(gc1);
        grid.appendColumn(gc2);
        grid.appendColumn(gc3);
        grid.appendColumn(gc4);
        grid.moveColumnsTo(3, (List)new ArrayList<GridColumn<?>>((GridColumn)gc1, (GridColumn)gc2){
            final /* synthetic */ GridColumn val$gc1;
            final /* synthetic */ GridColumn val$gc2;
            {
                this.val$gc1 = gridColumn;
                this.val$gc2 = gridColumn2;
                this.add(this.val$gc1);
                this.add(this.val$gc2);
            }
        });
        List columns = grid.getColumns();
        Assert.assertEquals((long)4L, (long)columns.size());
        Assert.assertEquals((long)0L, (long)gc1.getIndex());
        Assert.assertEquals((long)1L, (long)gc2.getIndex());
        Assert.assertEquals((long)2L, (long)gc3.getIndex());
        Assert.assertEquals((long)3L, (long)gc4.getIndex());
        Assert.assertEquals(columns.get(0), gc3);
        Assert.assertEquals(columns.get(1), gc4);
        Assert.assertEquals(columns.get(2), gc1);
        Assert.assertEquals(columns.get(3), gc2);
    }

    @Test
    public void testMoveColumnsToRight_LeftMostTwoColumns_MidBlock() {
        BaseGridData grid = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        BaseGridTest.MockMergableGridColumn gc4 = new BaseGridTest.MockMergableGridColumn("col4", 100.0);
        BaseGridTest.MockMergableGridColumn gc5 = new BaseGridTest.MockMergableGridColumn("col5", 100.0);
        BaseGridTest.MockMergableGridColumn gc6 = new BaseGridTest.MockMergableGridColumn("col6", 100.0);
        BaseGridTest.MockMergableGridColumn gc7 = new BaseGridTest.MockMergableGridColumn("col7", 100.0);
        BaseGridTest.MockMergableGridColumn gc8 = new BaseGridTest.MockMergableGridColumn("col8", 100.0);
        grid.appendColumn(gc1);
        grid.appendColumn(gc2);
        grid.appendColumn(gc3);
        grid.appendColumn(gc4);
        grid.appendColumn(gc5);
        grid.appendColumn(gc6);
        grid.appendColumn(gc7);
        grid.appendColumn(gc8);
        grid.moveColumnsTo(5, (List)new ArrayList<GridColumn<?>>((GridColumn)gc1, (GridColumn)gc2){
            final /* synthetic */ GridColumn val$gc1;
            final /* synthetic */ GridColumn val$gc2;
            {
                this.val$gc1 = gridColumn;
                this.val$gc2 = gridColumn2;
                this.add(this.val$gc1);
                this.add(this.val$gc2);
            }
        });
        List columns = grid.getColumns();
        Assert.assertEquals((long)8L, (long)columns.size());
        Assert.assertEquals((long)0L, (long)gc1.getIndex());
        Assert.assertEquals((long)1L, (long)gc2.getIndex());
        Assert.assertEquals((long)2L, (long)gc3.getIndex());
        Assert.assertEquals((long)3L, (long)gc4.getIndex());
        Assert.assertEquals((long)4L, (long)gc5.getIndex());
        Assert.assertEquals((long)5L, (long)gc6.getIndex());
        Assert.assertEquals((long)6L, (long)gc7.getIndex());
        Assert.assertEquals((long)7L, (long)gc8.getIndex());
        Assert.assertEquals(columns.get(0), gc3);
        Assert.assertEquals(columns.get(1), gc4);
        Assert.assertEquals(columns.get(2), gc5);
        Assert.assertEquals(columns.get(3), gc6);
        Assert.assertEquals(columns.get(4), gc1);
        Assert.assertEquals(columns.get(5), gc2);
        Assert.assertEquals(columns.get(6), gc7);
        Assert.assertEquals(columns.get(7), gc8);
    }

    @Test
    public void testRemoveRow() {
        BaseGridData grid = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        grid.appendColumn(gc1);
        grid.appendColumn(gc2);
        grid.appendColumn(gc3);
        BaseGridRow gr1 = new BaseGridRow();
        BaseGridRow gr2 = new BaseGridRow();
        BaseGridRow gr3 = new BaseGridRow();
        grid.appendRow((GridRow)gr1);
        grid.appendRow((GridRow)gr2);
        grid.appendRow((GridRow)gr3);
        grid.deleteRow(1);
        Assert.assertEquals((long)2L, (long)grid.getRowCount());
        Assert.assertEquals((Object)gr1, (Object)grid.getRow(0));
        Assert.assertEquals((Object)gr3, (Object)grid.getRow(1));
    }
}

