/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.model.impl;

import org.junit.Assert;
import org.junit.Test;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridTest;

public class GridColumnsTest
extends BaseGridTest {
    @Test
    public void testAppendColumn() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}});
        Assert.assertEquals((long)0L, (long)((GridColumn)data.getColumns().get(0)).getIndex());
        Assert.assertEquals((long)1L, (long)((GridColumn)data.getColumns().get(1)).getIndex());
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        data.appendColumn(gc3);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(false, 1, null)}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(false, 1, null)}});
        Assert.assertEquals((long)0L, (long)((GridColumn)data.getColumns().get(0)).getIndex());
        Assert.assertEquals((long)1L, (long)((GridColumn)data.getColumns().get(1)).getIndex());
        Assert.assertEquals((long)2L, (long)((GridColumn)data.getColumns().get(2)).getIndex());
    }

    @Test
    public void testInsertColumn() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}});
        Assert.assertEquals((long)0L, (long)((GridColumn)data.getColumns().get(0)).getIndex());
        Assert.assertEquals((long)1L, (long)((GridColumn)data.getColumns().get(1)).getIndex());
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        data.insertColumn(1, gc3);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, null), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, null), BaseGridTest.Expected.build(false, 1, "(1, 1)")}});
        Assert.assertEquals((long)0L, (long)((GridColumn)data.getColumns().get(0)).getIndex());
        Assert.assertEquals((long)2L, (long)((GridColumn)data.getColumns().get(1)).getIndex());
        Assert.assertEquals((long)1L, (long)((GridColumn)data.getColumns().get(2)).getIndex());
    }

    @Test
    public void testDeleteColumn() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendColumn(gc3);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(false, 1, "(2, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(false, 1, "(2, 1)")}});
        Assert.assertEquals((long)3L, (long)data.getRow(0).getCells().size());
        Assert.assertEquals((long)3L, (long)data.getRow(1).getCells().size());
        Assert.assertEquals((long)0L, (long)((GridColumn)data.getColumns().get(0)).getIndex());
        Assert.assertEquals((long)1L, (long)((GridColumn)data.getColumns().get(1)).getIndex());
        Assert.assertEquals((long)2L, (long)((GridColumn)data.getColumns().get(2)).getIndex());
        data.deleteColumn(gc2);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(2, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(2, 1)")}});
        Assert.assertEquals((long)2L, (long)data.getRow(0).getCells().size());
        Assert.assertEquals((long)2L, (long)data.getRow(1).getCells().size());
        Assert.assertEquals((long)0L, (long)((GridColumn)data.getColumns().get(0)).getIndex());
        Assert.assertEquals((long)1L, (long)((GridColumn)data.getColumns().get(1)).getIndex());
    }

    @Test
    public void testDeleteColumnThenInsertColumn() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendColumn(gc3);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(false, 1, "(2, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(false, 1, "(2, 1)")}});
        Assert.assertEquals((long)3L, (long)data.getRow(0).getCells().size());
        Assert.assertEquals((long)3L, (long)data.getRow(1).getCells().size());
        Assert.assertEquals((long)0L, (long)((GridColumn)data.getColumns().get(0)).getIndex());
        Assert.assertEquals((long)1L, (long)((GridColumn)data.getColumns().get(1)).getIndex());
        Assert.assertEquals((long)2L, (long)((GridColumn)data.getColumns().get(2)).getIndex());
        data.deleteColumn(gc2);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(2, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(2, 1)")}});
        Assert.assertEquals((long)2L, (long)data.getRow(0).getCells().size());
        Assert.assertEquals((long)2L, (long)data.getRow(1).getCells().size());
        Assert.assertEquals((long)0L, (long)((GridColumn)data.getColumns().get(0)).getIndex());
        Assert.assertEquals((long)1L, (long)((GridColumn)data.getColumns().get(1)).getIndex());
        BaseGridTest.MockMergableGridColumn gc4 = new BaseGridTest.MockMergableGridColumn("col4", 100.0);
        data.insertColumn(1, gc4);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, null), BaseGridTest.Expected.build(false, 1, "(2, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, null), BaseGridTest.Expected.build(false, 1, "(2, 1)")}});
        Assert.assertEquals((long)0L, (long)((GridColumn)data.getColumns().get(0)).getIndex());
        Assert.assertEquals((long)2L, (long)((GridColumn)data.getColumns().get(1)).getIndex());
        Assert.assertEquals((long)1L, (long)((GridColumn)data.getColumns().get(2)).getIndex());
    }

    @Test
    public void testInsertx2ColumnThenDeletex2Column() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendColumn(gc3);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(false, 1, "(2, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(false, 1, "(2, 1)")}});
        Assert.assertEquals((long)3L, (long)data.getRow(0).getCells().size());
        Assert.assertEquals((long)3L, (long)data.getRow(1).getCells().size());
        Assert.assertEquals((long)0L, (long)((GridColumn)data.getColumns().get(0)).getIndex());
        Assert.assertEquals((long)1L, (long)((GridColumn)data.getColumns().get(1)).getIndex());
        Assert.assertEquals((long)2L, (long)((GridColumn)data.getColumns().get(2)).getIndex());
        BaseGridTest.MockMergableGridColumn tgc1 = new BaseGridTest.MockMergableGridColumn("col4", 100.0);
        data.insertColumn(1, tgc1);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, null), BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(false, 1, "(2, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, null), BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(false, 1, "(2, 1)")}});
        Assert.assertEquals((long)3L, (long)data.getRow(0).getCells().size());
        Assert.assertEquals((long)3L, (long)data.getRow(1).getCells().size());
        Assert.assertEquals((long)0L, (long)((GridColumn)data.getColumns().get(0)).getIndex());
        Assert.assertEquals((long)3L, (long)((GridColumn)data.getColumns().get(1)).getIndex());
        Assert.assertEquals((long)1L, (long)((GridColumn)data.getColumns().get(2)).getIndex());
        Assert.assertEquals((long)2L, (long)((GridColumn)data.getColumns().get(3)).getIndex());
        BaseGridTest.MockMergableGridColumn tgc2 = new BaseGridTest.MockMergableGridColumn("col5", 100.0);
        data.insertColumn(1, tgc2);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, null), BaseGridTest.Expected.build(false, 1, null), BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(false, 1, "(2, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, null), BaseGridTest.Expected.build(false, 1, null), BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(false, 1, "(2, 1)")}});
        Assert.assertEquals((long)3L, (long)data.getRow(0).getCells().size());
        Assert.assertEquals((long)3L, (long)data.getRow(1).getCells().size());
        Assert.assertEquals((long)0L, (long)((GridColumn)data.getColumns().get(0)).getIndex());
        Assert.assertEquals((long)4L, (long)((GridColumn)data.getColumns().get(1)).getIndex());
        Assert.assertEquals((long)3L, (long)((GridColumn)data.getColumns().get(2)).getIndex());
        Assert.assertEquals((long)1L, (long)((GridColumn)data.getColumns().get(3)).getIndex());
        Assert.assertEquals((long)2L, (long)((GridColumn)data.getColumns().get(4)).getIndex());
        data.deleteColumn(tgc1);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, null), BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(false, 1, "(2, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, null), BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(false, 1, "(2, 1)")}});
        Assert.assertEquals((long)3L, (long)data.getRow(0).getCells().size());
        Assert.assertEquals((long)3L, (long)data.getRow(1).getCells().size());
        Assert.assertEquals((long)0L, (long)((GridColumn)data.getColumns().get(0)).getIndex());
        Assert.assertEquals((long)3L, (long)((GridColumn)data.getColumns().get(1)).getIndex());
        Assert.assertEquals((long)1L, (long)((GridColumn)data.getColumns().get(2)).getIndex());
        Assert.assertEquals((long)2L, (long)((GridColumn)data.getColumns().get(3)).getIndex());
        data.deleteColumn(tgc2);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(false, 1, "(2, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(false, 1, "(2, 1)")}});
        Assert.assertEquals((long)3L, (long)data.getRow(0).getCells().size());
        Assert.assertEquals((long)3L, (long)data.getRow(1).getCells().size());
        Assert.assertEquals((long)0L, (long)((GridColumn)data.getColumns().get(0)).getIndex());
        Assert.assertEquals((long)1L, (long)((GridColumn)data.getColumns().get(1)).getIndex());
        Assert.assertEquals((long)2L, (long)((GridColumn)data.getColumns().get(2)).getIndex());
    }

    @Test
    public void testInsertx2ColumnThenDeletex2ColumnReverseOrder() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendColumn(gc3);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(false, 1, "(2, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(false, 1, "(2, 1)")}});
        Assert.assertEquals((long)3L, (long)data.getRow(0).getCells().size());
        Assert.assertEquals((long)3L, (long)data.getRow(1).getCells().size());
        Assert.assertEquals((long)0L, (long)((GridColumn)data.getColumns().get(0)).getIndex());
        Assert.assertEquals((long)1L, (long)((GridColumn)data.getColumns().get(1)).getIndex());
        Assert.assertEquals((long)2L, (long)((GridColumn)data.getColumns().get(2)).getIndex());
        BaseGridTest.MockMergableGridColumn tgc1 = new BaseGridTest.MockMergableGridColumn("col4", 100.0);
        data.insertColumn(1, tgc1);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, null), BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(false, 1, "(2, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, null), BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(false, 1, "(2, 1)")}});
        Assert.assertEquals((long)3L, (long)data.getRow(0).getCells().size());
        Assert.assertEquals((long)3L, (long)data.getRow(1).getCells().size());
        Assert.assertEquals((long)0L, (long)((GridColumn)data.getColumns().get(0)).getIndex());
        Assert.assertEquals((long)3L, (long)((GridColumn)data.getColumns().get(1)).getIndex());
        Assert.assertEquals((long)1L, (long)((GridColumn)data.getColumns().get(2)).getIndex());
        Assert.assertEquals((long)2L, (long)((GridColumn)data.getColumns().get(3)).getIndex());
        BaseGridTest.MockMergableGridColumn tgc2 = new BaseGridTest.MockMergableGridColumn("col5", 100.0);
        data.insertColumn(1, tgc2);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, null), BaseGridTest.Expected.build(false, 1, null), BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(false, 1, "(2, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, null), BaseGridTest.Expected.build(false, 1, null), BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(false, 1, "(2, 1)")}});
        Assert.assertEquals((long)3L, (long)data.getRow(0).getCells().size());
        Assert.assertEquals((long)3L, (long)data.getRow(1).getCells().size());
        Assert.assertEquals((long)0L, (long)((GridColumn)data.getColumns().get(0)).getIndex());
        Assert.assertEquals((long)4L, (long)((GridColumn)data.getColumns().get(1)).getIndex());
        Assert.assertEquals((long)3L, (long)((GridColumn)data.getColumns().get(2)).getIndex());
        Assert.assertEquals((long)1L, (long)((GridColumn)data.getColumns().get(3)).getIndex());
        Assert.assertEquals((long)2L, (long)((GridColumn)data.getColumns().get(4)).getIndex());
        data.deleteColumn(tgc2);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, null), BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(false, 1, "(2, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, null), BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(false, 1, "(2, 1)")}});
        Assert.assertEquals((long)3L, (long)data.getRow(0).getCells().size());
        Assert.assertEquals((long)3L, (long)data.getRow(1).getCells().size());
        Assert.assertEquals((long)0L, (long)((GridColumn)data.getColumns().get(0)).getIndex());
        Assert.assertEquals((long)3L, (long)((GridColumn)data.getColumns().get(1)).getIndex());
        Assert.assertEquals((long)1L, (long)((GridColumn)data.getColumns().get(2)).getIndex());
        Assert.assertEquals((long)2L, (long)((GridColumn)data.getColumns().get(3)).getIndex());
        data.deleteColumn(tgc1);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(false, 1, "(2, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(false, 1, "(2, 1)")}});
        Assert.assertEquals((long)3L, (long)data.getRow(0).getCells().size());
        Assert.assertEquals((long)3L, (long)data.getRow(1).getCells().size());
        Assert.assertEquals((long)0L, (long)((GridColumn)data.getColumns().get(0)).getIndex());
        Assert.assertEquals((long)1L, (long)((GridColumn)data.getColumns().get(1)).getIndex());
        Assert.assertEquals((long)2L, (long)((GridColumn)data.getColumns().get(2)).getIndex());
    }

    @Test
    public void testMoveColumnThenDelete() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendColumn(gc3);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(false, 1, "(2, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(false, 1, "(2, 1)")}});
        Assert.assertEquals((long)3L, (long)data.getRow(0).getCells().size());
        Assert.assertEquals((long)3L, (long)data.getRow(1).getCells().size());
        Assert.assertEquals((long)0L, (long)((GridColumn)data.getColumns().get(0)).getIndex());
        Assert.assertEquals((long)1L, (long)((GridColumn)data.getColumns().get(1)).getIndex());
        Assert.assertEquals((long)2L, (long)((GridColumn)data.getColumns().get(2)).getIndex());
        data.moveColumnTo(0, gc3);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(2, 0)"), BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(false, 1, "(2, 1)"), BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}});
        Assert.assertEquals((long)3L, (long)data.getRow(0).getCells().size());
        Assert.assertEquals((long)3L, (long)data.getRow(1).getCells().size());
        Assert.assertEquals((long)2L, (long)((GridColumn)data.getColumns().get(0)).getIndex());
        Assert.assertEquals((long)0L, (long)((GridColumn)data.getColumns().get(1)).getIndex());
        Assert.assertEquals((long)1L, (long)((GridColumn)data.getColumns().get(2)).getIndex());
        data.deleteColumn(gc1);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(2, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(false, 1, "(2, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}});
        Assert.assertEquals((long)2L, (long)data.getRow(0).getCells().size());
        Assert.assertEquals((long)2L, (long)data.getRow(1).getCells().size());
        Assert.assertEquals((long)1L, (long)((GridColumn)data.getColumns().get(0)).getIndex());
        Assert.assertEquals((long)0L, (long)((GridColumn)data.getColumns().get(1)).getIndex());
    }

    @Test
    public void testUpdateColumn() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendColumn(gc3);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(false, 1, "(2, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(false, 1, "(2, 1)")}});
        Assert.assertEquals((long)3L, (long)data.getRow(0).getCells().size());
        Assert.assertEquals((long)3L, (long)data.getRow(1).getCells().size());
        Assert.assertEquals((long)0L, (long)((GridColumn)data.getColumns().get(0)).getIndex());
        Assert.assertEquals((long)1L, (long)((GridColumn)data.getColumns().get(1)).getIndex());
        Assert.assertEquals((long)2L, (long)((GridColumn)data.getColumns().get(2)).getIndex());
        BaseGridTest.MockMergableGridColumn gc4 = new BaseGridTest.MockMergableGridColumn("col4", 100.0);
        data.updateColumn(1, gc4);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, null), BaseGridTest.Expected.build(false, 1, "(2, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, null), BaseGridTest.Expected.build(false, 1, "(2, 1)")}});
        Assert.assertEquals((long)2L, (long)data.getRow(0).getCells().size());
        Assert.assertEquals((long)2L, (long)data.getRow(1).getCells().size());
        Assert.assertEquals((long)0L, (long)((GridColumn)data.getColumns().get(0)).getIndex());
        Assert.assertEquals((long)1L, (long)((GridColumn)data.getColumns().get(1)).getIndex());
        Assert.assertEquals((long)2L, (long)((GridColumn)data.getColumns().get(2)).getIndex());
        Assert.assertEquals(gc1, data.getColumns().get(0));
        Assert.assertEquals(gc4, data.getColumns().get(1));
        Assert.assertEquals(gc3, data.getColumns().get(2));
    }
}

