/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.impl;

import com.ait.lienzo.client.core.Context2D;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.Node;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.BoundingBox;
import com.ait.lienzo.client.core.types.Transform;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseHeaderMetaData;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridHeaderRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.dom.multiple.impl.CheckBoxDOMElementFactory;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.BooleanDOMElementColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.BaseGridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.CellSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.DefaultGridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;

@RunWith(value=LienzoMockitoTestRunner.class)
public class BaseGridWidgetRenderingTest {
    private static final double ROW_HEIGHT = 20.0;
    @Mock
    private Viewport viewport;
    @Mock
    private Transform transform;
    @Mock
    private DefaultGridLayer gridLayer;
    @Mock
    private GridSelectionManager selectionManager;
    @Mock
    private CellSelectionManager cellSelectionManager;
    @Mock
    private GridPinnedModeManager pinnedModeManager;
    @Mock
    private GridRenderer renderer;
    @Mock
    private BaseGridRendererHelper rendererHelper;
    @Mock
    private Group header;
    @Mock
    private Group body;
    @Mock
    private Group boundary;
    private BaseGridWidget gridWidget;
    private GridData model;

    @Before
    public void setup() {
        this.model = new BaseGridData();
        BaseGridWidget wrapped = new BaseGridWidget(this.model, this.selectionManager, this.pinnedModeManager, this.renderer){

            CellSelectionManager getCellSelectionManager() {
                return BaseGridWidgetRenderingTest.this.cellSelectionManager;
            }

            BaseGridRendererHelper getBaseGridRendererHelper() {
                return BaseGridWidgetRenderingTest.this.rendererHelper;
            }
        };
        this.gridWidget = (BaseGridWidget)Mockito.spy((Object)wrapped);
        this.mockCanvas();
        this.mockHeader();
        this.mockBody();
        this.mockBoundary();
    }

    private void mockCanvas() {
        Mockito.when((Object)this.gridWidget.getLayer()).thenReturn((Object)this.gridLayer);
        Mockito.when((Object)this.gridWidget.getViewport()).thenReturn((Object)this.viewport);
        Mockito.when((Object)this.viewport.getTransform()).thenReturn((Object)this.transform);
    }

    private void mockHeader() {
        Mockito.when((Object)this.renderer.renderHeader((GridData)Mockito.any(GridData.class), (GridHeaderRenderContext)Mockito.any(GridHeaderRenderContext.class), (BaseGridRendererHelper)Mockito.eq((Object)this.rendererHelper), (BaseGridRendererHelper.RenderingInformation)Mockito.any(BaseGridRendererHelper.RenderingInformation.class))).thenReturn((Object)this.header);
        Mockito.when((Object)this.header.asNode()).thenReturn(Mockito.mock(Node.class));
    }

    private void mockBody() {
        Mockito.when((Object)this.renderer.renderBody((GridData)Mockito.any(GridData.class), (GridBodyRenderContext)Mockito.any(GridBodyRenderContext.class), (BaseGridRendererHelper)Mockito.eq((Object)this.rendererHelper), (BaseGridRendererHelper.RenderingInformation)Mockito.any(BaseGridRendererHelper.RenderingInformation.class))).thenReturn((Object)this.body);
        Mockito.when((Object)this.body.asNode()).thenReturn(Mockito.mock(Node.class));
    }

    private void mockBoundary() {
        Mockito.when((Object)this.renderer.renderGridBoundary(((Double)Mockito.any(Double.class)).doubleValue(), ((Double)Mockito.any(Double.class)).doubleValue())).thenReturn((Object)this.boundary);
        Mockito.when((Object)this.boundary.asNode()).thenReturn(Mockito.mock(Node.class));
    }

    @Test
    public void renderingWithDOMElementColumnsAndRows() {
        BaseGridRendererHelper.RenderingInformation ri = this.makeRenderingInformation((List<Double>)new ArrayList<Double>(){
            {
                this.add(20.0);
            }
        });
        Mockito.when((Object)this.rendererHelper.getRenderingInformation()).thenReturn((Object)ri);
        BooleanDOMElementColumn column = (BooleanDOMElementColumn)Mockito.spy((Object)new BooleanDOMElementColumn((GridColumn.HeaderMetaData)new BaseHeaderMetaData("col1"), new CheckBoxDOMElementFactory((GridLayer)this.gridLayer, (GridWidget)this.gridWidget), 100.0));
        this.model.appendColumn((GridColumn)column);
        this.model.appendRow((GridRow)new BaseGridRow(20.0));
        Context2D context2D = (Context2D)Mockito.mock(Context2D.class);
        BoundingBox boundingBox = (BoundingBox)Mockito.mock(BoundingBox.class);
        this.gridWidget.drawWithTransforms(context2D, 1.0, boundingBox);
        ((BooleanDOMElementColumn)Mockito.verify((Object)column, (VerificationMode)Mockito.times((int)1))).initialiseResources();
        ((BooleanDOMElementColumn)Mockito.verify((Object)column, (VerificationMode)Mockito.times((int)1))).freeUnusedResources();
        ((BaseGridWidget)Mockito.verify((Object)this.gridWidget, (VerificationMode)Mockito.times((int)1))).drawHeader((BaseGridRendererHelper.RenderingInformation)Mockito.eq((Object)ri), Mockito.eq((boolean)false));
        ((BaseGridWidget)Mockito.verify((Object)this.gridWidget, (VerificationMode)Mockito.times((int)1))).drawBody((BaseGridRendererHelper.RenderingInformation)Mockito.eq((Object)ri), Mockito.eq((boolean)false));
    }

    @Test
    public void renderingWithDOMElementColumnsAndWithoutRows() {
        BaseGridRendererHelper.RenderingInformation ri = this.makeRenderingInformation(Collections.emptyList());
        Mockito.when((Object)this.rendererHelper.getRenderingInformation()).thenReturn((Object)ri);
        BooleanDOMElementColumn column = (BooleanDOMElementColumn)Mockito.spy((Object)new BooleanDOMElementColumn((GridColumn.HeaderMetaData)new BaseHeaderMetaData("col1"), new CheckBoxDOMElementFactory((GridLayer)this.gridLayer, (GridWidget)this.gridWidget), 100.0));
        this.model.appendColumn((GridColumn)column);
        Context2D context2D = (Context2D)Mockito.mock(Context2D.class);
        BoundingBox boundingBox = (BoundingBox)Mockito.mock(BoundingBox.class);
        this.gridWidget.drawWithTransforms(context2D, 1.0, boundingBox);
        ((BooleanDOMElementColumn)Mockito.verify((Object)column, (VerificationMode)Mockito.times((int)1))).initialiseResources();
        ((BooleanDOMElementColumn)Mockito.verify((Object)column, (VerificationMode)Mockito.times((int)1))).freeUnusedResources();
        ((BaseGridWidget)Mockito.verify((Object)this.gridWidget, (VerificationMode)Mockito.times((int)1))).drawHeader((BaseGridRendererHelper.RenderingInformation)Mockito.eq((Object)ri), Mockito.eq((boolean)false));
        ((BaseGridWidget)Mockito.verify((Object)this.gridWidget, (VerificationMode)Mockito.never())).drawBody((BaseGridRendererHelper.RenderingInformation)Mockito.any(BaseGridRendererHelper.RenderingInformation.class), ((Boolean)Mockito.any(Boolean.class)).booleanValue());
    }

    private BaseGridRendererHelper.RenderingInformation makeRenderingInformation(List<Double> rowOffsets) {
        return new BaseGridRendererHelper.RenderingInformation((Bounds)Mockito.mock(Bounds.class), this.model.getColumns(), new BaseGridRendererHelper.RenderingBlockInformation(this.model.getColumns(), 0.0, 0.0, 0.0, 100.0), new BaseGridRendererHelper.RenderingBlockInformation(Collections.emptyList(), 0.0, 0.0, 0.0, 0.0), 0, rowOffsets.size() - 1, rowOffsets, false, false, 0.0, 2.0, 0.0);
    }
}

