/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.impl;

import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.BaseGridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.CellSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.SelectionExtension;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;

@RunWith(value=LienzoMockitoTestRunner.class)
public class BaseGridWidgetTest {
    private GridWidget gridWidget;
    private GridData model;
    @Mock
    private GridSelectionManager selectionManager;
    @Mock
    private CellSelectionManager cellSelectionManager;
    @Mock
    private GridPinnedModeManager pinnedModeManager;
    @Mock
    private GridRenderer renderer;

    @Before
    public void setup() {
        this.model = new BaseGridData();
        BaseGridWidget wrapped = new BaseGridWidget(this.model, this.selectionManager, this.pinnedModeManager, this.renderer){

            CellSelectionManager getCellSelectionManager() {
                return BaseGridWidgetTest.this.cellSelectionManager;
            }
        };
        this.gridWidget = (GridWidget)Mockito.spy((Object)wrapped);
    }

    @Test
    public void selectCellMouseClick() {
        Point2D cp = new Point2D(10.0, 20.0);
        this.gridWidget.selectCell(cp, true, false);
        ArgumentCaptor pointArgumentCaptor = ArgumentCaptor.forClass(Point2D.class);
        ((CellSelectionManager)Mockito.verify((Object)this.cellSelectionManager, (VerificationMode)Mockito.times((int)1))).selectCell((Point2D)pointArgumentCaptor.capture(), Mockito.eq((boolean)true), Mockito.eq((boolean)false));
        Point2D point = (Point2D)pointArgumentCaptor.getValue();
        Assert.assertEquals((Object)cp, (Object)point);
    }

    @Test
    public void selectCellKeyboardNavigation() {
        this.gridWidget.selectCell(0, 1, true, false);
        ((CellSelectionManager)Mockito.verify((Object)this.cellSelectionManager, (VerificationMode)Mockito.times((int)1))).selectCell(Mockito.eq((int)0), Mockito.eq((int)1), Mockito.eq((boolean)true), Mockito.eq((boolean)false));
    }

    @Test
    public void adjustSelection() {
        this.gridWidget.adjustSelection(SelectionExtension.LEFT, false);
        ((CellSelectionManager)Mockito.verify((Object)this.cellSelectionManager, (VerificationMode)Mockito.times((int)1))).adjustSelection((SelectionExtension)Mockito.eq((Object)SelectionExtension.LEFT), Mockito.eq((boolean)false));
    }

    @Test
    public void startEditingCellMouseClick() {
        Point2D cp = new Point2D(10.0, 20.0);
        this.gridWidget.startEditingCell(cp);
        ArgumentCaptor pointArgumentCaptor = ArgumentCaptor.forClass(Point2D.class);
        ((CellSelectionManager)Mockito.verify((Object)this.cellSelectionManager, (VerificationMode)Mockito.times((int)1))).startEditingCell((Point2D)pointArgumentCaptor.capture());
        Point2D point = (Point2D)pointArgumentCaptor.getValue();
        Assert.assertEquals((Object)cp, (Object)point);
    }

    @Test
    public void startEditingCellKeyboardNavigation() {
        this.gridWidget.startEditingCell(0, 1);
        ((CellSelectionManager)Mockito.verify((Object)this.cellSelectionManager, (VerificationMode)Mockito.times((int)1))).startEditingCell(Mockito.eq((int)0), Mockito.eq((int)1));
    }
}

