/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.Collections;
import java.util.List;
import org.gwtbootstrap3.client.ui.html.Text;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseHeaderMetaData;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.StringPopupColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.GridColumnRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.SelectionsTransformer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.DefaultSelectionsTransformer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.SelectedRange;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.themes.GridRendererTheme;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.themes.impl.BlueTheme;

@WithClassesToStub(value={Text.class})
@RunWith(value=LienzoMockitoTestRunner.class)
public class BaseGridRendererTest {
    @Mock
    private GridColumnRenderer<String> columnRenderer;
    @Mock
    private GridBodyRenderContext context;
    @Mock
    private BaseGridRendererHelper rendererHelper;
    @Captor
    private ArgumentCaptor<List<GridColumn<?>>> columnsCaptor;
    @Captor
    private ArgumentCaptor<SelectedRange> selectedRangeCaptor;
    private GridData model;
    private GridColumn<String> column;
    private SelectionsTransformer selectionsTransformer;
    private GridRendererTheme theme = new BlueTheme();
    private BaseGridRenderer renderer;

    @Before
    public void setup() {
        BaseGridRenderer wrapped = new BaseGridRenderer(this.theme);
        this.renderer = (BaseGridRenderer)Mockito.spy((Object)wrapped);
        this.column = new StringPopupColumn((GridColumn.HeaderMetaData)new BaseHeaderMetaData("title"), this.columnRenderer, 100.0);
        this.model = new BaseGridData();
        this.model.appendColumn(this.column);
        this.model.appendRow((GridRow)new BaseGridRow());
        this.model.appendRow((GridRow)new BaseGridRow());
        this.model.appendRow((GridRow)new BaseGridRow());
        this.selectionsTransformer = new DefaultSelectionsTransformer(this.model, Collections.singletonList(this.column));
        Mockito.when((Object)this.context.getBlockColumns()).thenReturn(Collections.singletonList(this.column));
        Mockito.when((Object)this.context.getTransformer()).thenReturn((Object)this.selectionsTransformer);
    }

    @Test
    public void checkSelectedCellsClippedByHeader() {
        this.checkRenderedSelectedCells(0, 0, 1, 3, 1, 2);
    }

    @Test
    public void checkSelectedCellsNotClippedByHeader() {
        this.checkRenderedSelectedCells(0, 0, 1, 3, 0, 2);
    }

    private void checkRenderedSelectedCells(int selectionRowIndex, int selectionColumnIndex, int selectionColumnCount, int selectionRowCount, int minVisibleRowIndex, int maxVisibleRowIndex) {
        this.model.selectCells(selectionRowIndex, selectionColumnIndex, selectionColumnCount, selectionRowCount);
        Mockito.when((Object)this.context.getMinVisibleRowIndex()).thenReturn((Object)minVisibleRowIndex);
        Mockito.when((Object)this.context.getMaxVisibleRowIndex()).thenReturn((Object)maxVisibleRowIndex);
        this.renderer.renderSelectedCells(this.model, this.context, this.rendererHelper);
        ((BaseGridRenderer)Mockito.verify((Object)this.renderer, (VerificationMode)Mockito.times((int)1))).renderSelectedRange((GridData)Mockito.eq((Object)this.model), (List)this.columnsCaptor.capture(), Mockito.eq((int)selectionColumnIndex), (SelectedRange)this.selectedRangeCaptor.capture());
        List columns = (List)this.columnsCaptor.getValue();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)1L, (long)columns.size());
        Assert.assertEquals(this.column, columns.get(0));
        SelectedRange selectedRange = (SelectedRange)this.selectedRangeCaptor.getValue();
        Assert.assertNotNull((Object)selectedRange);
        Assert.assertEquals((long)selectionColumnIndex, (long)selectedRange.getUiColumnIndex());
        Assert.assertEquals((long)minVisibleRowIndex, (long)selectedRange.getUiRowIndex());
        Assert.assertEquals((long)selectionColumnCount, (long)selectedRange.getWidth());
        Assert.assertEquals((long)(maxVisibleRowIndex - minVisibleRowIndex + 1), (long)selectedRange.getHeight());
    }
}

