/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.selections.impl;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.client.core.types.Transform;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseBounds;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridTest;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.CellSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.SelectionExtension;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.impl.BaseCellSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.DefaultGridLayer;

@RunWith(value=LienzoMockitoTestRunner.class)
public class BaseCellSelectionManagerTest {
    private static final double HEADER_HEIGHT = 32.0;
    private static final double ROW_HEIGHT = 20.0;
    @Mock
    private GridWidget gridWidget;
    @Mock
    private DefaultGridLayer gridLayer;
    @Mock
    private GridRenderer gridWidgetRenderer;
    @Mock
    private Group gridWidgetHeader;
    @Mock
    private Viewport viewport;
    @Mock
    private Transform transform;
    private GridData gridWidgetData;
    private GridColumn<String> col1 = (GridColumn)Mockito.spy(new BaseGridTest.MockMergableGridColumn("col1", 100.0));
    private GridColumn<String> col2 = (GridColumn)Mockito.spy(new BaseGridTest.MockMergableGridColumn("col2", 100.0));
    private BaseGridRendererHelper gridWidgetRendererHelper;
    private Bounds visibleBounds = new BaseBounds(-1000.0, -1000.0, 2000.0, 2000.0);
    private CellSelectionManager cellSelectionManager;

    @Before
    public void setup() {
        this.gridWidgetData = new BaseGridData();
        this.gridWidgetData.appendRow((GridRow)new BaseGridRow(20.0));
        this.gridWidgetData.appendRow((GridRow)new BaseGridRow(20.0));
        this.gridWidgetData.appendColumn(this.col1);
        this.gridWidgetData.appendColumn(this.col2);
        Mockito.when((Object)this.gridWidget.getModel()).thenReturn((Object)this.gridWidgetData);
        this.cellSelectionManager = new BaseCellSelectionManager(this.gridWidget);
        this.gridWidgetRendererHelper = new BaseGridRendererHelper(this.gridWidget);
        Mockito.when((Object)this.gridWidget.getRenderer()).thenReturn((Object)this.gridWidgetRenderer);
        Mockito.when((Object)this.gridWidget.getRendererHelper()).thenReturn((Object)this.gridWidgetRendererHelper);
        Mockito.when((Object)this.gridWidget.getLayer()).thenReturn((Object)this.gridLayer);
        Mockito.when((Object)this.gridWidget.getWidth()).thenReturn((Object)200.0);
        Mockito.when((Object)this.gridWidget.getHeader()).thenReturn((Object)this.gridWidgetHeader);
        Mockito.when((Object)this.gridWidget.getHeight()).thenReturn((Object)72.0);
        Mockito.when((Object)this.gridWidget.getViewport()).thenReturn((Object)this.viewport);
        Mockito.when((Object)this.gridWidget.getX()).thenReturn((Object)0.0);
        Mockito.when((Object)this.gridWidget.getY()).thenReturn((Object)0.0);
        Mockito.when((Object)this.gridLayer.getVisibleBounds()).thenReturn((Object)this.visibleBounds);
        Mockito.when((Object)this.gridWidgetRenderer.getHeaderHeight()).thenReturn((Object)32.0);
        Mockito.when((Object)this.viewport.getTransform()).thenReturn((Object)this.transform);
    }

    @Test
    public void selectCellPointCoordinateOutsideGridBounds() {
        this.cellSelectionManager.selectCell(new Point2D(-10.0, -10.0), false, false);
        List selectedCells = this.gridWidgetData.getSelectedCells();
        Assert.assertTrue((boolean)selectedCells.isEmpty());
    }

    @Test
    public void selectCellPointCoordinateWithinGridBounds() {
        this.cellSelectionManager.selectCell(new Point2D(50.0, 42.0), false, false);
        List selectedCells = this.gridWidgetData.getSelectedCells();
        Assert.assertEquals((long)1L, (long)selectedCells.size());
        Assert.assertEquals((long)0L, (long)((GridData.SelectedCell)selectedCells.get(0)).getRowIndex());
        Assert.assertEquals((long)0L, (long)((GridData.SelectedCell)selectedCells.get(0)).getColumnIndex());
    }

    @Test
    public void selectCellPointCoordinateWithinGridBoundsWithShiftKey() {
        this.cellSelectionManager.selectCell(new Point2D(50.0, 42.0), false, false);
        this.cellSelectionManager.selectCell(new Point2D(150.0, 62.0), true, false);
        List selectedCells = this.gridWidgetData.getSelectedCells();
        Assert.assertEquals((long)4L, (long)selectedCells.size());
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(0, 1)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(0, 1)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(1, 1)));
        Assert.assertEquals((Object)new GridData.SelectedCell(0, 0), (Object)this.gridWidgetData.getSelectedCellsOrigin());
    }

    @Test
    public void selectCellPointCoordinateWithinGridBoundsWithControlKey() {
        this.cellSelectionManager.selectCell(new Point2D(50.0, 42.0), false, false);
        this.cellSelectionManager.selectCell(new Point2D(150.0, 62.0), false, true);
        List selectedCells = this.gridWidgetData.getSelectedCells();
        Assert.assertEquals((long)2L, (long)selectedCells.size());
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(1, 1)));
        Assert.assertEquals((Object)new GridData.SelectedCell(0, 0), (Object)this.gridWidgetData.getSelectedCellsOrigin());
    }

    @Test
    public void selectCellRowCoordinateLessThanZero() {
        this.cellSelectionManager.selectCell(-1, 0, false, false);
        List selectedCells = this.gridWidgetData.getSelectedCells();
        Assert.assertTrue((boolean)selectedCells.isEmpty());
    }

    @Test
    public void selectCellRowCoordinateGreaterThanRowCount() {
        this.cellSelectionManager.selectCell(2, 0, false, false);
        List selectedCells = this.gridWidgetData.getSelectedCells();
        Assert.assertTrue((boolean)selectedCells.isEmpty());
    }

    @Test
    public void selectCellColumnCoordinateLessThanZero() {
        this.cellSelectionManager.selectCell(0, -1, false, false);
        List selectedCells = this.gridWidgetData.getSelectedCells();
        Assert.assertTrue((boolean)selectedCells.isEmpty());
    }

    @Test
    public void selectCellColumnCoordinateGreaterThanColumnCount() {
        this.cellSelectionManager.selectCell(0, 2, false, false);
        List selectedCells = this.gridWidgetData.getSelectedCells();
        Assert.assertTrue((boolean)selectedCells.isEmpty());
    }

    @Test
    public void selectCellWithoutShiftKeyWithoutControlKey() {
        this.cellSelectionManager.selectCell(0, 0, false, false);
        List selectedCells = this.gridWidgetData.getSelectedCells();
        Assert.assertEquals((long)1L, (long)selectedCells.size());
        Assert.assertEquals((long)0L, (long)((GridData.SelectedCell)selectedCells.get(0)).getRowIndex());
        Assert.assertEquals((long)0L, (long)((GridData.SelectedCell)selectedCells.get(0)).getColumnIndex());
        Assert.assertEquals((Object)new GridData.SelectedCell(0, 0), (Object)this.gridWidgetData.getSelectedCellsOrigin());
    }

    @Test
    public void selectCellWithShiftKey() {
        this.cellSelectionManager.selectCell(0, 0, false, false);
        this.cellSelectionManager.selectCell(1, 1, true, false);
        List selectedCells = this.gridWidgetData.getSelectedCells();
        Assert.assertEquals((long)4L, (long)selectedCells.size());
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(0, 1)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(0, 1)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(1, 1)));
        Assert.assertEquals((Object)new GridData.SelectedCell(0, 0), (Object)this.gridWidgetData.getSelectedCellsOrigin());
    }

    @Test
    public void selectCellWithControlKey() {
        this.cellSelectionManager.selectCell(0, 0, false, false);
        this.cellSelectionManager.selectCell(1, 1, false, true);
        List selectedCells = this.gridWidgetData.getSelectedCells();
        Assert.assertEquals((long)2L, (long)selectedCells.size());
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(1, 1)));
    }

    @Test
    public void adjustSelectionLeft() {
        this.cellSelectionManager.selectCell(0, 1, false, false);
        this.cellSelectionManager.adjustSelection(SelectionExtension.LEFT, false);
        List selectedCells = this.gridWidgetData.getSelectedCells();
        Assert.assertEquals((long)1L, (long)selectedCells.size());
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(0, 0)));
        Assert.assertEquals((Object)new GridData.SelectedCell(0, 0), (Object)this.gridWidgetData.getSelectedCellsOrigin());
    }

    @Test
    public void adjustSelectionLeftWithShiftKey() {
        this.cellSelectionManager.selectCell(0, 1, false, false);
        this.cellSelectionManager.adjustSelection(SelectionExtension.LEFT, true);
        List selectedCells = this.gridWidgetData.getSelectedCells();
        Assert.assertEquals((long)2L, (long)selectedCells.size());
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(0, 1)));
        Assert.assertEquals((Object)new GridData.SelectedCell(0, 1), (Object)this.gridWidgetData.getSelectedCellsOrigin());
    }

    @Test
    public void adjustSelectionRight() {
        this.cellSelectionManager.selectCell(0, 0, false, false);
        this.cellSelectionManager.adjustSelection(SelectionExtension.RIGHT, false);
        List selectedCells = this.gridWidgetData.getSelectedCells();
        Assert.assertEquals((long)1L, (long)selectedCells.size());
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(0, 1)));
        Assert.assertEquals((Object)new GridData.SelectedCell(0, 1), (Object)this.gridWidgetData.getSelectedCellsOrigin());
    }

    @Test
    public void adjustSelectionRightWithShiftKey() {
        this.cellSelectionManager.selectCell(0, 0, false, false);
        this.cellSelectionManager.adjustSelection(SelectionExtension.RIGHT, true);
        List selectedCells = this.gridWidgetData.getSelectedCells();
        Assert.assertEquals((long)2L, (long)selectedCells.size());
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(0, 1)));
        Assert.assertEquals((Object)new GridData.SelectedCell(0, 0), (Object)this.gridWidgetData.getSelectedCellsOrigin());
    }

    @Test
    public void adjustSelectionUp() {
        this.cellSelectionManager.selectCell(1, 0, false, false);
        this.cellSelectionManager.adjustSelection(SelectionExtension.UP, false);
        List selectedCells = this.gridWidgetData.getSelectedCells();
        Assert.assertEquals((long)1L, (long)selectedCells.size());
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(0, 0)));
        Assert.assertEquals((Object)new GridData.SelectedCell(0, 0), (Object)this.gridWidgetData.getSelectedCellsOrigin());
    }

    @Test
    public void adjustSelectionUpWithShiftKey() {
        this.cellSelectionManager.selectCell(1, 0, false, false);
        this.cellSelectionManager.adjustSelection(SelectionExtension.UP, true);
        List selectedCells = this.gridWidgetData.getSelectedCells();
        Assert.assertEquals((long)2L, (long)selectedCells.size());
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(1, 0)));
        Assert.assertEquals((Object)new GridData.SelectedCell(1, 0), (Object)this.gridWidgetData.getSelectedCellsOrigin());
    }

    @Test
    public void adjustSelectionDown() {
        this.cellSelectionManager.selectCell(0, 0, false, false);
        this.cellSelectionManager.adjustSelection(SelectionExtension.DOWN, false);
        List selectedCells = this.gridWidgetData.getSelectedCells();
        Assert.assertEquals((long)1L, (long)selectedCells.size());
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(1, 0)));
        Assert.assertEquals((Object)new GridData.SelectedCell(1, 0), (Object)this.gridWidgetData.getSelectedCellsOrigin());
    }

    @Test
    public void adjustSelectionDownWithShiftKey() {
        this.cellSelectionManager.selectCell(0, 0, false, false);
        this.cellSelectionManager.adjustSelection(SelectionExtension.DOWN, true);
        List selectedCells = this.gridWidgetData.getSelectedCells();
        Assert.assertEquals((long)2L, (long)selectedCells.size());
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(1, 0)));
        Assert.assertEquals((Object)new GridData.SelectedCell(0, 0), (Object)this.gridWidgetData.getSelectedCellsOrigin());
    }

    @Test
    public void adjustSelectionRightDownWithShiftKey() {
        this.cellSelectionManager.selectCell(0, 0, false, false);
        this.cellSelectionManager.adjustSelection(SelectionExtension.RIGHT, true);
        this.cellSelectionManager.adjustSelection(SelectionExtension.DOWN, true);
        List selectedCells = this.gridWidgetData.getSelectedCells();
        Assert.assertEquals((long)4L, (long)selectedCells.size());
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(0, 1)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(1, 1)));
        Assert.assertEquals((Object)new GridData.SelectedCell(0, 0), (Object)this.gridWidgetData.getSelectedCellsOrigin());
    }

    @Test
    public void startEditingCellPointCoordinateOutsideGridBounds() {
        this.cellSelectionManager.startEditingCell(new Point2D(-10.0, -10.0));
        ((GridColumn)Mockito.verify(this.col1, (VerificationMode)Mockito.never())).edit((GridCell)Mockito.any(GridCell.class), (GridBodyCellRenderContext)Mockito.any(GridBodyCellRenderContext.class), (Callback)Mockito.any(Callback.class));
        ((GridColumn)Mockito.verify(this.col2, (VerificationMode)Mockito.never())).edit((GridCell)Mockito.any(GridCell.class), (GridBodyCellRenderContext)Mockito.any(GridBodyCellRenderContext.class), (Callback)Mockito.any(Callback.class));
    }

    @Test
    public void startEditingCellPointCoordinateWithinGridBounds() {
        ArgumentCaptor contextArgumentCaptor = ArgumentCaptor.forClass(GridBodyCellRenderContext.class);
        this.cellSelectionManager.startEditingCell(new Point2D(150.0, 42.0));
        ((GridColumn)Mockito.verify(this.col2, (VerificationMode)Mockito.times((int)1))).edit((GridCell)Mockito.any(GridCell.class), (GridBodyCellRenderContext)contextArgumentCaptor.capture(), (Callback)Mockito.any(Callback.class));
        GridBodyCellRenderContext context = (GridBodyCellRenderContext)contextArgumentCaptor.getValue();
        Assert.assertEquals((long)0L, (long)context.getRowIndex());
        Assert.assertEquals((long)1L, (long)context.getColumnIndex());
    }

    @Test
    public void startEditingCellCoordinateOutsideGridBounds() {
        this.cellSelectionManager.startEditingCell(-1, -1);
        ((GridColumn)Mockito.verify(this.col1, (VerificationMode)Mockito.never())).edit((GridCell)Mockito.any(GridCell.class), (GridBodyCellRenderContext)Mockito.any(GridBodyCellRenderContext.class), (Callback)Mockito.any(Callback.class));
        ((GridColumn)Mockito.verify(this.col2, (VerificationMode)Mockito.never())).edit((GridCell)Mockito.any(GridCell.class), (GridBodyCellRenderContext)Mockito.any(GridBodyCellRenderContext.class), (Callback)Mockito.any(Callback.class));
    }

    @Test
    public void startEditingCoordinateWithinGridBounds() {
        ArgumentCaptor contextArgumentCaptor = ArgumentCaptor.forClass(GridBodyCellRenderContext.class);
        this.cellSelectionManager.startEditingCell(0, 1);
        ((GridColumn)Mockito.verify(this.col2, (VerificationMode)Mockito.times((int)1))).edit((GridCell)Mockito.any(GridCell.class), (GridBodyCellRenderContext)contextArgumentCaptor.capture(), (Callback)Mockito.any(Callback.class));
        GridBodyCellRenderContext context = (GridBodyCellRenderContext)contextArgumentCaptor.getValue();
        Assert.assertEquals((long)0L, (long)context.getRowIndex());
        Assert.assertEquals((long)1L, (long)context.getColumnIndex());
    }
}

