/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridTest;

public class GridCellSelectionsTest
extends BaseGridTest {
    @Test
    public void testSelectCell() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
        data.selectCell(0, 0);
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 1)));
        Assert.assertEquals((long)1L, (long)data.getSelectedCells().size());
    }

    @Test
    public void testSelectCellMergedData() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(1, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 0)"));
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
        data.selectCell(0, 0);
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 1)));
        Assert.assertEquals((long)2L, (long)data.getSelectedCells().size());
    }

    @Test
    public void testSelectCellGroupedDataSelectGroupedCell() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(1, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 0)"));
        data.collapseCell(0, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false}, new boolean[]{false, true, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
        data.selectCell(0, 0);
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 1)));
        Assert.assertEquals((long)2L, (long)data.getSelectedCells().size());
    }

    @Test
    public void testSelectCellGroupedDataSelectMergedCell() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(1, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 0)"));
        data.collapseCell(0, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false}, new boolean[]{false, true, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
        data.selectCell(0, 1);
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 1)));
        Assert.assertEquals((long)2L, (long)data.getSelectedCells().size());
    }

    @Test
    public void testSelectCellMultipleTimes() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
        data.selectCell(0, 0);
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 1)));
        Assert.assertEquals((long)1L, (long)data.getSelectedCells().size());
        data.selectCell(0, 0);
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 1)));
        Assert.assertEquals((long)1L, (long)data.getSelectedCells().size());
    }

    @Test
    public void testClearSelections() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
        data.selectCell(0, 0);
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 1)));
        Assert.assertEquals((long)1L, (long)data.getSelectedCells().size());
        data.clearSelections();
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 1)));
        Assert.assertEquals((long)0L, (long)data.getSelectedCells().size());
    }

    @Test
    public void testSelectCellMoveColumn() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}});
        data.selectCell(0, 0);
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertEquals((long)1L, (long)data.getSelectedCells().size());
        Assert.assertEquals((Object)"(0, 0)", (Object)data.getCell(0, 0).getValue().getValue());
        Assert.assertEquals((Object)"(1, 0)", (Object)data.getCell(0, 1).getValue().getValue());
        Assert.assertEquals((Object)"(0, 1)", (Object)data.getCell(1, 0).getValue().getValue());
        Assert.assertEquals((Object)"(1, 1)", (Object)data.getCell(1, 1).getValue().getValue());
        data.moveColumnTo(1, gc1);
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertEquals((long)1L, (long)data.getSelectedCells().size());
        Assert.assertEquals((Object)"(1, 0)", (Object)data.getCell(0, 0).getValue().getValue());
        Assert.assertEquals((Object)"(0, 0)", (Object)data.getCell(0, 1).getValue().getValue());
        Assert.assertEquals((Object)"(1, 1)", (Object)data.getCell(1, 0).getValue().getValue());
        Assert.assertEquals((Object)"(0, 1)", (Object)data.getCell(1, 1).getValue().getValue());
    }

    @Test
    public void testMoveColumnSelectCell() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}});
        data.moveColumnTo(1, gc1);
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertEquals((long)0L, (long)data.getSelectedCells().size());
        Assert.assertEquals((Object)"(1, 0)", (Object)data.getCell(0, 0).getValue().getValue());
        Assert.assertEquals((Object)"(0, 0)", (Object)data.getCell(0, 1).getValue().getValue());
        Assert.assertEquals((Object)"(1, 1)", (Object)data.getCell(1, 0).getValue().getValue());
        Assert.assertEquals((Object)"(0, 1)", (Object)data.getCell(1, 1).getValue().getValue());
        data.selectCell(0, 0);
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertEquals((long)1L, (long)data.getSelectedCells().size());
        Assert.assertEquals((Object)"(1, 0)", (Object)data.getCell(0, 0).getValue().getValue());
        Assert.assertEquals((Object)"(0, 0)", (Object)data.getCell(0, 1).getValue().getValue());
        Assert.assertEquals((Object)"(1, 1)", (Object)data.getCell(1, 0).getValue().getValue());
        Assert.assertEquals((Object)"(0, 1)", (Object)data.getCell(1, 1).getValue().getValue());
    }

    @Test
    public void testSelectCellsMoveColumn() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendColumn(gc3);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(false, 1, "(2, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(false, 1, "(2, 1)")}});
        data.selectCells(0, 0, 2, 1);
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 2)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 2)));
        Assert.assertEquals((long)2L, (long)data.getSelectedCells().size());
        Assert.assertEquals((Object)"(0, 0)", (Object)data.getCell(0, 0).getValue().getValue());
        Assert.assertEquals((Object)"(1, 0)", (Object)data.getCell(0, 1).getValue().getValue());
        Assert.assertEquals((Object)"(2, 0)", (Object)data.getCell(0, 2).getValue().getValue());
        Assert.assertEquals((Object)"(0, 1)", (Object)data.getCell(1, 0).getValue().getValue());
        Assert.assertEquals((Object)"(1, 1)", (Object)data.getCell(1, 1).getValue().getValue());
        Assert.assertEquals((Object)"(2, 1)", (Object)data.getCell(1, 2).getValue().getValue());
        data.moveColumnTo(1, gc3);
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 2)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 2)));
        Assert.assertEquals((long)2L, (long)data.getSelectedCells().size());
        Assert.assertEquals((Object)"(0, 0)", (Object)data.getCell(0, 0).getValue().getValue());
        Assert.assertEquals((Object)"(2, 0)", (Object)data.getCell(0, 1).getValue().getValue());
        Assert.assertEquals((Object)"(1, 0)", (Object)data.getCell(0, 2).getValue().getValue());
        Assert.assertEquals((Object)"(0, 1)", (Object)data.getCell(1, 0).getValue().getValue());
        Assert.assertEquals((Object)"(2, 1)", (Object)data.getCell(1, 1).getValue().getValue());
        Assert.assertEquals((Object)"(1, 1)", (Object)data.getCell(1, 2).getValue().getValue());
    }

    @Test
    public void testMoveColumnSelectCells() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendColumn(gc3);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(false, 1, "(2, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(false, 1, "(2, 1)")}});
        data.moveColumnTo(1, gc3);
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 2)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 2)));
        Assert.assertEquals((long)0L, (long)data.getSelectedCells().size());
        Assert.assertEquals((Object)"(0, 0)", (Object)data.getCell(0, 0).getValue().getValue());
        Assert.assertEquals((Object)"(2, 0)", (Object)data.getCell(0, 1).getValue().getValue());
        Assert.assertEquals((Object)"(1, 0)", (Object)data.getCell(0, 2).getValue().getValue());
        Assert.assertEquals((Object)"(0, 1)", (Object)data.getCell(1, 0).getValue().getValue());
        Assert.assertEquals((Object)"(2, 1)", (Object)data.getCell(1, 1).getValue().getValue());
        Assert.assertEquals((Object)"(1, 1)", (Object)data.getCell(1, 2).getValue().getValue());
        data.selectCells(0, 0, 2, 1);
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 2)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 2)));
        Assert.assertEquals((long)2L, (long)data.getSelectedCells().size());
        Assert.assertEquals((Object)"(0, 0)", (Object)data.getCell(0, 0).getValue().getValue());
        Assert.assertEquals((Object)"(2, 0)", (Object)data.getCell(0, 1).getValue().getValue());
        Assert.assertEquals((Object)"(1, 0)", (Object)data.getCell(0, 2).getValue().getValue());
        Assert.assertEquals((Object)"(0, 1)", (Object)data.getCell(1, 0).getValue().getValue());
        Assert.assertEquals((Object)"(2, 1)", (Object)data.getCell(1, 1).getValue().getValue());
        Assert.assertEquals((Object)"(1, 1)", (Object)data.getCell(1, 2).getValue().getValue());
    }

    @Test
    public void testSelectCellMergedDataInsertRow() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            data.setCell(rowIndex, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 0)"));
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "(0, 0)")}, {BaseGridTest.Expected.build(true, 0, "(0, 0)")}});
        data.selectCell(0, 0);
        Assert.assertEquals((long)2L, (long)data.getSelectedCells().size());
        data.insertRow(1, (GridRow)new BaseGridRow());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertEquals((long)2L, (long)data.getSelectedCells().size());
    }

    @Test
    public void testSelectCellUnmergedDataInsertRow() {
        BaseGridData data = new BaseGridData(false);
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            data.setCell(rowIndex, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 0)"));
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 0)")}});
        data.selectCell(0, 0);
        data.selectCell(1, 0);
        Assert.assertEquals((long)2L, (long)data.getSelectedCells().size());
        data.insertRow(1, (GridRow)new BaseGridRow());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertEquals((long)2L, (long)data.getSelectedCells().size());
    }

    @Test
    public void testSelectCellMergedDataDeleteRow() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            data.setCell(rowIndex, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 0)"));
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "(0, 0)")}, {BaseGridTest.Expected.build(true, 0, "(0, 0)")}});
        data.selectCell(0, 0);
        Assert.assertEquals((long)2L, (long)data.getSelectedCells().size());
        data.deleteRow(1);
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertEquals((long)1L, (long)data.getSelectedCells().size());
    }

    @Test
    public void testSelectCellMergedDataDeleteRowWithAdditionalSelections() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            data.setCell(rowIndex, 0, (GridCellValue)new BaseGridCellValue((Object)(rowIndex < 2 ? "a" : "b")));
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "a")}, {BaseGridTest.Expected.build(true, 0, "a")}, {BaseGridTest.Expected.build(false, 1, "b")}});
        data.selectCell(0, 0);
        data.selectCell(2, 0);
        Assert.assertEquals((long)3L, (long)data.getSelectedCells().size());
        data.deleteRow(1);
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertEquals((long)2L, (long)data.getSelectedCells().size());
    }

    @Test
    public void testSelectCellGroupedDataDeleteRow() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            data.setCell(rowIndex, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 0)"));
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "(0, 0)")}, {BaseGridTest.Expected.build(true, 0, "(0, 0)")}});
        data.selectCell(0, 0);
        data.collapseCell(0, 0);
        Assert.assertEquals((long)2L, (long)data.getSelectedCells().size());
        data.deleteRow(0);
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertEquals((long)0L, (long)data.getSelectedCells().size());
    }

    @Test
    public void testSelectCellGroupedDataDeleteRowWithAdditionalSelections() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            data.setCell(rowIndex, 0, (GridCellValue)new BaseGridCellValue((Object)(rowIndex < 2 ? "a" : "b")));
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "a")}, {BaseGridTest.Expected.build(true, 0, "a")}, {BaseGridTest.Expected.build(false, 1, "b")}});
        data.selectCell(0, 0);
        data.selectCell(2, 0);
        data.collapseCell(0, 0);
        Assert.assertEquals((long)3L, (long)data.getSelectedCells().size());
        data.deleteRow(0);
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertEquals((long)1L, (long)data.getSelectedCells().size());
    }

    @Test
    public void testSelectCellUnmergedDataDeleteRow() {
        BaseGridData data = new BaseGridData(false);
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            data.setCell(rowIndex, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 0)"));
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 0)")}});
        data.selectCell(0, 0);
        data.selectCell(1, 0);
        Assert.assertEquals((long)2L, (long)data.getSelectedCells().size());
        data.deleteRow(1);
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertEquals((long)1L, (long)data.getSelectedCells().size());
    }

    @Test
    public void testSelectCellInsertColumn() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            data.setCell(rowIndex, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 0)"));
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "(0, 0)")}, {BaseGridTest.Expected.build(true, 0, "(0, 0)")}});
        data.selectCell(0, 0);
        Assert.assertEquals((long)2L, (long)data.getSelectedCells().size());
        data.insertColumn(0, new BaseGridTest.MockMergableGridColumn("col1", 100.0));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertEquals((long)2L, (long)data.getSelectedCells().size());
    }

    @Test
    public void testSelectCellDeleteColumn() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
            data.setCell(0, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(0, " + columnIndex + ")")));
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false}, new boolean[]{false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(0, 1)")}});
        data.selectCell(0, 0);
        Assert.assertEquals((long)1L, (long)data.getSelectedCells().size());
        data.deleteColumn(gc1);
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertEquals((long)0L, (long)data.getSelectedCells().size());
    }

    @Test
    public void testSelectCellDeleteColumnWithAdditionalSelections() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
            data.setCell(0, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(0, " + columnIndex + ")")));
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false}, new boolean[]{false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(0, 1)")}});
        data.selectCell(0, 0);
        data.selectCell(0, 1);
        Assert.assertEquals((long)2L, (long)data.getSelectedCells().size());
        data.deleteColumn(gc1);
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertEquals((long)1L, (long)data.getSelectedCells().size());
    }

    @Test
    public void testSelectCellMoveColumnDeleteColumn() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
            data.setCell(0, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(0, " + columnIndex + ")")));
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false}, new boolean[]{false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(0, 1)")}});
        data.selectCell(0, 0);
        Assert.assertEquals((long)1L, (long)data.getSelectedCells().size());
        data.moveColumnTo(1, gc1);
        data.deleteColumn(gc1);
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertEquals((long)0L, (long)data.getSelectedCells().size());
    }

    @Test
    public void testSelectCellMoveColumnToSplitSelectionsDeleteColumn() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        BaseGridTest.MockMergableGridColumn gc4 = new BaseGridTest.MockMergableGridColumn("col4", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendColumn(gc3);
        data.appendColumn(gc4);
        data.appendRow((GridRow)new BaseGridRow());
        for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
            data.setCell(0, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(0, " + columnIndex + ")")));
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false}, new boolean[]{false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(0, 3)")}});
        data.selectCell(0, 0);
        data.selectCell(0, 1);
        data.selectCell(0, 2);
        Assert.assertEquals((long)3L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 2)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 3)));
        data.moveColumnTo(1, gc4);
        data.deleteColumn(gc2);
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 2)));
        Assert.assertEquals((long)2L, (long)data.getSelectedCells().size());
    }

    @Test
    public void testUnmergedMoveRowUpWithSelections() {
        BaseGridData data = new BaseGridData(false);
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? (rowIndex == 1 ? "b" : "a") : Integer.toString(rowIndex);
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(false, 1, "2")}});
        data.selectCell(1, 0);
        data.selectCell(1, 1);
        Assert.assertEquals((long)2L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        data.moveRowTo(0, (GridRow)row1);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(false, 1, "2")}});
        Assert.assertEquals((long)2L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
    }

    @Test
    public void testUnmergedMoveRowDownWithSelections() {
        BaseGridData data = new BaseGridData(false);
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? (rowIndex == 0 ? "b" : "a") : Integer.toString(rowIndex);
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(false, 1, "2")}});
        data.selectCell(0, 0);
        data.selectCell(0, 1);
        Assert.assertEquals((long)2L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        data.moveRowTo(1, (GridRow)row0);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(false, 1, "2")}});
        Assert.assertEquals((long)2L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
    }

    @Test
    public void testMergedMoveRowUpWithSelections1() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? (rowIndex == 4 ? "b" : "a") : Integer.toString(rowIndex);
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 4, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "4")}});
        data.selectCell(0, 1);
        data.selectCell(4, 0);
        Assert.assertEquals((long)2L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(4, 0)));
        data.moveRowTo(3, (GridRow)row4);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, false, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "4")}, {BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(false, 1, "3")}});
        Assert.assertEquals((long)2L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(3, 0)));
    }

    @Test
    public void testMergedMoveRowUpWithSelections2() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? (rowIndex == 4 ? "b" : "a") : Integer.toString(rowIndex);
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 4, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "4")}});
        data.selectCell(0, 0);
        data.selectCell(4, 0);
        Assert.assertEquals((long)5L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(3, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(4, 0)));
        data.moveRowTo(3, (GridRow)row4);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, false, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "4")}, {BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(false, 1, "3")}});
        Assert.assertEquals((long)5L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(3, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(4, 0)));
    }

    @Test
    public void testMergedMoveRowUpWithSelections3() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? "a" : Integer.toString(rowIndex);
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 5, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "4")}});
        data.selectCell(0, 0);
        Assert.assertEquals((long)5L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(3, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(4, 0)));
        data.moveRowTo(3, (GridRow)row4);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 5, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "4")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}});
        Assert.assertEquals((long)5L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(3, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(4, 0)));
    }

    @Test
    public void testMergedMoveRowUpWithSelections4() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? "a" : Integer.toString(rowIndex);
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 5, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "4")}});
        data.selectCell(0, 0);
        Assert.assertEquals((long)5L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(3, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(4, 0)));
        data.moveRowTo(2, (GridRow)row3);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 5, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "4")}});
        Assert.assertEquals((long)5L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(3, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(4, 0)));
    }

    @Test
    public void testMergedMoveRowDownWithSelections1() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? (rowIndex == 4 ? "b" : "a") : Integer.toString(rowIndex);
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 4, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "4")}});
        data.selectCell(0, 1);
        data.selectCell(4, 0);
        Assert.assertEquals((long)2L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(4, 0)));
        data.moveRowTo(4, (GridRow)row3);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, false, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "4")}, {BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(false, 1, "3")}});
        Assert.assertEquals((long)2L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(3, 0)));
    }

    @Test
    public void testMergedMoveRowDownWithSelections2() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? (rowIndex == 4 ? "b" : "a") : Integer.toString(rowIndex);
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 4, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "4")}});
        data.selectCell(0, 0);
        data.selectCell(4, 0);
        Assert.assertEquals((long)5L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(3, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(4, 0)));
        data.moveRowTo(4, (GridRow)row3);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, false, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "4")}, {BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(false, 1, "3")}});
        Assert.assertEquals((long)5L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(3, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(4, 0)));
    }

    @Test
    public void testMergedMoveRowDownWithSelections3() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? "a" : Integer.toString(rowIndex);
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 5, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "4")}});
        data.selectCell(0, 0);
        Assert.assertEquals((long)5L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(3, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(4, 0)));
        data.moveRowTo(4, (GridRow)row3);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 5, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "4")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}});
        Assert.assertEquals((long)5L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(3, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(4, 0)));
    }

    @Test
    public void testMergedMoveRowDownWithSelections4() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? "a" : Integer.toString(rowIndex);
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 5, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "4")}});
        data.selectCell(0, 0);
        Assert.assertEquals((long)5L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(3, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(4, 0)));
        data.moveRowTo(1, (GridRow)row0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 5, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "4")}});
        Assert.assertEquals((long)5L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(3, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(4, 0)));
    }

    @Test
    public void testGroupedMoveRowUpWithSelections1() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? (rowIndex == 4 ? "b" : "a") : Integer.toString(rowIndex);
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        data.collapseCell(0, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, false}, new boolean[]{false, true, true, true, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 4, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "4")}});
        data.selectCell(0, 1);
        data.selectCell(4, 0);
        Assert.assertEquals((long)5L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(3, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(4, 0)));
        data.moveRowsTo(0, (List)new ArrayList<GridRow>((GridRow)row4){
            final /* synthetic */ GridRow val$row4;
            {
                this.val$row4 = gridRow;
                this.add(this.val$row4);
            }
        });
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, true}, new boolean[]{false, false, true, true, true}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "4")}, {BaseGridTest.Expected.build(true, 4, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}});
        Assert.assertEquals((long)5L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(3, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(4, 1)));
    }

    @Test
    public void testGroupedMoveRowUpWithSelections2() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? (rowIndex == 4 ? "b" : "a") : Integer.toString(rowIndex);
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 4, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "4")}});
        data.collapseCell(0, 0);
        data.selectCell(0, 0);
        data.selectCell(4, 0);
        Assert.assertEquals((long)5L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(3, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(4, 0)));
        data.moveRowsTo(0, (List)new ArrayList<GridRow>((GridRow)row4){
            final /* synthetic */ GridRow val$row4;
            {
                this.val$row4 = gridRow;
                this.add(this.val$row4);
            }
        });
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, true}, new boolean[]{false, false, true, true, true}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "4")}, {BaseGridTest.Expected.build(true, 4, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}});
        Assert.assertEquals((long)5L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(3, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(4, 0)));
    }

    @Test
    public void testGroupedMoveRowUpWithSelections3() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? (rowIndex == 0 ? "b" : "a") : Integer.toString(rowIndex);
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 4, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "4")}});
        data.collapseCell(1, 0);
        data.selectCell(0, 0);
        data.selectCell(1, 0);
        Assert.assertEquals((long)5L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(3, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(4, 0)));
        data.moveRowsTo(0, (List)new ArrayList<GridRow>((GridRow)row1, (GridRow)row2, (GridRow)row3, (GridRow)row4){
            final /* synthetic */ GridRow val$row1;
            final /* synthetic */ GridRow val$row2;
            final /* synthetic */ GridRow val$row3;
            final /* synthetic */ GridRow val$row4;
            {
                this.val$row1 = gridRow;
                this.val$row2 = gridRow2;
                this.val$row3 = gridRow3;
                this.val$row4 = gridRow4;
                this.add(this.val$row1);
                this.add(this.val$row2);
                this.add(this.val$row3);
                this.add(this.val$row4);
            }
        });
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, false}, new boolean[]{false, true, true, true, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 4, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "4")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "0")}});
        Assert.assertEquals((long)5L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(3, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(4, 0)));
    }

    @Test
    public void testGroupedMoveRowDownWithSelections1() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? (rowIndex == 4 ? "b" : "a") : Integer.toString(rowIndex);
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 4, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "4")}});
        data.collapseCell(0, 0);
        data.selectCell(0, 1);
        data.selectCell(4, 0);
        Assert.assertEquals((long)5L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(3, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(4, 0)));
        data.moveRowsTo(4, (List)new ArrayList<GridRow>((GridRow)row0, (GridRow)row1, (GridRow)row2, (GridRow)row3){
            final /* synthetic */ GridRow val$row0;
            final /* synthetic */ GridRow val$row1;
            final /* synthetic */ GridRow val$row2;
            final /* synthetic */ GridRow val$row3;
            {
                this.val$row0 = gridRow;
                this.val$row1 = gridRow2;
                this.val$row2 = gridRow3;
                this.val$row3 = gridRow4;
                this.add(this.val$row0);
                this.add(this.val$row1);
                this.add(this.val$row2);
                this.add(this.val$row3);
            }
        });
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, true}, new boolean[]{false, false, true, true, true}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "4")}, {BaseGridTest.Expected.build(true, 4, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}});
        Assert.assertEquals((long)5L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(3, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(4, 1)));
    }

    @Test
    public void testGroupedMoveRowDownWithSelections2() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? (rowIndex == 4 ? "b" : "a") : Integer.toString(rowIndex);
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 4, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "4")}});
        data.collapseCell(0, 0);
        data.selectCell(0, 0);
        data.selectCell(4, 0);
        Assert.assertEquals((long)5L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(3, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(4, 0)));
        data.moveRowsTo(4, (List)new ArrayList<GridRow>((GridRow)row0, (GridRow)row1, (GridRow)row2, (GridRow)row3){
            final /* synthetic */ GridRow val$row0;
            final /* synthetic */ GridRow val$row1;
            final /* synthetic */ GridRow val$row2;
            final /* synthetic */ GridRow val$row3;
            {
                this.val$row0 = gridRow;
                this.val$row1 = gridRow2;
                this.val$row2 = gridRow3;
                this.val$row3 = gridRow4;
                this.add(this.val$row0);
                this.add(this.val$row1);
                this.add(this.val$row2);
                this.add(this.val$row3);
            }
        });
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, true}, new boolean[]{false, false, true, true, true}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "4")}, {BaseGridTest.Expected.build(true, 4, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}});
        Assert.assertEquals((long)5L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(3, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(4, 0)));
    }

    @Test
    public void testGroupedMoveRowDownWithSelections3() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? (rowIndex == 0 ? "b" : "a") : Integer.toString(rowIndex);
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 4, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "4")}});
        data.collapseCell(1, 0);
        data.selectCell(0, 0);
        data.selectCell(1, 0);
        Assert.assertEquals((long)5L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(3, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(4, 0)));
        data.moveRowsTo(4, (List)new ArrayList<GridRow>((GridRow)row0){
            final /* synthetic */ GridRow val$row0;
            {
                this.val$row0 = gridRow;
                this.add(this.val$row0);
            }
        });
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, false}, new boolean[]{false, true, true, true, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 4, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "4")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "0")}});
        Assert.assertEquals((long)5L, (long)data.getSelectedCells().size());
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(3, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(4, 0)));
    }

    @Test
    public void testSelectCellSelectedRangeChangeTopLeft() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendColumn(gc3);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(false, 1, "(2, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(false, 1, "(2, 1)")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)"), BaseGridTest.Expected.build(false, 1, "(2, 2)")}});
        data.selectCell(1, 1);
        Assert.assertEquals((long)1L, (long)data.getSelectedCells().size());
        Assert.assertEquals((Object)data.getSelectedCellsOrigin(), (Object)new GridData.SelectedCell(1, 1));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        data.selectCells(0, 0, 2, 2);
        Assert.assertEquals((long)4L, (long)data.getSelectedCells().size());
        Assert.assertEquals((Object)data.getSelectedCellsOrigin(), (Object)new GridData.SelectedCell(1, 1));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
    }

    @Test
    public void testSelectCellSelectedRangeChangeTopRight() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendColumn(gc3);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(false, 1, "(2, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(false, 1, "(2, 1)")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)"), BaseGridTest.Expected.build(false, 1, "(2, 2)")}});
        data.selectCell(1, 1);
        Assert.assertEquals((long)1L, (long)data.getSelectedCells().size());
        Assert.assertEquals((Object)data.getSelectedCellsOrigin(), (Object)new GridData.SelectedCell(1, 1));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        data.selectCells(0, 1, 2, 2);
        Assert.assertEquals((long)4L, (long)data.getSelectedCells().size());
        Assert.assertEquals((Object)data.getSelectedCellsOrigin(), (Object)new GridData.SelectedCell(1, 1));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 2)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 2)));
    }

    @Test
    public void testSelectCellSelectedRangeChangeBottomLeft() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendColumn(gc3);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(false, 1, "(2, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(false, 1, "(2, 1)")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)"), BaseGridTest.Expected.build(false, 1, "(2, 2)")}});
        data.selectCell(1, 1);
        Assert.assertEquals((long)1L, (long)data.getSelectedCells().size());
        Assert.assertEquals((Object)data.getSelectedCellsOrigin(), (Object)new GridData.SelectedCell(1, 1));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        data.selectCells(1, 0, 2, 2);
        Assert.assertEquals((long)4L, (long)data.getSelectedCells().size());
        Assert.assertEquals((Object)data.getSelectedCellsOrigin(), (Object)new GridData.SelectedCell(1, 1));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 1)));
    }

    @Test
    public void testSelectCellSelectedRangeChangeBottomRight() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendColumn(gc3);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(false, 1, "(2, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(false, 1, "(2, 1)")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)"), BaseGridTest.Expected.build(false, 1, "(2, 2)")}});
        data.selectCell(1, 1);
        Assert.assertEquals((long)1L, (long)data.getSelectedCells().size());
        Assert.assertEquals((Object)data.getSelectedCellsOrigin(), (Object)new GridData.SelectedCell(1, 1));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        data.selectCells(1, 1, 2, 2);
        Assert.assertEquals((long)4L, (long)data.getSelectedCells().size());
        Assert.assertEquals((Object)data.getSelectedCellsOrigin(), (Object)new GridData.SelectedCell(1, 1));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 2)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 2)));
    }
}

