/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.dnd;

import com.ait.lienzo.client.core.event.NodeMouseDownEvent;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Style;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.widget.dnd.GridWidgetDnDHandlersState;
import org.uberfire.ext.wires.core.grids.client.widget.dnd.GridWidgetDnDMouseDownHandler;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;

@RunWith(value=LienzoMockitoTestRunner.class)
public class GridWidgetDnDMouseDownHandlerTest {
    @Mock
    private GridLayer layer;
    @Mock
    private Viewport viewport;
    @Mock
    private DivElement element;
    @Mock
    private Style style;
    @Mock
    private GridWidget gridWidget;
    @Mock
    private BaseGridRendererHelper helper;
    @Mock
    private GridColumn<String> uiColumn;
    @Mock
    private GridRow uiRow;
    @Mock
    private NodeMouseDownEvent event;
    @Captor
    private ArgumentCaptor<List<GridColumn<?>>> uiColumnsArgumentCaptor;
    @Captor
    private ArgumentCaptor<List<GridRow>> uiRowsArgumentCaptor;
    private GridWidgetDnDHandlersState state;
    private GridWidgetDnDMouseDownHandler handler;

    @Before
    public void setup() {
        Mockito.when((Object)this.layer.getViewport()).thenReturn((Object)this.viewport);
        Mockito.when((Object)this.viewport.getElement()).thenReturn((Object)this.element);
        Mockito.when((Object)this.element.getStyle()).thenReturn((Object)this.style);
        Mockito.when((Object)this.gridWidget.getViewport()).thenReturn((Object)this.viewport);
        Mockito.when((Object)this.gridWidget.getRendererHelper()).thenReturn((Object)this.helper);
        Mockito.when((Object)this.gridWidget.getLocation()).thenReturn((Object)new Point2D(100.0, 100.0));
        GridWidgetDnDHandlersState wrappedState = new GridWidgetDnDHandlersState();
        this.state = (GridWidgetDnDHandlersState)Mockito.spy((Object)wrappedState);
        GridWidgetDnDMouseDownHandler wrapped = new GridWidgetDnDMouseDownHandler(this.layer, this.state);
        this.handler = (GridWidgetDnDMouseDownHandler)Mockito.spy((Object)wrapped);
    }

    @Test
    public void skipNonActiveGrid() {
        Mockito.when((Object)this.state.getActiveGridWidget()).thenReturn(null);
        this.handler.onNodeMouseDown(this.event);
        ((NodeMouseDownEvent)Mockito.verify((Object)this.event, (VerificationMode)Mockito.never())).getX();
        ((NodeMouseDownEvent)Mockito.verify((Object)this.event, (VerificationMode)Mockito.never())).getY();
    }

    @Test
    public void stateColumnResizePendingMovesToColumnResize() {
        Mockito.when((Object)this.state.getActiveGridWidget()).thenReturn((Object)this.gridWidget);
        Mockito.when((Object)this.state.getOperation()).thenReturn((Object)GridWidgetDnDHandlersState.GridWidgetHandlersOperation.COLUMN_RESIZE_PENDING);
        Mockito.when((Object)this.state.getActiveGridColumns()).thenReturn((Object)new ArrayList<GridColumn<?>>(){
            {
                this.add(GridWidgetDnDMouseDownHandlerTest.this.uiColumn);
            }
        });
        this.handler.onNodeMouseDown(this.event);
        ((GridWidgetDnDHandlersState)Mockito.verify((Object)this.state, (VerificationMode)Mockito.times((int)1))).setOperation(GridWidgetDnDHandlersState.GridWidgetHandlersOperation.COLUMN_RESIZE);
    }

    @Test
    public void stateColumnMovePendingMovesToColumnMove() {
        Mockito.when((Object)this.state.getActiveGridWidget()).thenReturn((Object)this.gridWidget);
        Mockito.when((Object)this.state.getOperation()).thenReturn((Object)GridWidgetDnDHandlersState.GridWidgetHandlersOperation.COLUMN_MOVE_PENDING);
        Mockito.when((Object)this.state.getActiveGridColumns()).thenReturn((Object)new ArrayList<GridColumn<?>>(){
            {
                this.add(GridWidgetDnDMouseDownHandlerTest.this.uiColumn);
            }
        });
        this.handler.onNodeMouseDown(this.event);
        ((GridWidgetDnDMouseDownHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).showColumnHighlight((GridWidget)Mockito.eq((Object)this.gridWidget), (List)this.uiColumnsArgumentCaptor.capture());
        ((GridWidgetDnDHandlersState)Mockito.verify((Object)this.state, (VerificationMode)Mockito.times((int)1))).setOperation(GridWidgetDnDHandlersState.GridWidgetHandlersOperation.COLUMN_MOVE);
        List uiColumns = (List)this.uiColumnsArgumentCaptor.getValue();
        Assert.assertNotNull((Object)uiColumns);
        Assert.assertEquals((long)1L, (long)uiColumns.size());
        Assert.assertTrue((boolean)uiColumns.contains(this.uiColumn));
    }

    @Test
    public void stateRowMovePendingMovesToRowMove() {
        Mockito.when((Object)this.state.getActiveGridWidget()).thenReturn((Object)this.gridWidget);
        Mockito.when((Object)this.state.getOperation()).thenReturn((Object)GridWidgetDnDHandlersState.GridWidgetHandlersOperation.ROW_MOVE_PENDING);
        Mockito.when((Object)this.state.getActiveGridRows()).thenReturn((Object)new ArrayList<GridRow>(){
            {
                this.add(GridWidgetDnDMouseDownHandlerTest.this.uiRow);
            }
        });
        this.handler.onNodeMouseDown(this.event);
        ((GridWidgetDnDMouseDownHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).showRowHighlight((GridWidget)Mockito.eq((Object)this.gridWidget), (List)this.uiRowsArgumentCaptor.capture());
        ((GridWidgetDnDHandlersState)Mockito.verify((Object)this.state, (VerificationMode)Mockito.times((int)1))).setOperation(GridWidgetDnDHandlersState.GridWidgetHandlersOperation.ROW_MOVE);
        List uiRows = (List)this.uiRowsArgumentCaptor.getValue();
        Assert.assertNotNull((Object)uiRows);
        Assert.assertEquals((long)1L, (long)uiRows.size());
        Assert.assertTrue((boolean)uiRows.contains(this.uiRow));
    }

    @Test
    public void stateGridMovePendingMovesToGridMove() {
        Mockito.when((Object)this.state.getActiveGridWidget()).thenReturn((Object)this.gridWidget);
        Mockito.when((Object)this.state.getOperation()).thenReturn((Object)GridWidgetDnDHandlersState.GridWidgetHandlersOperation.GRID_MOVE_PENDING);
        this.handler.onNodeMouseDown(this.event);
        ((GridWidgetDnDHandlersState)Mockito.verify((Object)this.state, (VerificationMode)Mockito.times((int)1))).setOperation(GridWidgetDnDHandlersState.GridWidgetHandlersOperation.GRID_MOVE);
        ((GridWidget)Mockito.verify((Object)this.gridWidget, (VerificationMode)Mockito.times((int)1))).setDraggable(Mockito.eq((boolean)true));
    }
}

