/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.dnd;

import com.ait.lienzo.client.core.event.INodeXYEvent;
import com.ait.lienzo.client.core.event.NodeMouseMoveEvent;
import com.ait.lienzo.client.core.mediator.Mediators;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Style;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridColumn;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseHeaderMetaData;
import org.uberfire.ext.wires.core.grids.client.widget.dnd.GridWidgetDnDHandlersState;
import org.uberfire.ext.wires.core.grids.client.widget.dnd.GridWidgetDnDMouseMoveHandler;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.GridColumnRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;

@RunWith(value=LienzoMockitoTestRunner.class)
public class GridWidgetDnDMouseMoveHandlerTest {
    @Mock
    private GridLayer layer;
    @Mock
    private Viewport viewport;
    @Mock
    private DivElement element;
    @Mock
    private Style style;
    @Mock
    private GridWidget gridWidget;
    @Mock
    private GridRenderer renderer;
    @Mock
    private GridColumnRenderer<String> columnRenderer;
    @Mock
    private BaseGridRendererHelper helper;
    @Mock
    private NodeMouseMoveEvent event;
    @Captor
    private ArgumentCaptor<List<GridColumn<?>>> uiColumnsArgumentCaptor;
    @Captor
    private ArgumentCaptor<List<GridRow>> uiRowsArgumentCaptor;
    private BaseGridData uiModel;
    private BaseGridColumn uiColumn1;
    private BaseGridColumn<String> uiColumn2;
    private GridWidgetDnDHandlersState state;
    private Mediators mediators;
    private GridWidgetDnDMouseMoveHandler handler;

    @Before
    public void setup() {
        this.uiColumn1 = new RowNumberColumn();
        this.uiColumn2 = new BaseGridColumn((GridColumn.HeaderMetaData)new BaseHeaderMetaData("title"), this.columnRenderer, 100.0);
        this.uiModel = new BaseGridData(){
            {
                this.setHeaderRowCount(2);
            }
        };
        this.uiModel.appendColumn((GridColumn)this.uiColumn1);
        this.uiModel.appendColumn(this.uiColumn2);
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.mediators = new Mediators(this.viewport);
        Mockito.when((Object)this.renderer.getHeaderHeight()).thenReturn((Object)64.0);
        Mockito.when((Object)this.renderer.getHeaderRowHeight()).thenReturn((Object)32.0);
        Mockito.when((Object)this.layer.getViewport()).thenReturn((Object)this.viewport);
        Mockito.when((Object)this.viewport.getElement()).thenReturn((Object)this.element);
        Mockito.when((Object)this.viewport.getMediators()).thenReturn((Object)this.mediators);
        Mockito.when((Object)this.element.getStyle()).thenReturn((Object)this.style);
        Mockito.when((Object)this.gridWidget.getModel()).thenReturn((Object)this.uiModel);
        Mockito.when((Object)this.gridWidget.getViewport()).thenReturn((Object)this.viewport);
        Mockito.when((Object)this.gridWidget.getRenderer()).thenReturn((Object)this.renderer);
        Mockito.when((Object)this.gridWidget.getRendererHelper()).thenReturn((Object)this.helper);
        Mockito.when((Object)this.gridWidget.getWidth()).thenReturn((Object)150.0);
        Mockito.when((Object)this.gridWidget.getHeight()).thenReturn((Object)124.0);
        Mockito.when((Object)this.gridWidget.getLocation()).thenReturn((Object)new Point2D(100.0, 100.0));
        BaseGridRendererHelper.RenderingInformation ri = new BaseGridRendererHelper.RenderingInformation((Bounds)Mockito.mock(Bounds.class), this.uiModel.getColumns(), new BaseGridRendererHelper.RenderingBlockInformation(this.uiModel.getColumns(), 0.0, 0.0, 0.0, 100.0), new BaseGridRendererHelper.RenderingBlockInformation(Collections.emptyList(), 0.0, 0.0, 0.0, 0.0), 0, 2, (List)new ArrayList<Double>(){
            {
                this.add(20.0);
                this.add(40.0);
                this.add(60.0);
            }
        }, false, false, 0.0, 2.0, 0.0);
        Mockito.when((Object)this.helper.getRenderingInformation()).thenReturn((Object)ri);
        GridWidgetDnDHandlersState wrappedState = new GridWidgetDnDHandlersState();
        this.state = (GridWidgetDnDHandlersState)Mockito.spy((Object)wrappedState);
        GridWidgetDnDMouseMoveHandler wrapped = new GridWidgetDnDMouseMoveHandler(this.layer, this.state);
        this.handler = (GridWidgetDnDMouseMoveHandler)Mockito.spy((Object)wrapped);
    }

    @Test
    public void findGridColumnWithEmptyLayer() {
        Mockito.when((Object)this.state.getOperation()).thenReturn((Object)GridWidgetDnDHandlersState.GridWidgetHandlersOperation.NONE);
        this.handler.onNodeMouseMove(this.event);
        ((GridWidgetDnDMouseMoveHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).findGridColumn((NodeMouseMoveEvent)Mockito.eq((Object)this.event));
        ((GridWidgetDnDMouseMoveHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).findMovableColumns((GridWidget)Mockito.any(GridWidget.class), ((Double)Mockito.any(Double.class)).doubleValue(), ((Double)Mockito.any(Double.class)).doubleValue(), ((Double)Mockito.any(Double.class)).doubleValue(), ((Double)Mockito.any(Double.class)).doubleValue());
        ((GridWidgetDnDMouseMoveHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).findMovableRows((GridWidget)Mockito.any(GridWidget.class), ((Double)Mockito.any(Double.class)).doubleValue(), ((Double)Mockito.any(Double.class)).doubleValue());
        ((GridWidgetDnDMouseMoveHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).findResizableColumn((GridWidget)Mockito.any(GridWidget.class), ((Double)Mockito.any(Double.class)).doubleValue());
    }

    @Test
    public void findGridColumnWithInvisibleGridWidgets() {
        Mockito.when((Object)this.state.getOperation()).thenReturn((Object)GridWidgetDnDHandlersState.GridWidgetHandlersOperation.NONE);
        Mockito.when((Object)this.gridWidget.isVisible()).thenReturn((Object)false);
        Mockito.when((Object)this.layer.getGridWidgets()).thenReturn((Object)new HashSet<GridWidget>(){
            {
                this.add(GridWidgetDnDMouseMoveHandlerTest.this.gridWidget);
            }
        });
        this.handler.onNodeMouseMove(this.event);
        ((GridWidgetDnDMouseMoveHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).findGridColumn((NodeMouseMoveEvent)Mockito.eq((Object)this.event));
        ((GridWidgetDnDMouseMoveHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).findMovableColumns((GridWidget)Mockito.any(GridWidget.class), ((Double)Mockito.any(Double.class)).doubleValue(), ((Double)Mockito.any(Double.class)).doubleValue(), ((Double)Mockito.any(Double.class)).doubleValue(), ((Double)Mockito.any(Double.class)).doubleValue());
        ((GridWidgetDnDMouseMoveHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).findMovableRows((GridWidget)Mockito.any(GridWidget.class), ((Double)Mockito.any(Double.class)).doubleValue(), ((Double)Mockito.any(Double.class)).doubleValue());
        ((GridWidgetDnDMouseMoveHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).findResizableColumn((GridWidget)Mockito.any(GridWidget.class), ((Double)Mockito.any(Double.class)).doubleValue());
    }

    @Test
    public void findMovableGridWhenNoColumnOrRowOperationIsDetected() {
        Mockito.when((Object)this.state.getOperation()).thenReturn((Object)GridWidgetDnDHandlersState.GridWidgetHandlersOperation.NONE);
        Mockito.when((Object)this.gridWidget.isVisible()).thenReturn((Object)true);
        Mockito.when((Object)this.layer.getGridWidgets()).thenReturn((Object)new HashSet<GridWidget>(){
            {
                this.add(GridWidgetDnDMouseMoveHandlerTest.this.gridWidget);
            }
        });
        Mockito.when((Object)this.event.getX()).thenReturn((Object)100);
        Mockito.when((Object)this.event.getY()).thenReturn((Object)100);
        this.handler.onNodeMouseMove(this.event);
        ((GridWidgetDnDMouseMoveHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).findGridColumn((NodeMouseMoveEvent)Mockito.eq((Object)this.event));
        ((GridWidgetDnDMouseMoveHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).findMovableColumns((GridWidget)Mockito.any(GridWidget.class), ((Double)Mockito.any(Double.class)).doubleValue(), ((Double)Mockito.any(Double.class)).doubleValue(), ((Double)Mockito.any(Double.class)).doubleValue(), ((Double)Mockito.any(Double.class)).doubleValue());
        ((GridWidgetDnDMouseMoveHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).findMovableRows((GridWidget)Mockito.any(GridWidget.class), ((Double)Mockito.any(Double.class)).doubleValue(), ((Double)Mockito.any(Double.class)).doubleValue());
        ((GridWidgetDnDMouseMoveHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).findResizableColumn((GridWidget)Mockito.any(GridWidget.class), ((Double)Mockito.any(Double.class)).doubleValue());
        ((GridWidgetDnDHandlersState)Mockito.verify((Object)this.state, (VerificationMode)Mockito.times((int)1))).setActiveGridWidget((GridWidget)Mockito.eq((Object)this.gridWidget));
        ((GridWidgetDnDHandlersState)Mockito.verify((Object)this.state, (VerificationMode)Mockito.times((int)1))).setOperation((GridWidgetDnDHandlersState.GridWidgetHandlersOperation)Mockito.eq((Object)GridWidgetDnDHandlersState.GridWidgetHandlersOperation.GRID_MOVE_PENDING));
    }

    @Test
    public void findMovableGridWhenOverDragHandle() {
        Mockito.when((Object)this.state.getOperation()).thenReturn((Object)GridWidgetDnDHandlersState.GridWidgetHandlersOperation.NONE);
        Mockito.when((Object)this.gridWidget.isVisible()).thenReturn((Object)true);
        Mockito.when((Object)this.gridWidget.onDragHandle((INodeXYEvent)Mockito.any(INodeXYEvent.class))).thenReturn((Object)true);
        Mockito.when((Object)this.layer.getGridWidgets()).thenReturn((Object)new HashSet<GridWidget>(){
            {
                this.add(GridWidgetDnDMouseMoveHandlerTest.this.gridWidget);
            }
        });
        Mockito.when((Object)this.event.getX()).thenReturn((Object)100);
        Mockito.when((Object)this.event.getY()).thenReturn((Object)100);
        this.handler.onNodeMouseMove(this.event);
        ((GridWidgetDnDMouseMoveHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).findGridColumn((NodeMouseMoveEvent)Mockito.eq((Object)this.event));
        ((GridWidgetDnDMouseMoveHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).findMovableColumns((GridWidget)Mockito.any(GridWidget.class), ((Double)Mockito.any(Double.class)).doubleValue(), ((Double)Mockito.any(Double.class)).doubleValue(), ((Double)Mockito.any(Double.class)).doubleValue(), ((Double)Mockito.any(Double.class)).doubleValue());
        ((GridWidgetDnDMouseMoveHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).findMovableRows((GridWidget)Mockito.any(GridWidget.class), ((Double)Mockito.any(Double.class)).doubleValue(), ((Double)Mockito.any(Double.class)).doubleValue());
        ((GridWidgetDnDMouseMoveHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).findResizableColumn((GridWidget)Mockito.any(GridWidget.class), ((Double)Mockito.any(Double.class)).doubleValue());
        ((GridWidgetDnDHandlersState)Mockito.verify((Object)this.state, (VerificationMode)Mockito.times((int)1))).setActiveGridWidget((GridWidget)Mockito.eq((Object)this.gridWidget));
        ((GridWidgetDnDHandlersState)Mockito.verify((Object)this.state, (VerificationMode)Mockito.times((int)1))).setOperation((GridWidgetDnDHandlersState.GridWidgetHandlersOperation)Mockito.eq((Object)GridWidgetDnDHandlersState.GridWidgetHandlersOperation.GRID_MOVE_PENDING));
    }

    @Test
    public void findMovableColumns() {
        Mockito.when((Object)this.state.getOperation()).thenReturn((Object)GridWidgetDnDHandlersState.GridWidgetHandlersOperation.NONE);
        Mockito.when((Object)this.gridWidget.isVisible()).thenReturn((Object)true);
        Mockito.when((Object)this.layer.getGridWidgets()).thenReturn((Object)new HashSet<GridWidget>(){
            {
                this.add(GridWidgetDnDMouseMoveHandlerTest.this.gridWidget);
            }
        });
        Mockito.when((Object)this.event.getX()).thenReturn((Object)160);
        Mockito.when((Object)this.event.getY()).thenReturn((Object)100);
        this.handler.onNodeMouseMove(this.event);
        ((GridWidgetDnDMouseMoveHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).findGridColumn((NodeMouseMoveEvent)Mockito.eq((Object)this.event));
        ((GridWidgetDnDMouseMoveHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).findMovableColumns((GridWidget)Mockito.any(GridWidget.class), ((Double)Mockito.any(Double.class)).doubleValue(), ((Double)Mockito.any(Double.class)).doubleValue(), ((Double)Mockito.any(Double.class)).doubleValue(), ((Double)Mockito.any(Double.class)).doubleValue());
        ((GridWidgetDnDMouseMoveHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).findMovableRows((GridWidget)Mockito.any(GridWidget.class), ((Double)Mockito.any(Double.class)).doubleValue(), ((Double)Mockito.any(Double.class)).doubleValue());
        ((GridWidgetDnDMouseMoveHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).findResizableColumn((GridWidget)Mockito.any(GridWidget.class), ((Double)Mockito.any(Double.class)).doubleValue());
        ((GridWidgetDnDHandlersState)Mockito.verify((Object)this.state, (VerificationMode)Mockito.times((int)1))).setActiveGridWidget((GridWidget)Mockito.eq((Object)this.gridWidget));
        ((GridWidgetDnDHandlersState)Mockito.verify((Object)this.state, (VerificationMode)Mockito.times((int)1))).setOperation((GridWidgetDnDHandlersState.GridWidgetHandlersOperation)Mockito.eq((Object)GridWidgetDnDHandlersState.GridWidgetHandlersOperation.COLUMN_MOVE_PENDING));
        ((GridWidgetDnDHandlersState)Mockito.verify((Object)this.state, (VerificationMode)Mockito.times((int)1))).setActiveGridColumns((List)this.uiColumnsArgumentCaptor.capture());
        List uiColumns = (List)this.uiColumnsArgumentCaptor.getValue();
        Assert.assertNotNull((Object)uiColumns);
        Assert.assertEquals((long)1L, (long)uiColumns.size());
        Assert.assertTrue((boolean)uiColumns.contains(this.uiColumn2));
    }

    @Test
    public void findResizableColumns() {
        Mockito.when((Object)this.state.getOperation()).thenReturn((Object)GridWidgetDnDHandlersState.GridWidgetHandlersOperation.NONE);
        Mockito.when((Object)this.gridWidget.isVisible()).thenReturn((Object)true);
        Mockito.when((Object)this.layer.getGridWidgets()).thenReturn((Object)new HashSet<GridWidget>(){
            {
                this.add(GridWidgetDnDMouseMoveHandlerTest.this.gridWidget);
            }
        });
        Mockito.when((Object)this.event.getX()).thenReturn((Object)246);
        Mockito.when((Object)this.event.getY()).thenReturn((Object)180);
        this.handler.onNodeMouseMove(this.event);
        ((GridWidgetDnDMouseMoveHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).findGridColumn((NodeMouseMoveEvent)Mockito.eq((Object)this.event));
        ((GridWidgetDnDMouseMoveHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).findMovableColumns((GridWidget)Mockito.any(GridWidget.class), ((Double)Mockito.any(Double.class)).doubleValue(), ((Double)Mockito.any(Double.class)).doubleValue(), ((Double)Mockito.any(Double.class)).doubleValue(), ((Double)Mockito.any(Double.class)).doubleValue());
        ((GridWidgetDnDMouseMoveHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).findMovableRows((GridWidget)Mockito.any(GridWidget.class), ((Double)Mockito.any(Double.class)).doubleValue(), ((Double)Mockito.any(Double.class)).doubleValue());
        ((GridWidgetDnDMouseMoveHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).findResizableColumn((GridWidget)Mockito.any(GridWidget.class), ((Double)Mockito.any(Double.class)).doubleValue());
        ((GridWidgetDnDHandlersState)Mockito.verify((Object)this.state, (VerificationMode)Mockito.times((int)1))).setActiveGridWidget((GridWidget)Mockito.eq((Object)this.gridWidget));
        ((GridWidgetDnDHandlersState)Mockito.verify((Object)this.state, (VerificationMode)Mockito.times((int)1))).setOperation((GridWidgetDnDHandlersState.GridWidgetHandlersOperation)Mockito.eq((Object)GridWidgetDnDHandlersState.GridWidgetHandlersOperation.COLUMN_RESIZE_PENDING));
        ((GridWidgetDnDHandlersState)Mockito.verify((Object)this.state, (VerificationMode)Mockito.times((int)1))).setActiveGridColumns((List)this.uiColumnsArgumentCaptor.capture());
        List uiColumns = (List)this.uiColumnsArgumentCaptor.getValue();
        Assert.assertNotNull((Object)uiColumns);
        Assert.assertEquals((long)1L, (long)uiColumns.size());
        Assert.assertTrue((boolean)uiColumns.contains(this.uiColumn2));
    }

    @Test
    public void findMovableRows() {
        Mockito.when((Object)this.state.getOperation()).thenReturn((Object)GridWidgetDnDHandlersState.GridWidgetHandlersOperation.NONE);
        Mockito.when((Object)this.gridWidget.isVisible()).thenReturn((Object)true);
        Mockito.when((Object)this.layer.getGridWidgets()).thenReturn((Object)new HashSet<GridWidget>(){
            {
                this.add(GridWidgetDnDMouseMoveHandlerTest.this.gridWidget);
            }
        });
        Mockito.when((Object)this.event.getX()).thenReturn((Object)125);
        Mockito.when((Object)this.event.getY()).thenReturn((Object)180);
        this.handler.onNodeMouseMove(this.event);
        ((GridWidgetDnDMouseMoveHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).findGridColumn((NodeMouseMoveEvent)Mockito.eq((Object)this.event));
        ((GridWidgetDnDMouseMoveHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).findMovableColumns((GridWidget)Mockito.any(GridWidget.class), ((Double)Mockito.any(Double.class)).doubleValue(), ((Double)Mockito.any(Double.class)).doubleValue(), ((Double)Mockito.any(Double.class)).doubleValue(), ((Double)Mockito.any(Double.class)).doubleValue());
        ((GridWidgetDnDMouseMoveHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).findMovableRows((GridWidget)Mockito.any(GridWidget.class), ((Double)Mockito.any(Double.class)).doubleValue(), ((Double)Mockito.any(Double.class)).doubleValue());
        ((GridWidgetDnDMouseMoveHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).findResizableColumn((GridWidget)Mockito.any(GridWidget.class), ((Double)Mockito.any(Double.class)).doubleValue());
        ((GridWidgetDnDHandlersState)Mockito.verify((Object)this.state, (VerificationMode)Mockito.times((int)1))).setActiveGridWidget((GridWidget)Mockito.eq((Object)this.gridWidget));
        ((GridWidgetDnDHandlersState)Mockito.verify((Object)this.state, (VerificationMode)Mockito.times((int)1))).setOperation((GridWidgetDnDHandlersState.GridWidgetHandlersOperation)Mockito.eq((Object)GridWidgetDnDHandlersState.GridWidgetHandlersOperation.ROW_MOVE_PENDING));
        ((GridWidgetDnDHandlersState)Mockito.verify((Object)this.state, (VerificationMode)Mockito.times((int)1))).setActiveGridRows((List)this.uiRowsArgumentCaptor.capture());
        List uiRows = (List)this.uiRowsArgumentCaptor.getValue();
        Assert.assertNotNull((Object)uiRows);
        Assert.assertEquals((long)1L, (long)uiRows.size());
        Assert.assertTrue((boolean)uiRows.contains(this.uiModel.getRow(0)));
    }
}

