/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.impl;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.event.dom.client.KeyDownEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseBounds;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridTest;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.BaseGridWidgetKeyboardHandler;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperation;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationClearCell;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationEditCell;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationMoveDown;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationMoveLeft;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationMoveRight;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationMoveUp;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationSelectBottomRightCell;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationSelectTopLeftCell;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.SelectionExtension;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.impl.BaseCellSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.DefaultGridLayer;

@RunWith(value=LienzoMockitoTestRunner.class)
public class BaseGridWidgetKeyboardHandlerTest {
    @Mock
    private DefaultGridLayer layer;
    @Mock
    private KeyDownEvent event;
    @Mock
    private GridWidget gridWidget1;
    @Mock
    private GridWidget gridWidget2;
    @Mock
    private GridRenderer gridWidget1Renderer;
    @Mock
    private BaseGridRendererHelper gridWidget1RendererHelper;
    private GridData gridWidget1Data;
    private Bounds visibleBounds = new BaseBounds(-1000.0, -1000.0, 2000.0, 2000.0);
    private Set<GridWidget> gridWidgets = new HashSet<GridWidget>();
    private BaseCellSelectionManager cellSelectionManager;
    private KeyboardOperation keyboardOperationClearCell;
    private KeyboardOperation keyboardOperationEditCell;
    private KeyboardOperation keyboardOperationMoveLeft;
    private KeyboardOperation keyboardOperationMoveRight;
    private KeyboardOperation keyboardOperationMoveUp;
    private KeyboardOperation keyboardOperationMoveDown;
    private KeyboardOperation keyboardOperationSelectTopLeftCell;
    private KeyboardOperation keyboardOperationSelectBottomRightCell;
    private BaseGridWidgetKeyboardHandler handler;

    @Before
    public void setup() {
        this.gridWidgets.add(this.gridWidget1);
        this.gridWidgets.add(this.gridWidget2);
        this.gridWidget1Data = new BaseGridData();
        this.gridWidget1Data.appendRow((GridRow)new BaseGridRow());
        this.gridWidget1Data.appendRow((GridRow)new BaseGridRow());
        this.gridWidget1Data.appendColumn(new BaseGridTest.MockMergableGridColumn("col1", 100.0));
        this.gridWidget1Data.appendColumn(new BaseGridTest.MockMergableGridColumn("col2", 100.0));
        Mockito.when((Object)this.gridWidget1.getModel()).thenReturn((Object)this.gridWidget1Data);
        Mockito.when((Object)this.gridWidget1.getRenderer()).thenReturn((Object)this.gridWidget1Renderer);
        Mockito.when((Object)this.gridWidget1.getRendererHelper()).thenReturn((Object)this.gridWidget1RendererHelper);
        Mockito.when((Object)this.gridWidget1.adjustSelection((SelectionExtension)Mockito.any(SelectionExtension.class), ((Boolean)Mockito.any(Boolean.class)).booleanValue())).thenAnswer(invocation -> {
            SelectionExtension direction = (SelectionExtension)invocation.getArguments()[0];
            boolean isShiftKeyDown = (Boolean)invocation.getArguments()[1];
            return this.cellSelectionManager.adjustSelection(direction, isShiftKeyDown);
        });
        Mockito.when((Object)this.gridWidget1Renderer.getHeaderHeight()).thenReturn((Object)32.0);
        Mockito.when((Object)this.layer.getVisibleBounds()).thenReturn((Object)this.visibleBounds);
        Mockito.when((Object)this.event.isLeftArrow()).thenCallRealMethod();
        Mockito.when((Object)this.event.isRightArrow()).thenCallRealMethod();
        Mockito.when((Object)this.event.isUpArrow()).thenCallRealMethod();
        Mockito.when((Object)this.event.isDownArrow()).thenCallRealMethod();
        this.cellSelectionManager = new BaseCellSelectionManager(this.gridWidget1);
        BaseGridWidgetKeyboardHandler wrapped = new BaseGridWidgetKeyboardHandler((GridLayer)this.layer);
        this.handler = (BaseGridWidgetKeyboardHandler)Mockito.spy((Object)wrapped);
        this.setupKeyboardOperations();
    }

    @Test
    public void noSelectedDecisionTable() {
        this.handler.onKeyDown(this.event);
        this.verifyNoOperationsInvoked();
    }

    @Test
    public void unhandledKeysInvokeNoAction() {
        Mockito.when((Object)this.layer.getGridWidgets()).thenReturn(this.gridWidgets);
        Mockito.when((Object)this.gridWidget1.isSelected()).thenReturn((Object)true);
        Mockito.when((Object)this.event.getNativeKeyCode()).thenReturn((Object)65);
        this.handler.onKeyDown(this.event);
        this.verifyNoOperationsInvoked();
    }

    private void verifyNoOperationsInvoked() {
        ((KeyboardOperation)Mockito.verify((Object)this.keyboardOperationClearCell, (VerificationMode)Mockito.never())).perform((GridWidget)Mockito.any(GridWidget.class), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), ((Boolean)Mockito.any(Boolean.class)).booleanValue());
        ((KeyboardOperation)Mockito.verify((Object)this.keyboardOperationEditCell, (VerificationMode)Mockito.never())).perform((GridWidget)Mockito.any(GridWidget.class), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), ((Boolean)Mockito.any(Boolean.class)).booleanValue());
        ((KeyboardOperation)Mockito.verify((Object)this.keyboardOperationMoveLeft, (VerificationMode)Mockito.never())).perform((GridWidget)Mockito.any(GridWidget.class), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), ((Boolean)Mockito.any(Boolean.class)).booleanValue());
        ((KeyboardOperation)Mockito.verify((Object)this.keyboardOperationMoveRight, (VerificationMode)Mockito.never())).perform((GridWidget)Mockito.any(GridWidget.class), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), ((Boolean)Mockito.any(Boolean.class)).booleanValue());
        ((KeyboardOperation)Mockito.verify((Object)this.keyboardOperationMoveUp, (VerificationMode)Mockito.never())).perform((GridWidget)Mockito.any(GridWidget.class), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), ((Boolean)Mockito.any(Boolean.class)).booleanValue());
        ((KeyboardOperation)Mockito.verify((Object)this.keyboardOperationMoveDown, (VerificationMode)Mockito.never())).perform((GridWidget)Mockito.any(GridWidget.class), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), ((Boolean)Mockito.any(Boolean.class)).booleanValue());
        ((KeyboardOperation)Mockito.verify((Object)this.keyboardOperationSelectTopLeftCell, (VerificationMode)Mockito.never())).perform((GridWidget)Mockito.any(GridWidget.class), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), ((Boolean)Mockito.any(Boolean.class)).booleanValue());
        ((KeyboardOperation)Mockito.verify((Object)this.keyboardOperationSelectBottomRightCell, (VerificationMode)Mockito.never())).perform((GridWidget)Mockito.any(GridWidget.class), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), ((Boolean)Mockito.any(Boolean.class)).booleanValue());
    }

    @Test
    public void deleteKeyClearsCells() {
        Mockito.when((Object)this.layer.getGridWidgets()).thenReturn(this.gridWidgets);
        Mockito.when((Object)this.gridWidget1.isSelected()).thenReturn((Object)true);
        Mockito.when((Object)this.event.getNativeKeyCode()).thenReturn((Object)46);
        this.gridWidget1Data.setCell(0, 0, (GridCellValue)new BaseGridCellValue((Object)"hello"));
        Assert.assertEquals((Object)"hello", (Object)this.gridWidget1Data.getCell(0, 0).getValue().getValue());
        this.gridWidget1Data.selectCell(0, 0);
        this.handler.onKeyDown(this.event);
        ((KeyboardOperation)Mockito.verify((Object)this.keyboardOperationClearCell, (VerificationMode)Mockito.times((int)1))).perform((GridWidget)Mockito.eq((Object)this.gridWidget1), Mockito.eq((boolean)false), Mockito.eq((boolean)false));
        Assert.assertNull((Object)this.gridWidget1Data.getCell(0, 0));
        ((DefaultGridLayer)Mockito.verify((Object)this.layer, (VerificationMode)Mockito.times((int)1))).draw();
    }

    @Test
    public void enterKeyEditsCells() {
        Mockito.when((Object)this.layer.getGridWidgets()).thenReturn(this.gridWidgets);
        Mockito.when((Object)this.gridWidget1.isSelected()).thenReturn((Object)true);
        Mockito.when((Object)this.event.getNativeKeyCode()).thenReturn((Object)13);
        this.gridWidget1Data.selectCell(0, 0);
        this.handler.onKeyDown(this.event);
        ((GridWidget)Mockito.verify((Object)this.gridWidget1, (VerificationMode)Mockito.times((int)1))).startEditingCell(Mockito.eq((int)0), Mockito.eq((int)0));
        ((DefaultGridLayer)Mockito.verify((Object)this.layer, (VerificationMode)Mockito.never())).draw();
        ((KeyboardOperation)Mockito.verify((Object)this.keyboardOperationEditCell, (VerificationMode)Mockito.times((int)1))).perform((GridWidget)Mockito.eq((Object)this.gridWidget1), Mockito.eq((boolean)false), Mockito.eq((boolean)false));
    }

    @Test
    public void homeKeyMovesToTopLeft() {
        Mockito.when((Object)this.layer.getGridWidgets()).thenReturn(this.gridWidgets);
        Mockito.when((Object)this.gridWidget1.isSelected()).thenReturn((Object)true);
        Mockito.when((Object)this.gridWidget1.selectCell(Mockito.eq((int)0), Mockito.eq((int)0), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), ((Boolean)Mockito.any(Boolean.class)).booleanValue())).thenReturn((Object)true);
        Mockito.when((Object)this.event.getNativeKeyCode()).thenReturn((Object)36);
        this.handler.onKeyDown(this.event);
        ((GridWidget)Mockito.verify((Object)this.gridWidget1, (VerificationMode)Mockito.times((int)1))).selectCell(Mockito.eq((int)0), Mockito.eq((int)0), Mockito.eq((boolean)false), Mockito.eq((boolean)false));
        ((DefaultGridLayer)Mockito.verify((Object)this.layer, (VerificationMode)Mockito.times((int)1))).draw();
        ((KeyboardOperation)Mockito.verify((Object)this.keyboardOperationSelectTopLeftCell, (VerificationMode)Mockito.times((int)1))).perform((GridWidget)Mockito.eq((Object)this.gridWidget1), Mockito.eq((boolean)false), Mockito.eq((boolean)false));
    }

    @Test
    public void endKeyMovesToBottomRight() {
        Mockito.when((Object)this.layer.getGridWidgets()).thenReturn(this.gridWidgets);
        Mockito.when((Object)this.gridWidget1.isSelected()).thenReturn((Object)true);
        Mockito.when((Object)this.gridWidget1.selectCell(Mockito.eq((int)1), Mockito.eq((int)1), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), ((Boolean)Mockito.any(Boolean.class)).booleanValue())).thenReturn((Object)true);
        Mockito.when((Object)this.event.getNativeKeyCode()).thenReturn((Object)35);
        this.handler.onKeyDown(this.event);
        ((GridWidget)Mockito.verify((Object)this.gridWidget1, (VerificationMode)Mockito.times((int)1))).selectCell(Mockito.eq((int)1), Mockito.eq((int)1), Mockito.eq((boolean)false), Mockito.eq((boolean)false));
        ((DefaultGridLayer)Mockito.verify((Object)this.layer, (VerificationMode)Mockito.times((int)1))).draw();
        ((KeyboardOperation)Mockito.verify((Object)this.keyboardOperationSelectBottomRightCell, (VerificationMode)Mockito.times((int)1))).perform((GridWidget)Mockito.eq((Object)this.gridWidget1), Mockito.eq((boolean)false), Mockito.eq((boolean)false));
    }

    @Test
    public void leftCursorWithoutShiftKeyMovesLeftOneCell() {
        Mockito.when((Object)this.layer.getGridWidgets()).thenReturn(this.gridWidgets);
        Mockito.when((Object)this.gridWidget1.isSelected()).thenReturn((Object)true);
        Mockito.when((Object)this.gridWidget1.selectCell(Mockito.eq((int)0), Mockito.eq((int)0), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), ((Boolean)Mockito.any(Boolean.class)).booleanValue())).thenReturn((Object)true);
        Mockito.when((Object)this.event.getNativeKeyCode()).thenReturn((Object)37);
        this.gridWidget1.getModel().selectCell(0, 1);
        this.handler.onKeyDown(this.event);
        ((DefaultGridLayer)Mockito.verify((Object)this.layer, (VerificationMode)Mockito.times((int)1))).draw();
        ((KeyboardOperation)Mockito.verify((Object)this.keyboardOperationMoveLeft, (VerificationMode)Mockito.times((int)1))).perform((GridWidget)Mockito.eq((Object)this.gridWidget1), Mockito.eq((boolean)false), Mockito.eq((boolean)false));
        List selectedCells = this.gridWidget1Data.getSelectedCells();
        Assert.assertEquals((long)1L, (long)selectedCells.size());
        Assert.assertEquals((long)0L, (long)((GridData.SelectedCell)selectedCells.get(0)).getRowIndex());
        Assert.assertEquals((long)0L, (long)((GridData.SelectedCell)selectedCells.get(0)).getColumnIndex());
    }

    @Test
    public void leftCursorWithShiftKeyExtendsRangeLeftOneCell() {
        Mockito.when((Object)this.layer.getGridWidgets()).thenReturn(this.gridWidgets);
        Mockito.when((Object)this.gridWidget1.isSelected()).thenReturn((Object)true);
        Mockito.when((Object)this.gridWidget1.selectCell(Mockito.eq((int)0), Mockito.eq((int)0), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), ((Boolean)Mockito.any(Boolean.class)).booleanValue())).thenReturn((Object)true);
        Mockito.when((Object)this.event.getNativeKeyCode()).thenReturn((Object)37);
        Mockito.when((Object)this.event.isShiftKeyDown()).thenReturn((Object)true);
        this.gridWidget1.getModel().selectCell(0, 1);
        this.handler.onKeyDown(this.event);
        ((DefaultGridLayer)Mockito.verify((Object)this.layer, (VerificationMode)Mockito.times((int)1))).draw();
        ((KeyboardOperation)Mockito.verify((Object)this.keyboardOperationMoveLeft, (VerificationMode)Mockito.times((int)1))).perform((GridWidget)Mockito.eq((Object)this.gridWidget1), Mockito.eq((boolean)true), Mockito.eq((boolean)false));
        List selectedCells = this.gridWidget1Data.getSelectedCells();
        Assert.assertEquals((long)2L, (long)selectedCells.size());
        Assert.assertEquals((long)0L, (long)((GridData.SelectedCell)selectedCells.get(0)).getRowIndex());
        Assert.assertEquals((long)1L, (long)((GridData.SelectedCell)selectedCells.get(0)).getColumnIndex());
        Assert.assertEquals((long)0L, (long)((GridData.SelectedCell)selectedCells.get(1)).getRowIndex());
        Assert.assertEquals((long)0L, (long)((GridData.SelectedCell)selectedCells.get(1)).getColumnIndex());
    }

    @Test
    public void rightCursorWithoutShiftKeyMovesRightOneCell() {
        Mockito.when((Object)this.layer.getGridWidgets()).thenReturn(this.gridWidgets);
        Mockito.when((Object)this.gridWidget1.isSelected()).thenReturn((Object)true);
        Mockito.when((Object)this.gridWidget1.selectCell(Mockito.eq((int)0), Mockito.eq((int)1), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), ((Boolean)Mockito.any(Boolean.class)).booleanValue())).thenReturn((Object)true);
        Mockito.when((Object)this.event.getNativeKeyCode()).thenReturn((Object)39);
        this.gridWidget1.getModel().selectCell(0, 0);
        this.handler.onKeyDown(this.event);
        ((DefaultGridLayer)Mockito.verify((Object)this.layer, (VerificationMode)Mockito.times((int)1))).draw();
        ((KeyboardOperation)Mockito.verify((Object)this.keyboardOperationMoveRight, (VerificationMode)Mockito.times((int)1))).perform((GridWidget)Mockito.eq((Object)this.gridWidget1), Mockito.eq((boolean)false), Mockito.eq((boolean)false));
        List selectedCells = this.gridWidget1Data.getSelectedCells();
        Assert.assertEquals((long)1L, (long)selectedCells.size());
        Assert.assertEquals((long)0L, (long)((GridData.SelectedCell)selectedCells.get(0)).getRowIndex());
        Assert.assertEquals((long)1L, (long)((GridData.SelectedCell)selectedCells.get(0)).getColumnIndex());
    }

    @Test
    public void rightCursorWithShiftKeyExtendsRangeRightOneCell() {
        Mockito.when((Object)this.layer.getGridWidgets()).thenReturn(this.gridWidgets);
        Mockito.when((Object)this.gridWidget1.isSelected()).thenReturn((Object)true);
        Mockito.when((Object)this.gridWidget1.selectCell(Mockito.eq((int)0), Mockito.eq((int)1), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), ((Boolean)Mockito.any(Boolean.class)).booleanValue())).thenReturn((Object)true);
        Mockito.when((Object)this.event.getNativeKeyCode()).thenReturn((Object)39);
        Mockito.when((Object)this.event.isShiftKeyDown()).thenReturn((Object)true);
        this.gridWidget1.getModel().selectCell(0, 0);
        this.handler.onKeyDown(this.event);
        ((DefaultGridLayer)Mockito.verify((Object)this.layer, (VerificationMode)Mockito.times((int)1))).draw();
        ((KeyboardOperation)Mockito.verify((Object)this.keyboardOperationMoveRight, (VerificationMode)Mockito.times((int)1))).perform((GridWidget)Mockito.eq((Object)this.gridWidget1), Mockito.eq((boolean)true), Mockito.eq((boolean)false));
        List selectedCells = this.gridWidget1Data.getSelectedCells();
        Assert.assertEquals((long)2L, (long)selectedCells.size());
        Assert.assertEquals((long)0L, (long)((GridData.SelectedCell)selectedCells.get(0)).getRowIndex());
        Assert.assertEquals((long)0L, (long)((GridData.SelectedCell)selectedCells.get(0)).getColumnIndex());
        Assert.assertEquals((long)0L, (long)((GridData.SelectedCell)selectedCells.get(1)).getRowIndex());
        Assert.assertEquals((long)1L, (long)((GridData.SelectedCell)selectedCells.get(1)).getColumnIndex());
    }

    @Test
    public void upCursorWithoutShiftKeyMovesUpOneCell() {
        Mockito.when((Object)this.layer.getGridWidgets()).thenReturn(this.gridWidgets);
        Mockito.when((Object)this.gridWidget1.isSelected()).thenReturn((Object)true);
        Mockito.when((Object)this.gridWidget1.selectCell(Mockito.eq((int)0), Mockito.eq((int)0), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), ((Boolean)Mockito.any(Boolean.class)).booleanValue())).thenReturn((Object)true);
        Mockito.when((Object)this.event.getNativeKeyCode()).thenReturn((Object)38);
        this.gridWidget1.getModel().selectCell(1, 0);
        this.handler.onKeyDown(this.event);
        ((DefaultGridLayer)Mockito.verify((Object)this.layer, (VerificationMode)Mockito.times((int)1))).draw();
        ((KeyboardOperation)Mockito.verify((Object)this.keyboardOperationMoveUp, (VerificationMode)Mockito.times((int)1))).perform((GridWidget)Mockito.eq((Object)this.gridWidget1), Mockito.eq((boolean)false), Mockito.eq((boolean)false));
        List selectedCells = this.gridWidget1Data.getSelectedCells();
        Assert.assertEquals((long)1L, (long)selectedCells.size());
        Assert.assertEquals((long)0L, (long)((GridData.SelectedCell)selectedCells.get(0)).getRowIndex());
        Assert.assertEquals((long)0L, (long)((GridData.SelectedCell)selectedCells.get(0)).getColumnIndex());
    }

    @Test
    public void upCursorWithShiftKeyExtendsRangeUpOneCell() {
        Mockito.when((Object)this.layer.getGridWidgets()).thenReturn(this.gridWidgets);
        Mockito.when((Object)this.gridWidget1.isSelected()).thenReturn((Object)true);
        Mockito.when((Object)this.gridWidget1.selectCell(Mockito.eq((int)0), Mockito.eq((int)0), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), ((Boolean)Mockito.any(Boolean.class)).booleanValue())).thenReturn((Object)true);
        Mockito.when((Object)this.event.getNativeKeyCode()).thenReturn((Object)38);
        Mockito.when((Object)this.event.isShiftKeyDown()).thenReturn((Object)true);
        this.gridWidget1.getModel().selectCell(1, 0);
        this.handler.onKeyDown(this.event);
        ((DefaultGridLayer)Mockito.verify((Object)this.layer, (VerificationMode)Mockito.times((int)1))).draw();
        ((KeyboardOperation)Mockito.verify((Object)this.keyboardOperationMoveUp, (VerificationMode)Mockito.times((int)1))).perform((GridWidget)Mockito.eq((Object)this.gridWidget1), Mockito.eq((boolean)true), Mockito.eq((boolean)false));
        List selectedCells = this.gridWidget1Data.getSelectedCells();
        Assert.assertEquals((long)2L, (long)selectedCells.size());
        Assert.assertEquals((long)1L, (long)((GridData.SelectedCell)selectedCells.get(0)).getRowIndex());
        Assert.assertEquals((long)0L, (long)((GridData.SelectedCell)selectedCells.get(0)).getColumnIndex());
        Assert.assertEquals((long)0L, (long)((GridData.SelectedCell)selectedCells.get(1)).getRowIndex());
        Assert.assertEquals((long)0L, (long)((GridData.SelectedCell)selectedCells.get(1)).getColumnIndex());
    }

    @Test
    public void downCursorWithoutShiftKeyMovesDownOneCell() {
        Mockito.when((Object)this.layer.getGridWidgets()).thenReturn(this.gridWidgets);
        Mockito.when((Object)this.gridWidget1.isSelected()).thenReturn((Object)true);
        Mockito.when((Object)this.gridWidget1.selectCell(Mockito.eq((int)1), Mockito.eq((int)0), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), ((Boolean)Mockito.any(Boolean.class)).booleanValue())).thenReturn((Object)true);
        Mockito.when((Object)this.event.getNativeKeyCode()).thenReturn((Object)40);
        this.gridWidget1.getModel().selectCell(0, 0);
        this.handler.onKeyDown(this.event);
        ((DefaultGridLayer)Mockito.verify((Object)this.layer, (VerificationMode)Mockito.times((int)1))).draw();
        ((KeyboardOperation)Mockito.verify((Object)this.keyboardOperationMoveDown, (VerificationMode)Mockito.times((int)1))).perform((GridWidget)Mockito.eq((Object)this.gridWidget1), Mockito.eq((boolean)false), Mockito.eq((boolean)false));
        List selectedCells = this.gridWidget1Data.getSelectedCells();
        Assert.assertEquals((long)1L, (long)selectedCells.size());
        Assert.assertEquals((long)1L, (long)((GridData.SelectedCell)selectedCells.get(0)).getRowIndex());
        Assert.assertEquals((long)0L, (long)((GridData.SelectedCell)selectedCells.get(0)).getColumnIndex());
    }

    @Test
    public void downCursorWithShiftKeyExtendsRangeDownOneCell() {
        Mockito.when((Object)this.layer.getGridWidgets()).thenReturn(this.gridWidgets);
        Mockito.when((Object)this.gridWidget1.isSelected()).thenReturn((Object)true);
        Mockito.when((Object)this.gridWidget1.selectCell(Mockito.eq((int)1), Mockito.eq((int)0), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), ((Boolean)Mockito.any(Boolean.class)).booleanValue())).thenReturn((Object)true);
        Mockito.when((Object)this.event.getNativeKeyCode()).thenReturn((Object)40);
        Mockito.when((Object)this.event.isShiftKeyDown()).thenReturn((Object)true);
        this.gridWidget1.getModel().selectCell(0, 0);
        this.handler.onKeyDown(this.event);
        ((DefaultGridLayer)Mockito.verify((Object)this.layer, (VerificationMode)Mockito.times((int)1))).draw();
        ((KeyboardOperation)Mockito.verify((Object)this.keyboardOperationMoveDown, (VerificationMode)Mockito.times((int)1))).perform((GridWidget)Mockito.eq((Object)this.gridWidget1), Mockito.eq((boolean)true), Mockito.eq((boolean)false));
        List selectedCells = this.gridWidget1Data.getSelectedCells();
        Assert.assertEquals((long)2L, (long)selectedCells.size());
        Assert.assertEquals((long)0L, (long)((GridData.SelectedCell)selectedCells.get(0)).getRowIndex());
        Assert.assertEquals((long)0L, (long)((GridData.SelectedCell)selectedCells.get(0)).getColumnIndex());
        Assert.assertEquals((long)1L, (long)((GridData.SelectedCell)selectedCells.get(1)).getRowIndex());
        Assert.assertEquals((long)0L, (long)((GridData.SelectedCell)selectedCells.get(1)).getColumnIndex());
    }

    private void setupKeyboardOperations() {
        this.keyboardOperationClearCell = (KeyboardOperation)Mockito.spy((Object)new KeyboardOperationClearCell((GridLayer)this.layer));
        this.keyboardOperationEditCell = (KeyboardOperation)Mockito.spy((Object)new KeyboardOperationEditCell((GridLayer)this.layer));
        this.keyboardOperationMoveLeft = (KeyboardOperation)Mockito.spy((Object)new KeyboardOperationMoveLeft((GridLayer)this.layer));
        this.keyboardOperationMoveRight = (KeyboardOperation)Mockito.spy((Object)new KeyboardOperationMoveRight((GridLayer)this.layer));
        this.keyboardOperationMoveUp = (KeyboardOperation)Mockito.spy((Object)new KeyboardOperationMoveUp((GridLayer)this.layer));
        this.keyboardOperationMoveDown = (KeyboardOperation)Mockito.spy((Object)new KeyboardOperationMoveDown((GridLayer)this.layer));
        this.keyboardOperationSelectTopLeftCell = (KeyboardOperation)Mockito.spy((Object)new KeyboardOperationSelectTopLeftCell((GridLayer)this.layer));
        this.keyboardOperationSelectBottomRightCell = (KeyboardOperation)Mockito.spy((Object)new KeyboardOperationSelectBottomRightCell((GridLayer)this.layer));
        this.handler.addOperation(new KeyboardOperation[]{this.keyboardOperationClearCell, this.keyboardOperationEditCell, this.keyboardOperationMoveLeft, this.keyboardOperationMoveRight, this.keyboardOperationMoveUp, this.keyboardOperationMoveDown, this.keyboardOperationSelectTopLeftCell, this.keyboardOperationSelectBottomRightCell});
    }
}

