/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.impl;

import com.ait.lienzo.client.core.event.NodeMouseDoubleClickEvent;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.user.client.Command;
import java.util.ArrayList;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.BaseGridWidgetMouseDoubleClickHandler;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.DefaultGridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;

@RunWith(value=LienzoMockitoTestRunner.class)
public class BaseGridWidgetMouseDoubleClickHandlerTest {
    @Mock
    private GridWidget gridWidget;
    @Mock
    private Group header;
    @Mock
    private Viewport viewport;
    @Mock
    private DefaultGridLayer layer;
    @Mock
    private GridSelectionManager selectionManager;
    @Mock
    private GridPinnedModeManager pinnedModeManager;
    @Mock
    private GridRenderer renderer;
    @Mock
    private NodeMouseDoubleClickEvent event;
    @Mock
    private GridData uiModel;
    @Mock
    private BaseGridRendererHelper helper;
    @Mock
    private GridColumn<String> uiColumn;
    private BaseGridWidgetMouseDoubleClickHandler handler;

    @Before
    public void setup() {
        Mockito.when((Object)this.gridWidget.getViewport()).thenReturn((Object)this.viewport);
        Mockito.when((Object)this.gridWidget.getModel()).thenReturn((Object)this.uiModel);
        Mockito.when((Object)this.gridWidget.getRenderer()).thenReturn((Object)this.renderer);
        Mockito.when((Object)this.gridWidget.getRendererHelper()).thenReturn((Object)this.helper);
        Mockito.when((Object)this.gridWidget.getLayer()).thenReturn((Object)this.layer);
        Mockito.when((Object)this.gridWidget.getHeader()).thenReturn((Object)this.header);
        Mockito.when((Object)this.renderer.getHeaderHeight()).thenReturn((Object)64.0);
        Mockito.when((Object)this.renderer.getHeaderRowHeight()).thenReturn((Object)32.0);
        Mockito.when((Object)this.uiModel.getHeaderRowCount()).thenReturn((Object)2);
        Mockito.when((Object)this.uiModel.getColumnCount()).thenReturn((Object)1);
        Mockito.when((Object)this.uiModel.getColumns()).thenReturn((Object)new ArrayList<GridColumn<?>>(){
            {
                this.add(BaseGridWidgetMouseDoubleClickHandlerTest.this.uiColumn);
            }
        });
        BaseGridWidgetMouseDoubleClickHandler wrapped = new BaseGridWidgetMouseDoubleClickHandler(this.gridWidget, this.selectionManager, this.pinnedModeManager, this.renderer);
        this.handler = (BaseGridWidgetMouseDoubleClickHandler)Mockito.spy((Object)wrapped);
    }

    @Test
    public void skipInvisibleGrid() {
        Mockito.when((Object)this.gridWidget.isVisible()).thenReturn((Object)false);
        this.handler.onNodeMouseDoubleClick(this.event);
        ((BaseGridWidgetMouseDoubleClickHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).handleHeaderCellDoubleClick((NodeMouseDoubleClickEvent)Mockito.any(NodeMouseDoubleClickEvent.class));
        ((BaseGridWidgetMouseDoubleClickHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).handleBodyCellDoubleClick((NodeMouseDoubleClickEvent)Mockito.any(NodeMouseDoubleClickEvent.class));
        ((GridSelectionManager)Mockito.verify((Object)this.selectionManager, (VerificationMode)Mockito.never())).select((GridWidget)Mockito.eq((Object)this.gridWidget));
    }

    @Test
    public void enterPinnedMode() {
        Mockito.when((Object)this.gridWidget.isVisible()).thenReturn((Object)true);
        Mockito.when((Object)this.event.getX()).thenReturn((Object)100);
        Mockito.when((Object)this.event.getY()).thenReturn((Object)100);
        Mockito.when((Object)this.gridWidget.getLocation()).thenReturn((Object)new Point2D(100.0, 100.0));
        this.handler.onNodeMouseDoubleClick(this.event);
        ((BaseGridWidgetMouseDoubleClickHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).handleHeaderCellDoubleClick((NodeMouseDoubleClickEvent)Mockito.any(NodeMouseDoubleClickEvent.class));
        ((BaseGridWidgetMouseDoubleClickHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).handleBodyCellDoubleClick((NodeMouseDoubleClickEvent)Mockito.any(NodeMouseDoubleClickEvent.class));
        ((GridPinnedModeManager)Mockito.verify((Object)this.pinnedModeManager, (VerificationMode)Mockito.times((int)1))).enterPinnedMode((GridWidget)Mockito.eq((Object)this.gridWidget), (Command)Mockito.any(Command.class));
        ((GridPinnedModeManager)Mockito.verify((Object)this.pinnedModeManager, (VerificationMode)Mockito.never())).exitPinnedMode((Command)Mockito.any(Command.class));
    }

    @Test
    public void exitPinnedMode() {
        Mockito.when((Object)this.gridWidget.isVisible()).thenReturn((Object)true);
        Mockito.when((Object)this.pinnedModeManager.isGridPinned()).thenReturn((Object)true);
        Mockito.when((Object)this.event.getX()).thenReturn((Object)100);
        Mockito.when((Object)this.event.getY()).thenReturn((Object)100);
        Mockito.when((Object)this.gridWidget.getLocation()).thenReturn((Object)new Point2D(100.0, 100.0));
        this.handler.onNodeMouseDoubleClick(this.event);
        ((BaseGridWidgetMouseDoubleClickHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).handleHeaderCellDoubleClick((NodeMouseDoubleClickEvent)Mockito.any(NodeMouseDoubleClickEvent.class));
        ((BaseGridWidgetMouseDoubleClickHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).handleBodyCellDoubleClick((NodeMouseDoubleClickEvent)Mockito.any(NodeMouseDoubleClickEvent.class));
        ((GridPinnedModeManager)Mockito.verify((Object)this.pinnedModeManager, (VerificationMode)Mockito.never())).enterPinnedMode((GridWidget)Mockito.any(GridWidget.class), (Command)Mockito.any(Command.class));
        ((GridPinnedModeManager)Mockito.verify((Object)this.pinnedModeManager, (VerificationMode)Mockito.times((int)1))).exitPinnedMode((Command)Mockito.any(Command.class));
    }

    @Test
    public void basicCheckForBodyHandler() {
        Mockito.when((Object)this.gridWidget.isVisible()).thenReturn((Object)true);
        Mockito.when((Object)this.event.getX()).thenReturn((Object)100);
        Mockito.when((Object)this.event.getY()).thenReturn((Object)200);
        Mockito.when((Object)this.gridWidget.getLocation()).thenReturn((Object)new Point2D(100.0, 100.0));
        Mockito.when((Object)this.gridWidget.getHeight()).thenReturn((Object)200.0);
        BaseGridRendererHelper.ColumnInformation ci = new BaseGridRendererHelper.ColumnInformation(this.uiColumn, 0, 0.0);
        Mockito.when((Object)this.helper.getColumnInformation(((Double)Mockito.any(Double.class)).doubleValue())).thenReturn((Object)ci);
        this.handler.onNodeMouseDoubleClick(this.event);
        ((BaseGridWidgetMouseDoubleClickHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).handleHeaderCellDoubleClick((NodeMouseDoubleClickEvent)Mockito.any(NodeMouseDoubleClickEvent.class));
        ((BaseGridWidgetMouseDoubleClickHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).handleBodyCellDoubleClick((NodeMouseDoubleClickEvent)Mockito.any(NodeMouseDoubleClickEvent.class));
    }
}

