/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.impl;

import com.ait.lienzo.client.core.event.NodeMouseClickEvent;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.GridCellSelectorMouseClickHandler;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.CellSelectionStrategy;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.DefaultGridLayer;

@RunWith(value=LienzoMockitoTestRunner.class)
public class GridCellSelectorMouseClickHandlerTest {
    @Mock
    private GridWidget gridWidget;
    @Mock
    private Group header;
    @Mock
    private Viewport viewport;
    @Mock
    private DefaultGridLayer layer;
    @Mock
    private GridSelectionManager selectionManager;
    @Mock
    private GridRenderer renderer;
    @Mock
    private NodeMouseClickEvent event;
    @Mock
    private GridData uiModel;
    @Mock
    private BaseGridRendererHelper helper;
    @Mock
    private GridColumn<String> uiColumn;
    @Mock
    private GridRow uiRow;
    @Mock
    private GridCell uiCell;
    @Mock
    private CellSelectionStrategy cellSelectionStrategy;
    private GridCellSelectorMouseClickHandler handler;

    @Before
    public void setup() {
        Mockito.when((Object)this.gridWidget.getViewport()).thenReturn((Object)this.viewport);
        Mockito.when((Object)this.gridWidget.getModel()).thenReturn((Object)this.uiModel);
        Mockito.when((Object)this.gridWidget.getRenderer()).thenReturn((Object)this.renderer);
        Mockito.when((Object)this.gridWidget.getRendererHelper()).thenReturn((Object)this.helper);
        Mockito.when((Object)this.gridWidget.getLayer()).thenReturn((Object)this.layer);
        Mockito.when((Object)this.gridWidget.getHeader()).thenReturn((Object)this.header);
        Mockito.when((Object)this.gridWidget.getHeight()).thenReturn((Object)128.0);
        Mockito.when((Object)this.gridWidget.getLocation()).thenReturn((Object)new Point2D(100.0, 100.0));
        Mockito.when((Object)this.renderer.getHeaderHeight()).thenReturn((Object)64.0);
        Mockito.when((Object)this.renderer.getHeaderRowHeight()).thenReturn((Object)32.0);
        Mockito.when((Object)this.uiModel.getHeaderRowCount()).thenReturn((Object)2);
        Mockito.when((Object)this.uiModel.getColumnCount()).thenReturn((Object)1);
        Mockito.when((Object)this.uiModel.getColumns()).thenReturn((Object)new ArrayList<GridColumn<?>>(){
            {
                this.add(GridCellSelectorMouseClickHandlerTest.this.uiColumn);
            }
        });
        Mockito.when((Object)this.uiModel.getRowCount()).thenReturn((Object)1);
        Mockito.when((Object)this.uiModel.getRow(Mockito.eq((int)0))).thenReturn((Object)this.uiRow);
        Mockito.when((Object)this.uiRow.getHeight()).thenReturn((Object)64.0);
        Mockito.when((Object)this.uiCell.getSelectionManager()).thenReturn((Object)this.cellSelectionStrategy);
        GridCellSelectorMouseClickHandler wrapped = new GridCellSelectorMouseClickHandler(this.gridWidget, this.selectionManager, this.renderer);
        this.handler = (GridCellSelectorMouseClickHandler)Mockito.spy((Object)wrapped);
    }

    @Test
    public void skipInvisibleGrid() {
        Mockito.when((Object)this.gridWidget.isVisible()).thenReturn((Object)false);
        this.handler.onNodeMouseClick(this.event);
        ((GridCellSelectorMouseClickHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).handleBodyCellClick((NodeMouseClickEvent)Mockito.any(NodeMouseClickEvent.class));
    }

    @Test
    public void basicCheckForBodyHandlerWithinBodyBounds() {
        Mockito.when((Object)this.gridWidget.isVisible()).thenReturn((Object)true);
        Mockito.when((Object)this.event.getX()).thenReturn((Object)100);
        Mockito.when((Object)this.event.getY()).thenReturn((Object)200);
        BaseGridRendererHelper.ColumnInformation ci = new BaseGridRendererHelper.ColumnInformation(this.uiColumn, 0, 0.0);
        Mockito.when((Object)this.helper.getColumnInformation(((Double)Mockito.any(Double.class)).doubleValue())).thenReturn((Object)ci);
        this.handler.onNodeMouseClick(this.event);
        ((GridCellSelectorMouseClickHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).handleBodyCellClick((NodeMouseClickEvent)Mockito.any(NodeMouseClickEvent.class));
        ((GridWidget)Mockito.verify((Object)this.gridWidget, (VerificationMode)Mockito.times((int)1))).selectCell((Point2D)Mockito.any(Point2D.class), Mockito.eq((boolean)false), Mockito.eq((boolean)false));
    }

    @Test
    public void basicCheckForBodyHandlerOutsideBodyBounds() {
        Mockito.when((Object)this.gridWidget.isVisible()).thenReturn((Object)true);
        Mockito.when((Object)this.event.getX()).thenReturn((Object)100);
        Mockito.when((Object)this.event.getY()).thenReturn((Object)120);
        BaseGridRendererHelper.ColumnInformation ci = new BaseGridRendererHelper.ColumnInformation(this.uiColumn, 0, 0.0);
        Mockito.when((Object)this.helper.getColumnInformation(((Double)Mockito.any(Double.class)).doubleValue())).thenReturn((Object)ci);
        this.handler.onNodeMouseClick(this.event);
        ((GridCellSelectorMouseClickHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).handleBodyCellClick((NodeMouseClickEvent)Mockito.any(NodeMouseClickEvent.class));
        ((GridData)Mockito.verify((Object)this.uiModel, (VerificationMode)Mockito.never())).getCell(((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue());
    }

    @Test
    public void selectSingleCell() {
        Mockito.when((Object)this.gridWidget.isVisible()).thenReturn((Object)true);
        Mockito.when((Object)this.event.getX()).thenReturn((Object)100);
        Mockito.when((Object)this.event.getY()).thenReturn((Object)200);
        Mockito.when((Object)this.uiModel.getCell(((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue())).thenReturn((Object)this.uiCell);
        BaseGridRendererHelper.ColumnInformation ci = new BaseGridRendererHelper.ColumnInformation(this.uiColumn, 0, 0.0);
        Mockito.when((Object)this.helper.getColumnInformation(((Double)Mockito.any(Double.class)).doubleValue())).thenReturn((Object)ci);
        BaseGridRendererHelper.RenderingInformation ri = new BaseGridRendererHelper.RenderingInformation((Bounds)Mockito.mock(Bounds.class), (List)new ArrayList<GridColumn<?>>(){
            {
                this.add(GridCellSelectorMouseClickHandlerTest.this.uiColumn);
            }
        }, (BaseGridRendererHelper.RenderingBlockInformation)Mockito.mock(BaseGridRendererHelper.RenderingBlockInformation.class), (BaseGridRendererHelper.RenderingBlockInformation)Mockito.mock(BaseGridRendererHelper.RenderingBlockInformation.class), 0, 1, (List)new ArrayList<Double>(){
            {
                this.add(64.0);
            }
        }, false, false, 0.0, 2.0, 0.0);
        Mockito.when((Object)this.helper.getRenderingInformation()).thenReturn((Object)ri);
        this.handler.onNodeMouseClick(this.event);
        ((GridCellSelectorMouseClickHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).handleBodyCellClick((NodeMouseClickEvent)Mockito.any(NodeMouseClickEvent.class));
        ((GridWidget)Mockito.verify((Object)this.gridWidget, (VerificationMode)Mockito.times((int)1))).selectCell((Point2D)Mockito.any(Point2D.class), Mockito.eq((boolean)false), Mockito.eq((boolean)false));
    }
}

