/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.layer.impl;

import com.ait.lienzo.client.core.mediator.Mediators;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Transform;
import com.ait.lienzo.client.widget.LienzoPanel;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.user.client.Command;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.BaseGridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.DefaultGridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLayerRedrawManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;

@RunWith(value=LienzoMockitoTestRunner.class)
public class DefaultGridLayerTest {
    @Mock
    private Viewport viewport;
    @Mock
    private GridRenderer renderer;
    @Mock
    private Mediators mediators;
    private GridLayer gridLayer;
    private Transform transform;

    @Before
    public void setup() {
        this.transform = new Transform();
        LienzoPanel panel = new LienzoPanel(500, 500);
        DefaultGridLayer wrapped = new DefaultGridLayer(){

            public Layer batch() {
                return this;
            }

            public Layer batch(GridLayerRedrawManager.PrioritizedCommand command) {
                return this;
            }
        };
        panel.add((Layer)wrapped);
        this.gridLayer = (GridLayer)Mockito.spy((Object)wrapped);
        Mockito.when((Object)this.gridLayer.getViewport()).thenReturn((Object)this.viewport);
        Mockito.when((Object)this.viewport.getTransform()).thenReturn((Object)this.transform);
        Mockito.when((Object)this.viewport.getMediators()).thenReturn((Object)this.mediators);
    }

    private GridWidget makeGridWidget() {
        BaseGridData uiModel = new BaseGridData();
        return new BaseGridWidget((GridData)uiModel, (GridSelectionManager)this.gridLayer, (GridPinnedModeManager)this.gridLayer, this.renderer){

            public void select() {
            }
        };
    }

    @Test
    public void checkFlipToGridWidgetWhenPinned() {
        GridWidget gridWidget = this.makeGridWidget();
        this.gridLayer.add((Object)gridWidget);
        this.gridLayer.enterPinnedMode(gridWidget, (Command)new GridLayerRedrawManager.PrioritizedCommand(0){

            public void execute() {
            }
        });
        this.gridLayer.flipToGridWidget(gridWidget);
        ((GridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.times((int)1))).updatePinnedContext((GridWidget)Mockito.eq((Object)gridWidget));
        ((GridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.times((int)1))).batch((GridLayerRedrawManager.PrioritizedCommand)Mockito.any(GridLayerRedrawManager.PrioritizedCommand.class));
    }

    @Test
    public void checkFlipToGridWidgetWhenNotPinned() {
        GridWidget gridWidget = this.makeGridWidget();
        this.gridLayer.add((Object)gridWidget);
        this.gridLayer.flipToGridWidget(gridWidget);
        ((GridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.never())).updatePinnedContext((GridWidget)Mockito.eq((Object)gridWidget));
        ((GridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.never())).batch((GridLayerRedrawManager.PrioritizedCommand)Mockito.any(GridLayerRedrawManager.PrioritizedCommand.class));
    }

    @Test
    public void checkScrollToGridWidgetWhenPinned() {
        GridWidget gridWidget = this.makeGridWidget();
        this.gridLayer.add((Object)gridWidget);
        this.gridLayer.enterPinnedMode(gridWidget, (Command)new GridLayerRedrawManager.PrioritizedCommand(0){

            public void execute() {
            }
        });
        this.gridLayer.scrollToGridWidget(gridWidget);
        ((GridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.never())).select((GridWidget)Mockito.eq((Object)gridWidget));
    }

    @Test
    public void checkScrollToGridWidgetWhenNotPinned() {
        GridWidget gridWidget = this.makeGridWidget();
        this.gridLayer.add((Object)gridWidget);
        this.gridLayer.scrollToGridWidget(gridWidget);
        ((GridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.times((int)1))).select((GridWidget)Mockito.eq((Object)gridWidget));
    }

    @Test
    public void checkRemoveAllClearsCachedReferences() {
        GridWidget gridWidget1 = this.makeGridWidget();
        GridColumn column1 = (GridColumn)Mockito.mock(GridColumn.class);
        Mockito.when((Object)column1.isVisible()).thenReturn((Object)true);
        gridWidget1.getModel().appendColumn(column1);
        GridWidget gridWidget2 = this.makeGridWidget();
        GridColumn column2 = (GridColumn)Mockito.mock(GridColumn.class);
        Mockito.when((Object)column2.isVisible()).thenReturn((Object)true);
        Mockito.when((Object)column2.isLinked()).thenReturn((Object)true);
        Mockito.when((Object)column2.getLink()).thenReturn((Object)column1);
        gridWidget2.getModel().appendColumn(column2);
        this.gridLayer.add((Object)gridWidget1);
        this.gridLayer.add((Object)gridWidget2);
        Assert.assertEquals((long)2L, (long)this.gridLayer.getGridWidgets().size());
        Assert.assertEquals((long)1L, (long)this.gridLayer.getGridWidgetConnectors().size());
        this.gridLayer.removeAll();
        Assert.assertEquals((long)0L, (long)this.gridLayer.getGridWidgets().size());
        Assert.assertEquals((long)0L, (long)this.gridLayer.getGridWidgetConnectors().size());
    }

    @Test
    public void checkConnectorsVisibilityFollowPinnedModeStatus() {
        GridWidget gridWidget1 = this.makeGridWidget();
        GridColumn column1 = (GridColumn)Mockito.mock(GridColumn.class);
        Mockito.when((Object)column1.isVisible()).thenReturn((Object)true);
        gridWidget1.getModel().appendColumn(column1);
        GridWidget gridWidget2 = this.makeGridWidget();
        GridColumn column2 = (GridColumn)Mockito.mock(GridColumn.class);
        Mockito.when((Object)column2.isVisible()).thenReturn((Object)true);
        Mockito.when((Object)column2.isLinked()).thenReturn((Object)true);
        Mockito.when((Object)column2.getLink()).thenReturn((Object)column1);
        gridWidget2.getModel().appendColumn(column2);
        this.gridLayer.add((Object)gridWidget1);
        this.gridLayer.add((Object)gridWidget2);
        this.gridLayer.refreshGridWidgetConnectors();
        this.checkConnectorsVisibility(true);
        this.gridLayer.enterPinnedMode(gridWidget1, (Command)new GridLayerRedrawManager.PrioritizedCommand(0){

            public void execute() {
            }
        });
        this.gridLayer.refreshGridWidgetConnectors();
        this.checkConnectorsVisibility(false);
    }

    private void checkConnectorsVisibility(boolean isVisible) {
        Set connectors = this.gridLayer.getGridWidgetConnectors();
        Assert.assertEquals((long)1L, (long)connectors.size());
        Assert.assertEquals((Object)isVisible, (Object)((IPrimitive)connectors.iterator().next()).isVisible());
    }
}

