/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl;

import com.ait.lienzo.client.core.event.NodeMouseDownEvent;
import com.ait.lienzo.client.core.event.NodeMouseMoveEvent;
import com.ait.lienzo.client.core.event.NodeMouseUpEvent;
import com.ait.lienzo.client.core.shape.Attributes;
import com.ait.lienzo.client.core.shape.Scene;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Transform;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.shared.GwtEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseBounds;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.TransformMediator;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl.BoundaryTransformMediator;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl.RestrictedMousePanMediator;

@RunWith(value=LienzoMockitoTestRunner.class)
public class BoundaryMousePanMediatorTest {
    private final Bounds bounds = new BaseBounds(-1000.0, -1000.0, 2000.0, 2000.0);
    private final Bounds visibleBounds = new BaseBounds(-500.0, -500.0, 1000.0, 1000.0);
    private RestrictedMousePanMediator mediator;
    @Mock
    private GridLayer viewLayer;
    @Mock
    private Viewport viewport;
    @Mock
    private Scene scene;
    @Mock
    private Attributes attributes;
    @Mock
    private DivElement vpElement;
    @Mock
    private Style vpStyle;
    private Transform transform;

    @Before
    public void setup() {
        this.transform = new Transform();
        Mockito.when((Object)this.viewLayer.getVisibleBounds()).thenReturn((Object)this.visibleBounds);
        Mockito.when((Object)this.viewLayer.getViewport()).thenReturn((Object)this.viewport);
        Mockito.when((Object)this.viewport.getElement()).thenReturn((Object)this.vpElement);
        Mockito.when((Object)this.vpElement.getStyle()).thenReturn((Object)this.vpStyle);
        Mockito.when((Object)this.viewport.getTransform()).thenReturn((Object)this.transform);
        Mockito.when((Object)this.viewport.getAttributes()).thenReturn((Object)this.attributes);
        Mockito.when((Object)this.viewport.getScene()).thenReturn((Object)this.scene);
        this.mediator = new RestrictedMousePanMediator(this.viewLayer);
        this.mediator.setTransformMediator((TransformMediator)new BoundaryTransformMediator(this.bounds));
        this.mediator.setViewport(this.viewport);
    }

    @Test
    public void testMouseDownEvent() {
        MouseDownEvent md0 = (MouseDownEvent)Mockito.mock(MouseDownEvent.class);
        Mockito.when((Object)md0.getRelativeX((Element)Mockito.any(Element.class))).thenReturn((Object)0);
        Mockito.when((Object)md0.getRelativeY((Element)Mockito.any(Element.class))).thenReturn((Object)0);
        NodeMouseDownEvent nmd0 = new NodeMouseDownEvent(md0);
        this.mediator.handleEvent((GwtEvent)nmd0);
        ((Style)Mockito.verify((Object)this.vpStyle, (VerificationMode)Mockito.times((int)1))).setCursor((Style.Cursor)Mockito.eq((Object)Style.Cursor.MOVE));
    }

    @Test
    public void testMouseUpEvent() {
        MouseDownEvent md0 = (MouseDownEvent)Mockito.mock(MouseDownEvent.class);
        Mockito.when((Object)md0.getRelativeX((Element)Mockito.any(Element.class))).thenReturn((Object)0);
        Mockito.when((Object)md0.getRelativeY((Element)Mockito.any(Element.class))).thenReturn((Object)0);
        NodeMouseDownEvent nmd0 = new NodeMouseDownEvent(md0);
        MouseUpEvent mu0 = (MouseUpEvent)Mockito.mock(MouseUpEvent.class);
        NodeMouseUpEvent nmu0 = new NodeMouseUpEvent(mu0);
        this.mediator.handleEvent((GwtEvent)nmd0);
        this.mediator.handleEvent((GwtEvent)nmu0);
        ((Style)Mockito.verify((Object)this.vpStyle, (VerificationMode)Mockito.times((int)1))).setCursor((Style.Cursor)Mockito.eq((Object)Style.Cursor.MOVE));
        ((Style)Mockito.verify((Object)this.vpStyle, (VerificationMode)Mockito.times((int)1))).setCursor((Style.Cursor)Mockito.eq((Object)Style.Cursor.DEFAULT));
    }

    @Test
    public void testMouseMoveEvent_LeftEdge() {
        MouseDownEvent md0 = (MouseDownEvent)Mockito.mock(MouseDownEvent.class);
        Mockito.when((Object)md0.getRelativeX((Element)Mockito.any(Element.class))).thenReturn((Object)0);
        Mockito.when((Object)md0.getRelativeY((Element)Mockito.any(Element.class))).thenReturn((Object)0);
        NodeMouseDownEvent nmd0 = new NodeMouseDownEvent(md0);
        MouseMoveEvent mm1 = (MouseMoveEvent)Mockito.mock(MouseMoveEvent.class);
        Mockito.when((Object)mm1.getRelativeX((Element)Mockito.any(Element.class))).thenReturn((Object)1200);
        Mockito.when((Object)mm1.getRelativeY((Element)Mockito.any(Element.class))).thenReturn((Object)0);
        NodeMouseMoveEvent nmm1 = new NodeMouseMoveEvent(mm1);
        ArgumentCaptor transformArgumentCaptor = ArgumentCaptor.forClass(Transform.class);
        this.mediator.handleEvent((GwtEvent)nmd0);
        this.mediator.handleEvent((GwtEvent)nmm1);
        ((Viewport)Mockito.verify((Object)this.viewport, (VerificationMode)Mockito.times((int)1))).setTransform((Transform)transformArgumentCaptor.capture());
        Transform result = (Transform)transformArgumentCaptor.getValue();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)1000.0, (double)result.getTranslateX(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)result.getTranslateY(), (double)0.0);
    }

    @Test
    public void testMouseMoveEvent_RightEdge() {
        MouseDownEvent md0 = (MouseDownEvent)Mockito.mock(MouseDownEvent.class);
        Mockito.when((Object)md0.getRelativeX((Element)Mockito.any(Element.class))).thenReturn((Object)0);
        Mockito.when((Object)md0.getRelativeY((Element)Mockito.any(Element.class))).thenReturn((Object)0);
        NodeMouseDownEvent nmd0 = new NodeMouseDownEvent(md0);
        MouseMoveEvent mm1 = (MouseMoveEvent)Mockito.mock(MouseMoveEvent.class);
        Mockito.when((Object)mm1.getRelativeX((Element)Mockito.any(Element.class))).thenReturn((Object)-200);
        Mockito.when((Object)mm1.getRelativeY((Element)Mockito.any(Element.class))).thenReturn((Object)0);
        NodeMouseMoveEvent nmm1 = new NodeMouseMoveEvent(mm1);
        ArgumentCaptor transformArgumentCaptor = ArgumentCaptor.forClass(Transform.class);
        this.mediator.handleEvent((GwtEvent)nmd0);
        this.mediator.handleEvent((GwtEvent)nmm1);
        ((Viewport)Mockito.verify((Object)this.viewport, (VerificationMode)Mockito.times((int)1))).setTransform((Transform)transformArgumentCaptor.capture());
        Transform result = (Transform)transformArgumentCaptor.getValue();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)0.0, (double)result.getTranslateX(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)result.getTranslateY(), (double)0.0);
    }

    @Test
    public void testMouseMoveEvent_TopEdge() {
        MouseDownEvent md0 = (MouseDownEvent)Mockito.mock(MouseDownEvent.class);
        Mockito.when((Object)md0.getRelativeX((Element)Mockito.any(Element.class))).thenReturn((Object)0);
        Mockito.when((Object)md0.getRelativeY((Element)Mockito.any(Element.class))).thenReturn((Object)0);
        NodeMouseDownEvent nmd0 = new NodeMouseDownEvent(md0);
        MouseMoveEvent mm1 = (MouseMoveEvent)Mockito.mock(MouseMoveEvent.class);
        Mockito.when((Object)mm1.getRelativeX((Element)Mockito.any(Element.class))).thenReturn((Object)0);
        Mockito.when((Object)mm1.getRelativeY((Element)Mockito.any(Element.class))).thenReturn((Object)1200);
        NodeMouseMoveEvent nmm1 = new NodeMouseMoveEvent(mm1);
        ArgumentCaptor transformArgumentCaptor = ArgumentCaptor.forClass(Transform.class);
        this.mediator.handleEvent((GwtEvent)nmd0);
        this.mediator.handleEvent((GwtEvent)nmm1);
        ((Viewport)Mockito.verify((Object)this.viewport, (VerificationMode)Mockito.times((int)1))).setTransform((Transform)transformArgumentCaptor.capture());
        Transform result = (Transform)transformArgumentCaptor.getValue();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)0.0, (double)result.getTranslateX(), (double)0.0);
        Assert.assertEquals((double)1000.0, (double)result.getTranslateY(), (double)0.0);
    }

    @Test
    public void testMouseMoveEvent_BottomEdge() {
        MouseDownEvent md0 = (MouseDownEvent)Mockito.mock(MouseDownEvent.class);
        Mockito.when((Object)md0.getRelativeX((Element)Mockito.any(Element.class))).thenReturn((Object)0);
        Mockito.when((Object)md0.getRelativeY((Element)Mockito.any(Element.class))).thenReturn((Object)0);
        NodeMouseDownEvent nmd0 = new NodeMouseDownEvent(md0);
        MouseMoveEvent mm1 = (MouseMoveEvent)Mockito.mock(MouseMoveEvent.class);
        Mockito.when((Object)mm1.getRelativeX((Element)Mockito.any(Element.class))).thenReturn((Object)0);
        Mockito.when((Object)mm1.getRelativeY((Element)Mockito.any(Element.class))).thenReturn((Object)-200);
        NodeMouseMoveEvent nmm1 = new NodeMouseMoveEvent(mm1);
        ArgumentCaptor transformArgumentCaptor = ArgumentCaptor.forClass(Transform.class);
        this.mediator.handleEvent((GwtEvent)nmd0);
        this.mediator.handleEvent((GwtEvent)nmm1);
        ((Viewport)Mockito.verify((Object)this.viewport, (VerificationMode)Mockito.times((int)1))).setTransform((Transform)transformArgumentCaptor.capture());
        Transform result = (Transform)transformArgumentCaptor.getValue();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)0.0, (double)result.getTranslateX(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)result.getTranslateY(), (double)0.0);
    }

    @Test
    public void testMouseMoveEvent_LeftEdge_Scaled50pct() {
        MouseDownEvent md0 = (MouseDownEvent)Mockito.mock(MouseDownEvent.class);
        Mockito.when((Object)md0.getRelativeX((Element)Mockito.any(Element.class))).thenReturn((Object)0);
        Mockito.when((Object)md0.getRelativeY((Element)Mockito.any(Element.class))).thenReturn((Object)0);
        NodeMouseDownEvent nmd0 = new NodeMouseDownEvent(md0);
        MouseMoveEvent mm1 = (MouseMoveEvent)Mockito.mock(MouseMoveEvent.class);
        Mockito.when((Object)mm1.getRelativeX((Element)Mockito.any(Element.class))).thenReturn((Object)1200);
        Mockito.when((Object)mm1.getRelativeY((Element)Mockito.any(Element.class))).thenReturn((Object)0);
        NodeMouseMoveEvent nmm1 = new NodeMouseMoveEvent(mm1);
        ArgumentCaptor transformArgumentCaptor = ArgumentCaptor.forClass(Transform.class);
        this.transform.scale(0.5, 0.5);
        this.mediator.handleEvent((GwtEvent)nmd0);
        this.mediator.handleEvent((GwtEvent)nmm1);
        ((Viewport)Mockito.verify((Object)this.viewport, (VerificationMode)Mockito.times((int)1))).setTransform((Transform)transformArgumentCaptor.capture());
        Transform result = (Transform)transformArgumentCaptor.getValue();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)500.0, (double)result.getTranslateX(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)result.getTranslateY(), (double)0.0);
    }

    @Test
    public void testMouseMoveEvent_RightEdge_Scaled50pct() {
        MouseDownEvent md0 = (MouseDownEvent)Mockito.mock(MouseDownEvent.class);
        Mockito.when((Object)md0.getRelativeX((Element)Mockito.any(Element.class))).thenReturn((Object)0);
        Mockito.when((Object)md0.getRelativeY((Element)Mockito.any(Element.class))).thenReturn((Object)0);
        NodeMouseDownEvent nmd0 = new NodeMouseDownEvent(md0);
        MouseMoveEvent mm1 = (MouseMoveEvent)Mockito.mock(MouseMoveEvent.class);
        Mockito.when((Object)mm1.getRelativeX((Element)Mockito.any(Element.class))).thenReturn((Object)-200);
        Mockito.when((Object)mm1.getRelativeY((Element)Mockito.any(Element.class))).thenReturn((Object)0);
        NodeMouseMoveEvent nmm1 = new NodeMouseMoveEvent(mm1);
        ArgumentCaptor transformArgumentCaptor = ArgumentCaptor.forClass(Transform.class);
        this.transform.scale(0.5, 0.5);
        this.mediator.handleEvent((GwtEvent)nmd0);
        this.mediator.handleEvent((GwtEvent)nmm1);
        ((Viewport)Mockito.verify((Object)this.viewport, (VerificationMode)Mockito.times((int)1))).setTransform((Transform)transformArgumentCaptor.capture());
        Transform result = (Transform)transformArgumentCaptor.getValue();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)0.0, (double)result.getTranslateX(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)result.getTranslateY(), (double)0.0);
    }

    @Test
    public void testMouseMoveEvent_TopEdge_Scaled50pct() {
        MouseDownEvent md0 = (MouseDownEvent)Mockito.mock(MouseDownEvent.class);
        Mockito.when((Object)md0.getRelativeX((Element)Mockito.any(Element.class))).thenReturn((Object)0);
        Mockito.when((Object)md0.getRelativeY((Element)Mockito.any(Element.class))).thenReturn((Object)0);
        NodeMouseDownEvent nmd0 = new NodeMouseDownEvent(md0);
        MouseMoveEvent mm1 = (MouseMoveEvent)Mockito.mock(MouseMoveEvent.class);
        Mockito.when((Object)mm1.getRelativeX((Element)Mockito.any(Element.class))).thenReturn((Object)0);
        Mockito.when((Object)mm1.getRelativeY((Element)Mockito.any(Element.class))).thenReturn((Object)1200);
        NodeMouseMoveEvent nmm1 = new NodeMouseMoveEvent(mm1);
        ArgumentCaptor transformArgumentCaptor = ArgumentCaptor.forClass(Transform.class);
        this.transform.scale(0.5, 0.5);
        this.mediator.handleEvent((GwtEvent)nmd0);
        this.mediator.handleEvent((GwtEvent)nmm1);
        ((Viewport)Mockito.verify((Object)this.viewport, (VerificationMode)Mockito.times((int)1))).setTransform((Transform)transformArgumentCaptor.capture());
        Transform result = (Transform)transformArgumentCaptor.getValue();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)0.0, (double)result.getTranslateX(), (double)0.0);
        Assert.assertEquals((double)500.0, (double)result.getTranslateY(), (double)0.0);
    }

    @Test
    public void testMouseMoveEvent_BottomEdge_Scaled50pct() {
        MouseDownEvent md0 = (MouseDownEvent)Mockito.mock(MouseDownEvent.class);
        Mockito.when((Object)md0.getRelativeX((Element)Mockito.any(Element.class))).thenReturn((Object)0);
        Mockito.when((Object)md0.getRelativeY((Element)Mockito.any(Element.class))).thenReturn((Object)0);
        NodeMouseDownEvent nmd0 = new NodeMouseDownEvent(md0);
        MouseMoveEvent mm1 = (MouseMoveEvent)Mockito.mock(MouseMoveEvent.class);
        Mockito.when((Object)mm1.getRelativeX((Element)Mockito.any(Element.class))).thenReturn((Object)0);
        Mockito.when((Object)mm1.getRelativeY((Element)Mockito.any(Element.class))).thenReturn((Object)-200);
        NodeMouseMoveEvent nmm1 = new NodeMouseMoveEvent(mm1);
        ArgumentCaptor transformArgumentCaptor = ArgumentCaptor.forClass(Transform.class);
        this.transform.scale(0.5, 0.5);
        this.mediator.handleEvent((GwtEvent)nmd0);
        this.mediator.handleEvent((GwtEvent)nmm1);
        ((Viewport)Mockito.verify((Object)this.viewport, (VerificationMode)Mockito.times((int)1))).setTransform((Transform)transformArgumentCaptor.capture());
        Transform result = (Transform)transformArgumentCaptor.getValue();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)0.0, (double)result.getTranslateX(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)result.getTranslateY(), (double)0.0);
    }
}

