/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl;

import com.ait.lienzo.client.core.types.Transform;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseBounds;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl.BoundaryTransformMediator;

@RunWith(value=LienzoMockitoTestRunner.class)
public class BoundaryTransformMediatorTest {
    private final Bounds bounds = new BaseBounds(-1000.0, -1000.0, 2000.0, 2000.0);
    private BoundaryTransformMediator restriction;

    @Before
    public void setup() {
        this.restriction = new BoundaryTransformMediator(this.bounds);
    }

    @Test
    public void testLeftEdge() {
        BaseBounds visibleBounds = new BaseBounds(-500.0, -500.0, 1000.0, 1000.0);
        Transform test = new Transform().translate(1200.0, 0.0);
        Transform result = this.restriction.adjust(test, (Bounds)visibleBounds);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)1000.0, (double)result.getTranslateX(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)result.getTranslateY(), (double)0.0);
    }

    @Test
    public void testRightEdge() {
        BaseBounds visibleBounds = new BaseBounds(-500.0, -500.0, 1000.0, 1000.0);
        Transform test = new Transform().translate(-200.0, 0.0);
        Transform result = this.restriction.adjust(test, (Bounds)visibleBounds);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)0.0, (double)result.getTranslateX(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)result.getTranslateY(), (double)0.0);
    }

    @Test
    public void testTopEdge() {
        BaseBounds visibleBounds = new BaseBounds(-500.0, -500.0, 1000.0, 1000.0);
        Transform test = new Transform().translate(0.0, 1200.0);
        Transform result = this.restriction.adjust(test, (Bounds)visibleBounds);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)0.0, (double)result.getTranslateX(), (double)0.0);
        Assert.assertEquals((double)1000.0, (double)result.getTranslateY(), (double)0.0);
    }

    @Test
    public void testBottomEdge() {
        BaseBounds visibleBounds = new BaseBounds(-500.0, -500.0, 1000.0, 1000.0);
        Transform test = new Transform().translate(0.0, -200.0);
        Transform result = this.restriction.adjust(test, (Bounds)visibleBounds);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)0.0, (double)result.getTranslateX(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)result.getTranslateY(), (double)0.0);
    }
}

