/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl;

import com.ait.lienzo.client.core.mediator.IMediator;
import com.ait.lienzo.client.core.mediator.Mediators;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Transform;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.user.client.Command;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.TransformMediator;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl.DefaultPinnedModeManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl.GridTransformMediator;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl.RestrictedMousePanMediator;

@RunWith(value=LienzoMockitoTestRunner.class)
public class DefaultPinnedModeManagerTest {
    @Mock
    private GridLayer gridLayer;
    @Mock
    private Layer layer;
    @Mock
    private TransformMediator defaultMediator;
    @Mock
    private GridWidget gridWidget;
    @Mock
    private Viewport viewport;
    @Mock
    private Transform transform;
    @Mock
    private Command enterPinnedModeCommand;
    @Mock
    private Command exitPinnedModeCommand;
    private Mediators mediators;
    private GridPinnedModeManager manager;

    @Before
    public void setup() {
        this.manager = new DefaultPinnedModeManager(this.gridLayer){

            protected void doEnterPinnedMode(Command onStartCommand, GridWidget gridWidget, Set<GridWidget> gridWidgetsToFadeFromView, Set<IPrimitive<?>> gridWidgetConnectorsToFadeFromView) {
                Assert.assertEquals((Object)DefaultPinnedModeManagerTest.this.gridWidget, (Object)gridWidget);
                Assert.assertTrue((boolean)gridWidgetsToFadeFromView.isEmpty());
                Assert.assertTrue((boolean)gridWidgetConnectorsToFadeFromView.isEmpty());
                onStartCommand.execute();
            }

            protected void doExitPinnedMode(Command onCompleteCommand, Set<GridWidget> gridWidgetsToFadeIntoView, Set<IPrimitive<?>> gridWidgetConnectorsToFadeIntoView) {
                Assert.assertTrue((boolean)gridWidgetsToFadeIntoView.isEmpty());
                Assert.assertTrue((boolean)gridWidgetConnectorsToFadeIntoView.isEmpty());
                onCompleteCommand.execute();
            }
        };
        this.mediators = new Mediators(this.viewport);
        this.mediators.push((IMediator)new RestrictedMousePanMediator(this.gridLayer));
        Mockito.when((Object)this.gridLayer.getViewport()).thenReturn((Object)this.viewport);
        Mockito.when((Object)this.gridLayer.getDefaultTransformMediator()).thenReturn((Object)this.defaultMediator);
        Mockito.when((Object)this.gridWidget.getViewport()).thenReturn((Object)this.viewport);
        Mockito.when((Object)this.gridWidget.getLayer()).thenReturn((Object)this.layer);
        Mockito.when((Object)this.viewport.getMediators()).thenReturn((Object)this.mediators);
        Mockito.when((Object)this.viewport.getTransform()).thenReturn((Object)this.transform);
        Mockito.when((Object)this.transform.copy()).thenReturn((Object)this.transform);
        Mockito.when((Object)this.transform.getInverse()).thenReturn((Object)this.transform);
    }

    @Test
    public void enteringPinnedModeSetsMediatorToGridTransformMediator() {
        this.manager.enterPinnedMode(this.gridWidget, this.enterPinnedModeCommand);
        ((Command)Mockito.verify((Object)this.enterPinnedModeCommand, (VerificationMode)Mockito.times((int)1))).execute();
        Assert.assertNotNull((Object)this.manager.getPinnedContext());
        IMediator mediator = this.mediators.pop();
        Assert.assertTrue((boolean)(mediator instanceof RestrictedMousePanMediator));
        RestrictedMousePanMediator rmpm = (RestrictedMousePanMediator)mediator;
        TransformMediator tm = rmpm.getTransformMediator();
        Assert.assertTrue((boolean)(tm instanceof GridTransformMediator));
    }

    @Test
    public void exitingPinnedModeSetsMediatorToDefaultTransformMediator() {
        this.manager.enterPinnedMode(this.gridWidget, this.enterPinnedModeCommand);
        this.manager.exitPinnedMode(this.exitPinnedModeCommand);
        ((Command)Mockito.verify((Object)this.exitPinnedModeCommand, (VerificationMode)Mockito.times((int)1))).execute();
        Assert.assertNull((Object)this.manager.getPinnedContext());
        IMediator mediator = this.mediators.pop();
        Assert.assertTrue((boolean)(mediator instanceof RestrictedMousePanMediator));
        RestrictedMousePanMediator rmpm = (RestrictedMousePanMediator)mediator;
        TransformMediator tm = rmpm.getTransformMediator();
        Assert.assertEquals((Object)this.defaultMediator, (Object)tm);
    }
}

