/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl;

import com.ait.lienzo.client.core.types.Transform;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseBounds;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl.GridTransformMediator;

@RunWith(value=LienzoMockitoTestRunner.class)
public class GridTransformMediatorTest {
    private GridTransformMediator restriction;
    @Mock
    private GridWidget grid;

    @Before
    public void setup() {
        this.restriction = new GridTransformMediator(this.grid);
    }

    @Test
    public void testGridNarrowerThanVisibleBounds() {
        Mockito.when((Object)this.grid.getX()).thenReturn((Object)10.0);
        Mockito.when((Object)this.grid.getY()).thenReturn((Object)0.0);
        Mockito.when((Object)this.grid.getWidth()).thenReturn((Object)100.0);
        Mockito.when((Object)this.grid.getHeight()).thenReturn((Object)100.0);
        BaseBounds visibleBounds = new BaseBounds(-500.0, -500.0, 1000.0, 1000.0);
        Transform test = new Transform().translate(1200.0, 0.0);
        Transform result = this.restriction.adjust(test, (Bounds)visibleBounds);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)-10.0, (double)result.getTranslateX(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)result.getTranslateY(), (double)0.0);
    }

    @Test
    public void testGridShorterThanVisibleBounds() {
        Mockito.when((Object)this.grid.getX()).thenReturn((Object)0.0);
        Mockito.when((Object)this.grid.getY()).thenReturn((Object)10.0);
        Mockito.when((Object)this.grid.getWidth()).thenReturn((Object)100.0);
        Mockito.when((Object)this.grid.getHeight()).thenReturn((Object)100.0);
        BaseBounds visibleBounds = new BaseBounds(-500.0, -500.0, 1000.0, 1000.0);
        Transform test = new Transform().translate(1200.0, 0.0);
        Transform result = this.restriction.adjust(test, (Bounds)visibleBounds);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)0.0, (double)result.getTranslateX(), (double)0.0);
        Assert.assertEquals((double)-10.0, (double)result.getTranslateY(), (double)0.0);
    }

    @Test
    public void testGridWiderThanVisibleBoundsLeftEdge() {
        Mockito.when((Object)this.grid.getX()).thenReturn((Object)10.0);
        Mockito.when((Object)this.grid.getY()).thenReturn((Object)0.0);
        Mockito.when((Object)this.grid.getWidth()).thenReturn((Object)1100.0);
        Mockito.when((Object)this.grid.getHeight()).thenReturn((Object)100.0);
        BaseBounds visibleBounds = new BaseBounds(-500.0, -500.0, 1000.0, 1000.0);
        Transform test = new Transform().translate(1200.0, 0.0);
        Transform result = this.restriction.adjust(test, (Bounds)visibleBounds);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)-10.0, (double)result.getTranslateX(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)result.getTranslateY(), (double)0.0);
    }

    @Test
    public void testGridWiderThanVisibleBoundsRightEdge() {
        Mockito.when((Object)this.grid.getX()).thenReturn((Object)10.0);
        Mockito.when((Object)this.grid.getY()).thenReturn((Object)0.0);
        Mockito.when((Object)this.grid.getWidth()).thenReturn((Object)1100.0);
        Mockito.when((Object)this.grid.getHeight()).thenReturn((Object)100.0);
        BaseBounds visibleBounds = new BaseBounds(-500.0, -500.0, 1000.0, 1000.0);
        Transform test = new Transform().translate(-200.0, 0.0);
        Transform result = this.restriction.adjust(test, (Bounds)visibleBounds);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)-110.0, (double)result.getTranslateX(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)result.getTranslateY(), (double)0.0);
    }

    @Test
    public void testGridTallerThanVisibleBoundsTopEdge() {
        Mockito.when((Object)this.grid.getX()).thenReturn((Object)0.0);
        Mockito.when((Object)this.grid.getY()).thenReturn((Object)10.0);
        Mockito.when((Object)this.grid.getWidth()).thenReturn((Object)100.0);
        Mockito.when((Object)this.grid.getHeight()).thenReturn((Object)1100.0);
        BaseBounds visibleBounds = new BaseBounds(-500.0, -500.0, 1000.0, 1000.0);
        Transform test = new Transform().translate(0.0, 1200.0);
        Transform result = this.restriction.adjust(test, (Bounds)visibleBounds);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)0.0, (double)result.getTranslateX(), (double)0.0);
        Assert.assertEquals((double)-10.0, (double)result.getTranslateY(), (double)0.0);
    }

    @Test
    public void testGridTallerThanVisibleBoundsBottomEdge() {
        Mockito.when((Object)this.grid.getX()).thenReturn((Object)0.0);
        Mockito.when((Object)this.grid.getY()).thenReturn((Object)10.0);
        Mockito.when((Object)this.grid.getWidth()).thenReturn((Object)100.0);
        Mockito.when((Object)this.grid.getHeight()).thenReturn((Object)1100.0);
        BaseBounds visibleBounds = new BaseBounds(-500.0, -500.0, 1000.0, 1000.0);
        Transform test = new Transform().translate(0.0, -200.0);
        Transform result = this.restriction.adjust(test, (Bounds)visibleBounds);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)0.0, (double)result.getTranslateX(), (double)0.0);
        Assert.assertEquals((double)-110.0, (double)result.getTranslateY(), (double)0.0);
    }
}

