/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.model.impl;

import com.ait.lienzo.client.core.shape.Group;
import org.junit.Assert;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridColumn;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseHeaderMetaData;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.impl.BaseGridColumnRenderer;

public abstract class BaseGridTest {
    public void assertGridIndexes(GridData data, boolean[] expectedRowMergeStates, boolean[] expectedRowCollapseStates, Expected[][] expectedCellStates) {
        if (data.getRowCount() != expectedRowMergeStates.length) {
            Assert.fail((String)"Size of parameter 'expectedRowMergeStates' differs to expected row count.");
        }
        if (data.getRowCount() != expectedRowCollapseStates.length) {
            Assert.fail((String)"Size of parameter 'expectedRowCollapseStates' differs to expected row count.");
        }
        if (data.getRowCount() != expectedCellStates.length) {
            Assert.fail((String)"Size of parameter 'expectedCellStates' differs to expected row count.");
        }
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            GridRow row = data.getRow(rowIndex);
            Assert.assertEquals((String)("Row[" + rowIndex + "] actual isMerged() differs to expected."), (Object)expectedRowMergeStates[rowIndex], (Object)row.isMerged());
            Assert.assertEquals((String)("Row[" + rowIndex + "] actual isCollapsed() differs to expected."), (Object)expectedRowCollapseStates[rowIndex], (Object)row.isCollapsed());
            if (data.getColumnCount() != expectedCellStates[rowIndex].length) {
                Assert.fail((String)("Size of parameter 'expectedCellStates[" + rowIndex + "]' differs to expected column count."));
            }
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                GridCell cell = data.getCell(rowIndex, columnIndex);
                if (cell == null) {
                    Assert.assertNull((String)("Cell[" + columnIndex + ", " + rowIndex + "] was expected to be null."), (Object)expectedCellStates[rowIndex][columnIndex].value);
                    continue;
                }
                Assert.assertEquals((String)("Cell[" + columnIndex + ", " + rowIndex + "] actual isMerged() differs to expected."), (Object)expectedCellStates[rowIndex][columnIndex].isMerged, (Object)cell.isMerged());
                Assert.assertEquals((String)("Cell[" + columnIndex + ", " + rowIndex + "] actual getMergedCellCount() differs to expected."), (long)expectedCellStates[rowIndex][columnIndex].mergedCellCount, (long)cell.getMergedCellCount());
                Assert.assertEquals((String)("Cell[" + columnIndex + ", " + rowIndex + "] actual getValue() differs to expected."), (Object)expectedCellStates[rowIndex][columnIndex].value, (Object)cell.getValue().getValue());
            }
        }
    }

    public static class MockMergableGridColumnRenderer<T>
    extends BaseGridColumnRenderer<T> {
        public Group renderCell(GridCell<T> cell, GridBodyCellRenderContext context) {
            return null;
        }
    }

    public static class MockMergableGridColumn<T>
    extends BaseGridColumn<T> {
        public MockMergableGridColumn(String title, double width) {
            super((GridColumn.HeaderMetaData)new BaseHeaderMetaData(title), new MockMergableGridColumnRenderer(), width);
        }

        public void edit(GridCell<T> cell, GridBodyCellRenderContext context, Callback<GridCellValue<T>> callback) {
        }
    }

    public static class Expected {
        private boolean isMerged;
        private int mergedCellCount;
        private Object value;

        private Expected(boolean isMerged, int mergedCellCount, Object value) {
            this.isMerged = isMerged;
            this.mergedCellCount = mergedCellCount;
            this.value = value;
        }

        private Expected(Object value) {
            this.value = value;
        }

        public static Expected build(Object value) {
            return new Expected(value);
        }

        public static Expected build(boolean isMerged, int mergedCellCount, Object value) {
            return new Expected(isMerged, mergedCellCount, value);
        }
    }
}

