/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridTest;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.DefaultSelectionsTransformer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.FloatingSelectionsTransformer;

public class GridCellSelectionsTransformationTest
extends BaseGridTest {
    @Test
    public void testTransformationVerticalRightExtent() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendColumn(gc3);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 2)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 2)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 2)));
        Assert.assertEquals((long)0L, (long)data.getSelectedCells().size());
        DefaultSelectionsTransformer transformer = new DefaultSelectionsTransformer((GridData)data, data.getColumns());
        List selectedRanges1 = transformer.transformToSelectedRanges();
        Assert.assertEquals((long)0L, (long)selectedRanges1.size());
        data.selectCell(1, 0);
        data.selectCell(1, 1);
        data.selectCell(1, 2);
        data.selectCell(0, 2);
        data.selectCell(2, 2);
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 2)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 2)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 2)));
        Assert.assertEquals((long)5L, (long)data.getSelectedCells().size());
        List selectedRanges2 = transformer.transformToSelectedRanges();
        Assert.assertEquals((long)2L, (long)selectedRanges2.size());
    }

    @Test
    public void testTransformationPlusSign() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendColumn(gc3);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 2)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 2)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 2)));
        Assert.assertEquals((long)0L, (long)data.getSelectedCells().size());
        DefaultSelectionsTransformer transformer = new DefaultSelectionsTransformer((GridData)data, data.getColumns());
        List selectedRanges1 = transformer.transformToSelectedRanges();
        Assert.assertEquals((long)0L, (long)selectedRanges1.size());
        data.selectCell(1, 0);
        data.selectCell(1, 1);
        data.selectCell(1, 2);
        data.selectCell(0, 1);
        data.selectCell(2, 1);
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 2)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 2)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 2)));
        Assert.assertEquals((long)5L, (long)data.getSelectedCells().size());
        List selectedRanges2 = transformer.transformToSelectedRanges();
        Assert.assertEquals((long)3L, (long)selectedRanges2.size());
    }

    @Test
    public void testTransformationColumnSubsetVerticalRightExtent() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendColumn(gc3);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 2)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 2)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 2)));
        Assert.assertEquals((long)0L, (long)data.getSelectedCells().size());
        DefaultSelectionsTransformer transformer1 = new DefaultSelectionsTransformer((GridData)data, data.getColumns());
        List selectedRanges1 = transformer1.transformToSelectedRanges();
        Assert.assertEquals((long)0L, (long)selectedRanges1.size());
        data.selectCell(1, 0);
        data.selectCell(1, 1);
        data.selectCell(1, 2);
        data.selectCell(0, 2);
        data.selectCell(2, 2);
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 2)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 2)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 2)));
        Assert.assertEquals((long)5L, (long)data.getSelectedCells().size());
        ArrayList columns = new ArrayList<GridColumn<?>>((GridColumn)gc1, (GridColumn)gc2){
            final /* synthetic */ GridColumn val$gc1;
            final /* synthetic */ GridColumn val$gc2;
            {
                this.val$gc1 = gridColumn;
                this.val$gc2 = gridColumn2;
                this.add(this.val$gc1);
                this.add(this.val$gc2);
            }
        };
        FloatingSelectionsTransformer transformer2 = new FloatingSelectionsTransformer((GridData)data, (List)columns);
        List selectedRanges2 = transformer2.transformToSelectedRanges();
        Assert.assertEquals((long)1L, (long)selectedRanges2.size());
    }

    @Test
    public void testTransformationColumnSubsetPlusSign() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendColumn(gc3);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 2)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 2)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 2)));
        Assert.assertEquals((long)0L, (long)data.getSelectedCells().size());
        DefaultSelectionsTransformer transformer1 = new DefaultSelectionsTransformer((GridData)data, data.getColumns());
        List selectedRanges1 = transformer1.transformToSelectedRanges();
        Assert.assertEquals((long)0L, (long)selectedRanges1.size());
        data.selectCell(1, 0);
        data.selectCell(1, 1);
        data.selectCell(1, 2);
        data.selectCell(0, 1);
        data.selectCell(2, 1);
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 2)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 2)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 2)));
        Assert.assertEquals((long)5L, (long)data.getSelectedCells().size());
        ArrayList columns = new ArrayList<GridColumn<?>>((GridColumn)gc1, (GridColumn)gc3){
            final /* synthetic */ GridColumn val$gc1;
            final /* synthetic */ GridColumn val$gc3;
            {
                this.val$gc1 = gridColumn;
                this.val$gc3 = gridColumn2;
                this.add(this.val$gc1);
                this.add(this.val$gc3);
            }
        };
        FloatingSelectionsTransformer transformer2 = new FloatingSelectionsTransformer((GridData)data, (List)columns);
        List selectedRanges2 = transformer2.transformToSelectedRanges();
        Assert.assertEquals((long)1L, (long)selectedRanges2.size());
    }

    @Test
    public void testTransformationSplitRows() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendColumn(gc3);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 2)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 2)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 2)));
        Assert.assertEquals((long)0L, (long)data.getSelectedCells().size());
        DefaultSelectionsTransformer transformer = new DefaultSelectionsTransformer((GridData)data, data.getColumns());
        List selectedRanges1 = transformer.transformToSelectedRanges();
        Assert.assertEquals((long)0L, (long)selectedRanges1.size());
        data.selectCell(0, 0);
        data.selectCell(0, 1);
        data.selectCell(0, 2);
        data.selectCell(2, 0);
        data.selectCell(2, 1);
        data.selectCell(2, 2);
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 2)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 2)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 2)));
        Assert.assertEquals((long)6L, (long)data.getSelectedCells().size());
        List selectedRanges2 = transformer.transformToSelectedRanges();
        Assert.assertEquals((long)2L, (long)selectedRanges2.size());
    }

    @Test
    public void testTransformationNeighbours() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendColumn(gc3);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 2)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 2)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 2)));
        Assert.assertEquals((long)0L, (long)data.getSelectedCells().size());
        DefaultSelectionsTransformer transformer = new DefaultSelectionsTransformer((GridData)data, data.getColumns());
        List selectedRanges1 = transformer.transformToSelectedRanges();
        Assert.assertEquals((long)0L, (long)selectedRanges1.size());
        data.selectCell(0, 0);
        data.selectCell(0, 2);
        data.selectCell(1, 0);
        data.selectCell(1, 2);
        data.selectCell(2, 1);
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 2)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 2)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 2)));
        Assert.assertEquals((long)5L, (long)data.getSelectedCells().size());
        List selectedRanges2 = transformer.transformToSelectedRanges();
        Assert.assertEquals((long)3L, (long)selectedRanges2.size());
    }

    @Test
    public void testTransformationDiagonalCross() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendColumn(gc3);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 2)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 2)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 2)));
        Assert.assertEquals((long)0L, (long)data.getSelectedCells().size());
        DefaultSelectionsTransformer transformer = new DefaultSelectionsTransformer((GridData)data, data.getColumns());
        List selectedRanges1 = transformer.transformToSelectedRanges();
        Assert.assertEquals((long)0L, (long)selectedRanges1.size());
        data.selectCell(0, 0);
        data.selectCell(0, 2);
        data.selectCell(1, 1);
        data.selectCell(2, 0);
        data.selectCell(2, 2);
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(0, 2)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 1)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(1, 2)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 0)));
        Assert.assertFalse((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 1)));
        Assert.assertTrue((boolean)data.getSelectedCells().contains(new GridData.SelectedCell(2, 2)));
        Assert.assertEquals((long)5L, (long)data.getSelectedCells().size());
        List selectedRanges2 = transformer.transformToSelectedRanges();
        Assert.assertEquals((long)5L, (long)selectedRanges2.size());
    }
}

