/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridTest;

public class GridGroupingTest
extends BaseGridTest {
    @Test
    public void testInitialSetup() {
        int rowIndex;
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        for (rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            GridRow row = data.getRow(rowIndex);
            Assert.assertFalse((boolean)row.isMerged());
            Assert.assertFalse((boolean)row.isCollapsed());
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                GridCell cell = data.getCell(rowIndex, columnIndex);
                Assert.assertFalse((boolean)cell.isMerged());
            }
        }
        Assert.assertEquals((long)3L, (long)data.getRowCount());
    }

    @Test
    public void testGroup() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(1, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 0)"));
        data.collapseCell(0, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false}, new boolean[]{false, true, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
        data.expandCell(0, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
    }

    @Test
    public void testGroupNotCombineWhenCellsValuesUpdatedAbove() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(3, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 2)"));
        data.collapseCell(2, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, true, true, false}, new boolean[]{false, false, false, true, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 2, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}, {BaseGridTest.Expected.build(true, 0, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
        data.setCell(1, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 2)"));
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, true, true, false}, new boolean[]{false, false, false, true, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 2, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}, {BaseGridTest.Expected.build(true, 0, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
        data.setCell(0, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 2)"));
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, false}, new boolean[]{false, false, false, true, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 2, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}, {BaseGridTest.Expected.build(true, 0, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
        data.expandCell(2, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 4, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}, {BaseGridTest.Expected.build(true, 0, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
    }

    @Test
    public void testGroupNotCombineWhenCellsValuesUpdatedBelow() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(2, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 1)"));
        data.collapseCell(1, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, false, false}, new boolean[]{false, false, true, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 2, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}, {BaseGridTest.Expected.build(false, 1, "(0, 3)"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
        data.setCell(3, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 1)"));
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, false, false}, new boolean[]{false, false, true, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 2, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
        data.setCell(4, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 1)"));
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, true}, new boolean[]{false, false, true, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 2, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}, {BaseGridTest.Expected.build(true, 2, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
        data.expandCell(1, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 4, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
    }

    @Test
    public void testGroupOverlap_CollapseBlockWithinParent() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(0, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(1, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(2, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(3, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(4, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(1, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(2, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(3, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.collapseCell(1, 1);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, false, true, true, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 5, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 3, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
        data.collapseCell(0, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, true, true, true, true}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 5, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 3, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
        data.expandCell(0, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, false, true, true, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 5, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 3, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
    }

    @Test
    public void testGroupOverlap_CollapseRightColumn_SingleCellOverlap_SplitBlock() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(2, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(3, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(4, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(0, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(1, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(2, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.collapseCell(0, 1);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, true, true, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(true, 3, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(false, 1, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(true, 2, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
        data.collapseCell(3, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, true, true, false, true}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(true, 3, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(false, 1, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(true, 2, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
        data.expandCell(3, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, true, true, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(true, 3, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(false, 1, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(true, 2, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
    }

    @Test
    public void testGroupOverlap_CollapseLeftColumn_SingleCellOverlap_SplitBlock() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(0, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(1, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(2, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(2, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(3, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(4, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.collapseCell(0, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, true, true, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 3)"), BaseGridTest.Expected.build(true, 2, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(true, 0, "g2")}});
        data.collapseCell(3, 1);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, true, true, false, true}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 3)"), BaseGridTest.Expected.build(true, 2, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(true, 0, "g2")}});
        data.expandCell(3, 1);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, true, true, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 3)"), BaseGridTest.Expected.build(true, 2, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(true, 0, "g2")}});
    }

    @Test
    public void testGroupOverlap_ChildBlockCoversTableExtents() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(0, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(1, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(0, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(1, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(2, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(3, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(4, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.collapseCell(0, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, true, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "g1"), BaseGridTest.Expected.build(true, 5, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 3)"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(true, 0, "g2")}});
        data.expandCell(0, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "g1"), BaseGridTest.Expected.build(true, 5, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 3)"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(true, 0, "g2")}});
    }

    @Test
    public void testGroupOverlap_CollapseLeftColumn_SingleCellOverlapMidTable_SplitBlock() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(1, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(2, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(2, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(3, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(4, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.collapseCell(1, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, true}, new boolean[]{false, false, true, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 2, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 3)"), BaseGridTest.Expected.build(true, 2, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(true, 0, "g2")}});
        data.expandCell(1, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 2, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 3, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 3)"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(true, 0, "g2")}});
    }

    @Test
    public void testGroupOverlap_CollapseLeftColumn_SubExtentOverlap_NoSplitBlock() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(1, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(2, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(1, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(2, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(3, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(4, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.collapseCell(1, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, true}, new boolean[]{false, false, true, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 2, "g1"), BaseGridTest.Expected.build(true, 4, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 3)"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(true, 0, "g2")}});
        data.expandCell(1, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 2, "g1"), BaseGridTest.Expected.build(true, 4, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 3)"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(true, 0, "g2")}});
    }

    @Test
    public void testGroupOverlap_CollapseLeftColumn_MultipleCellOverlap_SplitBlock() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(0, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(1, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(2, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(1, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(2, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(3, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(4, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.collapseCell(0, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, true, true, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 2, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 3)"), BaseGridTest.Expected.build(true, 2, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(true, 0, "g2")}});
        data.expandCell(0, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 4, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 3)"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(true, 0, "g2")}});
    }

    @Test
    public void testGroupOverlap_CollapseWholeTable() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            data.setCell(rowIndex, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
            data.setCell(rowIndex, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        }
        data.collapseCell(0, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, true, true, true, true}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 5, "g1"), BaseGridTest.Expected.build(true, 5, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}});
        data.expandCell(0, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 5, "g1"), BaseGridTest.Expected.build(true, 5, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}});
    }

    @Test
    public void testGroupOverlap_CollapseWholeTableExceptLastRow() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount() - 1; ++rowIndex) {
            data.setCell(rowIndex, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
            data.setCell(rowIndex, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        }
        data.setCell(4, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 4)"));
        data.setCell(4, 1, (GridCellValue)new BaseGridCellValue((Object)"(1, 4)"));
        data.collapseCell(0, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, false}, new boolean[]{false, true, true, true, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 4, "g1"), BaseGridTest.Expected.build(true, 4, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
        data.expandCell(0, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 4, "g1"), BaseGridTest.Expected.build(true, 4, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
    }

    @Test
    public void testGroupOverlap_CollapseLeftColumn_SingleCellOverlapBottom_SplitBlock() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(0, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(1, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(2, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(2, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(3, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(4, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.collapseCell(0, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, true, true, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 3)"), BaseGridTest.Expected.build(true, 2, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(true, 0, "g2")}});
        data.collapseCell(3, 1);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, true, true, false, true}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 3)"), BaseGridTest.Expected.build(true, 2, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(true, 0, "g2")}});
        data.expandCell(0, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, false, false, false, true}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 3)"), BaseGridTest.Expected.build(true, 2, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(true, 0, "g2")}});
        data.collapseCell(0, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, true, true, false, true}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 3)"), BaseGridTest.Expected.build(true, 2, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(true, 0, "g2")}});
        data.expandCell(0, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, false, false, false, true}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 3)"), BaseGridTest.Expected.build(true, 2, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(true, 0, "g2")}});
    }

    @Test
    public void testGroupOverlap_CollapseRightColumn_ChildSubExtent() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(0, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(1, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(2, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(0, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(1, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(2, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(3, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(4, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.collapseCell(0, 1);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, true, true, true, true}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "g1"), BaseGridTest.Expected.build(true, 5, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 3)"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(true, 0, "g2")}});
        data.expandCell(0, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, false, false, false, true}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "g1"), BaseGridTest.Expected.build(true, 3, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 3)"), BaseGridTest.Expected.build(true, 2, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(true, 0, "g2")}});
        data.expandCell(3, 1);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "g1"), BaseGridTest.Expected.build(true, 5, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 3)"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(true, 0, "g2")}});
    }

    @Test
    public void testGroupOverlap_CollapseLeftColumn_MultipleCellOverlapTableExtent_SplitBlock() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(0, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(1, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(2, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(0, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(1, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(2, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(3, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(4, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.collapseCell(0, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, true, true, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "g1"), BaseGridTest.Expected.build(true, 5, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 3)"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(true, 0, "g2")}});
        data.expandCell(0, 1);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "g1"), BaseGridTest.Expected.build(true, 5, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 3)"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(true, 0, "g2")}});
        data.collapseCell(0, 1);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, true, true, true, true}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "g1"), BaseGridTest.Expected.build(true, 5, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 3)"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(true, 0, "g2")}});
    }

    @Test
    public void testGroupOverlap_CollapseLeftColumn_SingleCellOverlapTop_SplitBlock() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(2, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(3, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(4, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(0, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(1, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(2, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.collapseCell(2, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, false, false, true, true}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(true, 2, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(true, 3, "g1"), BaseGridTest.Expected.build(false, 1, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
        data.collapseCell(0, 1);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, true, false, true, true}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(true, 2, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(true, 3, "g1"), BaseGridTest.Expected.build(false, 1, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
        data.expandCell(2, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, true, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(true, 2, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(true, 3, "g1"), BaseGridTest.Expected.build(false, 1, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
        data.expandCell(0, 1);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(true, 3, "g2")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(true, 3, "g1"), BaseGridTest.Expected.build(true, 0, "g2")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
    }

    @Test
    public void testGroupOverlap_CollapseRightColumn_SingleCellOverlapBottom_NestedSplitBlocks() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendColumn(gc3);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(2, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(3, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(2, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(3, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(4, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(0, 2, (GridCellValue)new BaseGridCellValue((Object)"g3"));
        data.setCell(1, 2, (GridCellValue)new BaseGridCellValue((Object)"g3"));
        data.setCell(2, 2, (GridCellValue)new BaseGridCellValue((Object)"g3"));
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(true, 3, "g3")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(true, 0, "g3")}, {BaseGridTest.Expected.build(true, 2, "g1"), BaseGridTest.Expected.build(true, 3, "g2"), BaseGridTest.Expected.build(true, 0, "g3")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(true, 0, "g2"), BaseGridTest.Expected.build(false, 1, "(2, 3)")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(true, 0, "g2"), BaseGridTest.Expected.build(false, 1, "(2, 4)")}});
        data.collapseCell(0, 2);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, true, true, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(true, 3, "g3")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(true, 0, "g3")}, {BaseGridTest.Expected.build(false, 1, "g1"), BaseGridTest.Expected.build(false, 1, "g2"), BaseGridTest.Expected.build(true, 0, "g3")}, {BaseGridTest.Expected.build(false, 1, "g1"), BaseGridTest.Expected.build(true, 2, "g2"), BaseGridTest.Expected.build(false, 1, "(2, 3)")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(true, 0, "g2"), BaseGridTest.Expected.build(false, 1, "(2, 4)")}});
        data.collapseCell(3, 1);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, true, true, false, true}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(true, 3, "g3")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(true, 0, "g3")}, {BaseGridTest.Expected.build(false, 1, "g1"), BaseGridTest.Expected.build(false, 1, "g2"), BaseGridTest.Expected.build(true, 0, "g3")}, {BaseGridTest.Expected.build(false, 1, "g1"), BaseGridTest.Expected.build(true, 2, "g2"), BaseGridTest.Expected.build(false, 1, "(2, 3)")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(true, 0, "g2"), BaseGridTest.Expected.build(false, 1, "(2, 4)")}});
    }

    @Test
    public void testGroupOverlap_CollapseLeftColumn_StaggeredSingleCellOverlapTop_NestedSplitBlocks() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendColumn(gc3);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(4, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(5, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(6, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(2, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(3, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(4, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(0, 2, (GridCellValue)new BaseGridCellValue((Object)"g3"));
        data.setCell(1, 2, (GridCellValue)new BaseGridCellValue((Object)"g3"));
        data.setCell(2, 2, (GridCellValue)new BaseGridCellValue((Object)"g3"));
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true, true, true}, new boolean[]{false, false, false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(true, 3, "g3")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(true, 0, "g3")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(true, 3, "g2"), BaseGridTest.Expected.build(true, 0, "g3")}, {BaseGridTest.Expected.build(false, 1, "(0, 3)"), BaseGridTest.Expected.build(true, 0, "g2"), BaseGridTest.Expected.build(false, 1, "(2, 3)")}, {BaseGridTest.Expected.build(true, 3, "g1"), BaseGridTest.Expected.build(true, 0, "g2"), BaseGridTest.Expected.build(false, 1, "(2, 4)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 5)"), BaseGridTest.Expected.build(false, 1, "(2, 5)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 6)"), BaseGridTest.Expected.build(false, 1, "(2, 6)")}});
        data.collapseCell(4, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true, true, true}, new boolean[]{false, false, false, false, false, true, true}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(true, 3, "g3")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(true, 0, "g3")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(true, 2, "g2"), BaseGridTest.Expected.build(true, 0, "g3")}, {BaseGridTest.Expected.build(false, 1, "(0, 3)"), BaseGridTest.Expected.build(true, 0, "g2"), BaseGridTest.Expected.build(false, 1, "(2, 3)")}, {BaseGridTest.Expected.build(true, 3, "g1"), BaseGridTest.Expected.build(false, 1, "g2"), BaseGridTest.Expected.build(false, 1, "(2, 4)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 5)"), BaseGridTest.Expected.build(false, 1, "(2, 5)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 6)"), BaseGridTest.Expected.build(false, 1, "(2, 6)")}});
        data.collapseCell(2, 1);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true, true, true}, new boolean[]{false, false, false, true, false, true, true}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(true, 2, "g3")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(true, 0, "g3")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(true, 2, "g2"), BaseGridTest.Expected.build(false, 1, "g3")}, {BaseGridTest.Expected.build(false, 1, "(0, 3)"), BaseGridTest.Expected.build(true, 0, "g2"), BaseGridTest.Expected.build(false, 1, "(2, 3)")}, {BaseGridTest.Expected.build(true, 3, "g1"), BaseGridTest.Expected.build(false, 1, "g2"), BaseGridTest.Expected.build(false, 1, "(2, 4)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 5)"), BaseGridTest.Expected.build(false, 1, "(2, 5)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 6)"), BaseGridTest.Expected.build(false, 1, "(2, 6)")}});
        data.collapseCell(0, 2);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true, true, true}, new boolean[]{false, true, false, true, false, true, true}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(true, 2, "g3")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(true, 0, "g3")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(true, 2, "g2"), BaseGridTest.Expected.build(false, 1, "g3")}, {BaseGridTest.Expected.build(false, 1, "(0, 3)"), BaseGridTest.Expected.build(true, 0, "g2"), BaseGridTest.Expected.build(false, 1, "(2, 3)")}, {BaseGridTest.Expected.build(true, 3, "g1"), BaseGridTest.Expected.build(false, 1, "g2"), BaseGridTest.Expected.build(false, 1, "(2, 4)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 5)"), BaseGridTest.Expected.build(false, 1, "(2, 5)")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 6)"), BaseGridTest.Expected.build(false, 1, "(2, 6)")}});
    }

    @Test
    public void testGroupOverlap_CollapseLeftColumn_MultipleCellOverlap_NestedSplitBlocks() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        BaseGridTest.MockMergableGridColumn gc3 = new BaseGridTest.MockMergableGridColumn("col3", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendColumn(gc3);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(1, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(2, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(3, 0, (GridCellValue)new BaseGridCellValue((Object)"g1"));
        data.setCell(0, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(1, 1, (GridCellValue)new BaseGridCellValue((Object)"g2"));
        data.setCell(0, 2, (GridCellValue)new BaseGridCellValue((Object)"g3"));
        data.setCell(1, 2, (GridCellValue)new BaseGridCellValue((Object)"g3"));
        data.setCell(2, 2, (GridCellValue)new BaseGridCellValue((Object)"g3"));
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(true, 2, "g2"), BaseGridTest.Expected.build(true, 3, "g3")}, {BaseGridTest.Expected.build(true, 3, "g1"), BaseGridTest.Expected.build(true, 0, "g2"), BaseGridTest.Expected.build(true, 0, "g3")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 2)"), BaseGridTest.Expected.build(true, 0, "g3")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 3)"), BaseGridTest.Expected.build(false, 1, "(2, 3)")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(false, 1, "(1, 4)"), BaseGridTest.Expected.build(false, 1, "(2, 4)")}});
        data.collapseCell(0, 1);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, false}, new boolean[]{false, true, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(true, 2, "g2"), BaseGridTest.Expected.build(true, 3, "g3")}, {BaseGridTest.Expected.build(false, 1, "g1"), BaseGridTest.Expected.build(true, 0, "g2"), BaseGridTest.Expected.build(true, 0, "g3")}, {BaseGridTest.Expected.build(true, 2, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 2)"), BaseGridTest.Expected.build(true, 0, "g3")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 3)"), BaseGridTest.Expected.build(false, 1, "(2, 3)")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(false, 1, "(1, 4)"), BaseGridTest.Expected.build(false, 1, "(2, 4)")}});
        data.collapseCell(2, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, false}, new boolean[]{false, true, false, true, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(true, 2, "g2"), BaseGridTest.Expected.build(true, 2, "g3")}, {BaseGridTest.Expected.build(false, 1, "g1"), BaseGridTest.Expected.build(true, 0, "g2"), BaseGridTest.Expected.build(true, 0, "g3")}, {BaseGridTest.Expected.build(true, 2, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 2)"), BaseGridTest.Expected.build(false, 1, "g3")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 3)"), BaseGridTest.Expected.build(false, 1, "(2, 3)")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(false, 1, "(1, 4)"), BaseGridTest.Expected.build(false, 1, "(2, 4)")}});
        data.expandCell(2, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, false}, new boolean[]{false, true, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(true, 2, "g2"), BaseGridTest.Expected.build(true, 2, "g3")}, {BaseGridTest.Expected.build(false, 1, "g1"), BaseGridTest.Expected.build(true, 0, "g2"), BaseGridTest.Expected.build(true, 0, "g3")}, {BaseGridTest.Expected.build(true, 2, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 2)"), BaseGridTest.Expected.build(false, 1, "g3")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 3)"), BaseGridTest.Expected.build(false, 1, "(2, 3)")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(false, 1, "(1, 4)"), BaseGridTest.Expected.build(false, 1, "(2, 4)")}});
        data.collapseCell(2, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, false}, new boolean[]{false, true, false, true, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(true, 2, "g2"), BaseGridTest.Expected.build(true, 2, "g3")}, {BaseGridTest.Expected.build(false, 1, "g1"), BaseGridTest.Expected.build(true, 0, "g2"), BaseGridTest.Expected.build(true, 0, "g3")}, {BaseGridTest.Expected.build(true, 2, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 2)"), BaseGridTest.Expected.build(false, 1, "g3")}, {BaseGridTest.Expected.build(true, 0, "g1"), BaseGridTest.Expected.build(false, 1, "(1, 3)"), BaseGridTest.Expected.build(false, 1, "(2, 3)")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(false, 1, "(1, 4)"), BaseGridTest.Expected.build(false, 1, "(2, 4)")}});
    }

    @Test
    public void testGroupUpdateCellValue() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(1, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 0)"));
        data.collapseCell(0, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false}, new boolean[]{false, true, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
        data.setCell(0, 0, (GridCellValue)new BaseGridCellValue((Object)"<changed>"));
        data.expandCell(0, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "<changed>"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "<changed>"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
    }

    @Test
    public void testGroupMovedColumnUpdateCellValue() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(1, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 0)"));
        data.collapseCell(0, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false}, new boolean[]{false, true, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
        data.moveColumnTo(1, gc1);
        data.setCell(0, 1, (GridCellValue)new BaseGridCellValue((Object)"<changed>"));
        data.expandCell(0, 1);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(true, 2, "<changed>")}, {BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(true, 0, "<changed>")}, {BaseGridTest.Expected.build(false, 1, "(1, 2)"), BaseGridTest.Expected.build(false, 1, "(0, 2)")}});
    }

    @Test
    public void testMergedDeleteCellValue() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(1, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 0)"));
        data.collapseCell(0, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false}, new boolean[]{false, true, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
        data.deleteCell(0, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(null), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(null), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
    }

    @Test
    public void testRemoveRowIndex0FromGroupedBlock() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(2, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 1)"));
        data.setCell(3, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 1)"));
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 3, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
        data.collapseCell(1, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, false}, new boolean[]{false, false, true, true, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 3, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
        GridData.Range rows = data.deleteRow(0);
        Assert.assertEquals((long)0L, (long)rows.getMinRowIndex());
        Assert.assertEquals((long)0L, (long)rows.getMaxRowIndex());
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, false}, new boolean[]{false, true, true, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
    }

    @Test
    public void testRemoveRowIndex1FromGroupedBlock() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(2, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 1)"));
        data.setCell(3, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 1)"));
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 3, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
        data.collapseCell(1, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, false}, new boolean[]{false, false, true, true, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 3, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
        GridData.Range rows = data.deleteRow(1);
        Assert.assertEquals((long)1L, (long)rows.getMinRowIndex());
        Assert.assertEquals((long)3L, (long)rows.getMaxRowIndex());
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
    }

    @Test
    public void testRemoveRowIndex2FromGroupedBlock() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(2, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 1)"));
        data.setCell(3, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 1)"));
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 3, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
        data.collapseCell(1, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, false}, new boolean[]{false, false, true, true, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 3, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
        GridData.Range rows = data.deleteRow(2);
        Assert.assertEquals((long)1L, (long)rows.getMinRowIndex());
        Assert.assertEquals((long)3L, (long)rows.getMaxRowIndex());
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
    }

    @Test
    public void testRemoveRowIndex3FromGroupedBlock() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(2, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 1)"));
        data.setCell(3, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 1)"));
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 3, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
        data.collapseCell(1, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, false}, new boolean[]{false, false, true, true, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 3, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
        GridData.Range rows = data.deleteRow(3);
        Assert.assertEquals((long)1L, (long)rows.getMinRowIndex());
        Assert.assertEquals((long)3L, (long)rows.getMaxRowIndex());
        this.assertGridIndexes((GridData)data, new boolean[]{false, false}, new boolean[]{false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
    }

    @Test
    public void testRemoveRowIndex4FromGroupedBlock() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(2, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 1)"));
        data.setCell(3, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 1)"));
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 3, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
        data.collapseCell(1, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, false}, new boolean[]{false, false, true, true, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 3, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
        GridData.Range rows = data.deleteRow(4);
        Assert.assertEquals((long)4L, (long)rows.getMinRowIndex());
        Assert.assertEquals((long)4L, (long)rows.getMaxRowIndex());
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true}, new boolean[]{false, false, true, true}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 3, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}});
    }

    @Test
    public void testRemoveOnlyRow() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false}, new boolean[]{false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}});
        GridData.Range rows = data.deleteRow(0);
        Assert.assertEquals((long)0L, (long)rows.getMinRowIndex());
        Assert.assertEquals((long)0L, (long)rows.getMaxRowIndex());
        Assert.assertEquals((long)0L, (long)data.getRowCount());
    }

    @Test
    public void testRemoveAllRows() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(1, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 0)"));
        data.setCell(2, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 0)"));
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
        data.collapseCell(0, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true}, new boolean[]{false, true, true}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
        GridData.Range rows = data.deleteRow(1);
        Assert.assertEquals((long)0L, (long)rows.getMinRowIndex());
        Assert.assertEquals((long)2L, (long)rows.getMaxRowIndex());
        Assert.assertEquals((long)0L, (long)data.getRowCount());
    }

    @Test
    public void testGrouped_MoveUp_Rowsx3ToIndex0_Blockx3Rows() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? (rowIndex == 0 || rowIndex == 4 ? "b" : "a") : Integer.toString(rowIndex);
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 3, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "4")}});
        data.collapseCell(1, 0);
        data.moveRowsTo(0, (List)new ArrayList<GridRow>((GridRow)row1, (GridRow)row2, (GridRow)row3){
            final /* synthetic */ GridRow val$row1;
            final /* synthetic */ GridRow val$row2;
            final /* synthetic */ GridRow val$row3;
            {
                this.val$row1 = gridRow;
                this.val$row2 = gridRow2;
                this.val$row3 = gridRow3;
                this.add(this.val$row1);
                this.add(this.val$row2);
                this.add(this.val$row3);
            }
        });
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, true, true, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(true, 2, "b"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "b"), BaseGridTest.Expected.build(false, 1, "4")}});
    }

    @Test
    public void testGrouped_MoveUp_Rowsx2ToIndex1_Blockx2Rows() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? (rowIndex == 1 || rowIndex == 4 ? "b" : "a") : Integer.toString(rowIndex);
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, true, true, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 2, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "4")}});
        data.collapseCell(2, 0);
        data.moveRowsTo(1, (List)new ArrayList<GridRow>((GridRow)row2, (GridRow)row3){
            final /* synthetic */ GridRow val$row2;
            final /* synthetic */ GridRow val$row3;
            {
                this.val$row2 = gridRow;
                this.val$row3 = gridRow2;
                this.add(this.val$row2);
                this.add(this.val$row3);
            }
        });
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, true}, new boolean[]{false, false, true, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 2, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(true, 2, "b"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "b"), BaseGridTest.Expected.build(false, 1, "4")}});
    }

    @Test
    public void testGrouped_MoveUp_Rowsx2ToIndex0_Blockx2Rows() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        BaseGridRow row5 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        data.appendRow((GridRow)row5);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? (rowIndex == 1 || rowIndex == 4 ? "a" : "b") : "c";
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true, true}, new boolean[]{false, false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(true, 6, "c")}, {BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(true, 0, "c")}, {BaseGridTest.Expected.build(true, 2, "b"), BaseGridTest.Expected.build(true, 0, "c")}, {BaseGridTest.Expected.build(true, 0, "b"), BaseGridTest.Expected.build(true, 0, "c")}, {BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(true, 0, "c")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(true, 0, "c")}});
        data.collapseCell(2, 0);
        data.moveRowsTo(0, (List)new ArrayList<GridRow>((GridRow)row2, (GridRow)row3){
            final /* synthetic */ GridRow val$row2;
            final /* synthetic */ GridRow val$row3;
            {
                this.val$row2 = gridRow;
                this.val$row3 = gridRow2;
                this.add(this.val$row2);
                this.add(this.val$row3);
            }
        });
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true, true}, new boolean[]{false, true, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "b"), BaseGridTest.Expected.build(true, 2, "c")}, {BaseGridTest.Expected.build(true, 0, "b"), BaseGridTest.Expected.build(true, 0, "c")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(true, 4, "c")}, {BaseGridTest.Expected.build(true, 2, "a"), BaseGridTest.Expected.build(true, 0, "c")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(true, 0, "c")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(true, 0, "c")}});
    }

    @Test
    public void testGrouped_MoveUp_Rowsx2ToIndex0_Blockx2Rows_MakeNewSplitBlock() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        BaseGridRow row5 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        data.appendRow((GridRow)row5);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? (rowIndex == 1 || rowIndex == 4 ? "a" : "b") : (rowIndex == 0 ? "d" : "c");
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, true, true}, new boolean[]{false, false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "d")}, {BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(true, 5, "c")}, {BaseGridTest.Expected.build(true, 2, "b"), BaseGridTest.Expected.build(true, 0, "c")}, {BaseGridTest.Expected.build(true, 0, "b"), BaseGridTest.Expected.build(true, 0, "c")}, {BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(true, 0, "c")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(true, 0, "c")}});
        data.collapseCell(2, 0);
        data.moveRowsTo(0, (List)new ArrayList<GridRow>((GridRow)row2, (GridRow)row3){
            final /* synthetic */ GridRow val$row2;
            final /* synthetic */ GridRow val$row3;
            {
                this.val$row2 = gridRow;
                this.val$row3 = gridRow2;
                this.add(this.val$row2);
                this.add(this.val$row3);
            }
        });
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false, true, true, true}, new boolean[]{false, true, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "b"), BaseGridTest.Expected.build(true, 2, "c")}, {BaseGridTest.Expected.build(true, 0, "b"), BaseGridTest.Expected.build(true, 0, "c")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "d")}, {BaseGridTest.Expected.build(true, 2, "a"), BaseGridTest.Expected.build(true, 3, "c")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(true, 0, "c")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(true, 0, "c")}});
    }

    @Test
    public void testGrouped_MoveUp_Rowsx2ToIndex0_Blockx2Rows_MakeNewMergedBlock() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        BaseGridRow row5 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        data.appendRow((GridRow)row5);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? (rowIndex == 1 || rowIndex == 4 ? "a" : "b") : (rowIndex == 0 || rowIndex == 3 ? "d" : "c");
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, true, true}, new boolean[]{false, false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "d")}, {BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(true, 2, "c")}, {BaseGridTest.Expected.build(true, 2, "b"), BaseGridTest.Expected.build(true, 0, "c")}, {BaseGridTest.Expected.build(true, 0, "b"), BaseGridTest.Expected.build(false, 1, "d")}, {BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(true, 2, "c")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(true, 0, "c")}});
        data.collapseCell(2, 0);
        data.moveRowsTo(0, (List)new ArrayList<GridRow>((GridRow)row2, (GridRow)row3){
            final /* synthetic */ GridRow val$row2;
            final /* synthetic */ GridRow val$row3;
            {
                this.val$row2 = gridRow;
                this.val$row3 = gridRow2;
                this.add(this.val$row2);
                this.add(this.val$row3);
            }
        });
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false, true, true, true}, new boolean[]{false, true, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "b"), BaseGridTest.Expected.build(false, 1, "c")}, {BaseGridTest.Expected.build(true, 0, "b"), BaseGridTest.Expected.build(false, 1, "d")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "d")}, {BaseGridTest.Expected.build(true, 2, "a"), BaseGridTest.Expected.build(true, 3, "c")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(true, 0, "c")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(true, 0, "c")}});
    }

    @Test
    public void testGrouped_MoveDown_Rowsx3ToIndex4_Blockx3Rows_NewMergedBlock() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? (rowIndex == 0 || rowIndex == 4 ? "b" : "a") : Integer.toString(rowIndex);
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 3, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "4")}});
        data.collapseCell(1, 0);
        data.moveRowsTo(4, (List)new ArrayList<GridRow>((GridRow)row1, (GridRow)row2, (GridRow)row3){
            final /* synthetic */ GridRow val$row1;
            final /* synthetic */ GridRow val$row2;
            final /* synthetic */ GridRow val$row3;
            {
                this.val$row1 = gridRow;
                this.val$row2 = gridRow2;
                this.val$row3 = gridRow3;
                this.add(this.val$row1);
                this.add(this.val$row2);
                this.add(this.val$row3);
            }
        });
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, false, false, true, true}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "b"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "b"), BaseGridTest.Expected.build(false, 1, "4")}, {BaseGridTest.Expected.build(true, 3, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}});
    }

    @Test
    public void testGrouped_MoveDown_Rowsx2ToIndex4_Blockx2Rows_NewMergedGroup() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? (rowIndex == 1 || rowIndex == 2 || rowIndex == 4 ? "b" : "a") : Integer.toString(rowIndex);
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, false, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 2, "b"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "b"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "4")}});
        data.collapseCell(1, 0);
        data.moveRowsTo(4, (List)new ArrayList<GridRow>((GridRow)row1, (GridRow)row2){
            final /* synthetic */ GridRow val$row1;
            final /* synthetic */ GridRow val$row2;
            {
                this.val$row1 = gridRow;
                this.val$row2 = gridRow2;
                this.add(this.val$row1);
                this.add(this.val$row2);
            }
        });
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false, true, true}, new boolean[]{false, false, false, false, true}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "4")}, {BaseGridTest.Expected.build(true, 2, "b"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "b"), BaseGridTest.Expected.build(false, 1, "2")}});
    }
}

