/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.model.impl;

import org.junit.Assert;
import org.junit.Test;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridTest;

public class GridMergingTest
extends BaseGridTest {
    @Test
    public void testInitialSetup_NoMerging() {
        int columnIndex;
        int rowIndex;
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        for (rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            Assert.assertFalse((boolean)data.getRow(rowIndex).isMerged());
            for (columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                GridCell cell = data.getCell(rowIndex, columnIndex);
                Assert.assertFalse((boolean)cell.isMerged());
                Assert.assertEquals((long)1L, (long)cell.getMergedCellCount());
            }
        }
    }

    @Test
    public void testInitialSetup_Column1Merged() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + (columnIndex == 0 ? "X" : Integer.valueOf(rowIndex)) + ")")));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "(0, X)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "(0, X)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "(0, X)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
    }

    @Test
    public void testMergeDownwards_SplitBlock_Rowsx2Rowx1() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(1, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 0)"));
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
    }

    @Test
    public void testMergeDownwards_SplitBlock_Rowsx1Rowx2() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(2, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 1)"));
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 2, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
    }

    @Test
    public void testMergeDownwards_TableExtents() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(1, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 0)"));
        data.setCell(2, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 0)"));
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
    }

    @Test
    public void testMergeUpwards_SplitBlock_Rowsx2Rowsx1() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(0, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 1)"));
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
    }

    @Test
    public void testMergeUpwards_SplitBlock_Rowsx1Rowsx2() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(1, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 2)"));
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 2, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
    }

    @Test
    public void testMergeUpwards_TableExtents() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(1, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 2)"));
        data.setCell(0, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 2)"));
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
    }

    @Test
    public void testMergeNonSequential() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(0, 0, (GridCellValue)new BaseGridCellValue((Object)"(a, b)"));
        data.setCell(2, 0, (GridCellValue)new BaseGridCellValue((Object)"(a, b)"));
        data.setCell(1, 0, (GridCellValue)new BaseGridCellValue((Object)"(a, b)"));
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "(a, b)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "(a, b)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "(a, b)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
    }

    @Test
    public void testMergedUpdateCellValue() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(1, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 0)"));
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
        data.setCell(0, 0, (GridCellValue)new BaseGridCellValue((Object)"<changed>"));
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "<changed>"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "<changed>"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
    }

    @Test
    public void testMerged_MovedColumnRight_UpdateCellInMergedCell() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(1, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 0)"));
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
        data.moveColumnTo(1, gc1);
        data.setCell(0, 1, (GridCellValue)new BaseGridCellValue((Object)"<changed>"));
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(true, 2, "<changed>")}, {BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(true, 0, "<changed>")}, {BaseGridTest.Expected.build(false, 1, "(1, 2)"), BaseGridTest.Expected.build(false, 1, "(0, 2)")}});
    }

    @Test
    public void testMerged_MovedColumnRight_UpdateCellInMergedCell_CheckMergeToggle() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(1, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 0)"));
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
        data.moveColumnTo(1, gc1);
        data.setCell(0, 1, (GridCellValue)new BaseGridCellValue((Object)"<changed>"));
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(true, 2, "<changed>")}, {BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(true, 0, "<changed>")}, {BaseGridTest.Expected.build(false, 1, "(1, 2)"), BaseGridTest.Expected.build(false, 1, "(0, 2)")}});
        data.setMerged(false);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(false, 1, "<changed>")}, {BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(false, 1, "<changed>")}, {BaseGridTest.Expected.build(false, 1, "(1, 2)"), BaseGridTest.Expected.build(false, 1, "(0, 2)")}});
        data.setMerged(true);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(1, 0)"), BaseGridTest.Expected.build(true, 2, "<changed>")}, {BaseGridTest.Expected.build(false, 1, "(1, 1)"), BaseGridTest.Expected.build(true, 0, "<changed>")}, {BaseGridTest.Expected.build(false, 1, "(1, 2)"), BaseGridTest.Expected.build(false, 1, "(0, 2)")}});
    }

    @Test
    public void testFullIndexing_TableExtents() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(1, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 0)"));
        data.setCell(2, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 0)"));
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
        data.setMerged(false);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
        data.setMerged(true);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
    }

    @Test
    public void testFullIndexing_TableTopExtent() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(1, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 0)"));
        data.setCell(2, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 0)"));
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, false, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}, {BaseGridTest.Expected.build(false, 1, "(0, 3)"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
        data.setMerged(false);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false, false, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}, {BaseGridTest.Expected.build(false, 1, "(0, 3)"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
        data.setMerged(true);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, false, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 0, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}, {BaseGridTest.Expected.build(false, 1, "(0, 3)"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}, {BaseGridTest.Expected.build(false, 1, "(0, 4)"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
    }

    @Test
    public void testFullIndexing_TableBottomExtent() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(3, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 2)"));
        data.setCell(4, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 2)"));
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 3, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}, {BaseGridTest.Expected.build(true, 0, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}, {BaseGridTest.Expected.build(true, 0, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
        data.setMerged(false);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false, false, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
        data.setMerged(true);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(true, 3, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}, {BaseGridTest.Expected.build(true, 0, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 3)")}, {BaseGridTest.Expected.build(true, 0, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 4)")}});
    }

    @Test
    public void testMergeString_TableExtents() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)"a"));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true}, new boolean[]{false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 4, "a")}, {BaseGridTest.Expected.build(true, 0, "a")}, {BaseGridTest.Expected.build(true, 0, "a")}, {BaseGridTest.Expected.build(true, 0, "a")}});
    }

    @Test
    public void testMergeString_SplitBlockx2() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)(rowIndex == 0 ? "b" : "a")));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true}, new boolean[]{false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "b")}, {BaseGridTest.Expected.build(true, 3, "a")}, {BaseGridTest.Expected.build(true, 0, "a")}, {BaseGridTest.Expected.build(true, 0, "a")}});
    }

    @Test
    public void testMergeString_SplitBlockx3() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = rowIndex == 0 || rowIndex == 3 || rowIndex == 4 ? "a" : "b";
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(true, 2, "b")}, {BaseGridTest.Expected.build(true, 0, "b")}, {BaseGridTest.Expected.build(true, 2, "a")}, {BaseGridTest.Expected.build(true, 0, "a")}});
        data.setMerged(false);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false, false, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, "b")}, {BaseGridTest.Expected.build(false, 1, "b")}, {BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, "a")}});
        data.setMerged(true);
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(true, 2, "b")}, {BaseGridTest.Expected.build(true, 0, "b")}, {BaseGridTest.Expected.build(true, 2, "a")}, {BaseGridTest.Expected.build(true, 0, "a")}});
    }

    @Test
    public void testMergeBoolean_TableExtents() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)false));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true}, new boolean[]{false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 4, false)}, {BaseGridTest.Expected.build(true, 0, false)}, {BaseGridTest.Expected.build(true, 0, false)}, {BaseGridTest.Expected.build(true, 0, false)}});
    }

    @Test
    public void testMergeBoolean_SplitBlockx2() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)(rowIndex == 0 ? 1 : 0)));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true}, new boolean[]{false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, true)}, {BaseGridTest.Expected.build(true, 3, false)}, {BaseGridTest.Expected.build(true, 0, false)}, {BaseGridTest.Expected.build(true, 0, false)}});
    }

    @Test
    public void testMergeBoolean_SplitBlockx3() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                boolean value = rowIndex == 0 || rowIndex == 3 || rowIndex == 4;
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, true)}, {BaseGridTest.Expected.build(true, 2, false)}, {BaseGridTest.Expected.build(true, 0, false)}, {BaseGridTest.Expected.build(true, 2, true)}, {BaseGridTest.Expected.build(true, 0, true)}});
        data.setMerged(false);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false, false, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, true)}, {BaseGridTest.Expected.build(false, 1, false)}, {BaseGridTest.Expected.build(false, 1, false)}, {BaseGridTest.Expected.build(false, 1, true)}, {BaseGridTest.Expected.build(false, 1, true)}});
        data.setMerged(true);
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, true)}, {BaseGridTest.Expected.build(true, 2, false)}, {BaseGridTest.Expected.build(true, 0, false)}, {BaseGridTest.Expected.build(true, 2, true)}, {BaseGridTest.Expected.build(true, 0, true)}});
    }

    @Test
    public void testMerged_DeleteCell_MergedCell() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        data.setCell(1, 0, (GridCellValue)new BaseGridCellValue((Object)"(0, 0)"));
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(true, 0, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
        data.deleteCell(0, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(null), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(null), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
    }

    @Test
    public void testMerged_DeleteCell_UnmergedCell() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col2", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)("(" + columnIndex + ", " + rowIndex + ")")));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "(0, 0)"), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
        data.deleteCell(0, 0);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(null), BaseGridTest.Expected.build(false, 1, "(1, 0)")}, {BaseGridTest.Expected.build(false, 1, "(0, 1)"), BaseGridTest.Expected.build(false, 1, "(1, 1)")}, {BaseGridTest.Expected.build(false, 1, "(0, 2)"), BaseGridTest.Expected.build(false, 1, "(1, 2)")}});
    }
}

