/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.model.impl;

import org.junit.Test;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridTest;

public class GridRowsMergedTest
extends BaseGridTest {
    @Test
    public void testRemoveRow() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = rowIndex > 0 && rowIndex < 4 ? "b" : "a";
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(true, 3, "b")}, {BaseGridTest.Expected.build(true, 0, "b")}, {BaseGridTest.Expected.build(true, 0, "b")}, {BaseGridTest.Expected.build(false, 1, "a")}});
        data.deleteRow(2);
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, false}, new boolean[]{false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(true, 2, "b")}, {BaseGridTest.Expected.build(true, 0, "b")}, {BaseGridTest.Expected.build(false, 1, "a")}});
    }

    @Test
    public void testAppendRow() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = rowIndex < 2 ? "a" : "b";
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true}, new boolean[]{false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "a")}, {BaseGridTest.Expected.build(true, 0, "a")}, {BaseGridTest.Expected.build(true, 2, "b")}, {BaseGridTest.Expected.build(true, 0, "b")}});
        data.appendRow((GridRow)new BaseGridRow());
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "a")}, {BaseGridTest.Expected.build(true, 0, "a")}, {BaseGridTest.Expected.build(true, 2, "b")}, {BaseGridTest.Expected.build(true, 0, "b")}, {BaseGridTest.Expected.build(false, 1, null)}});
    }

    @Test
    public void testInsertRowAtZeroIndex() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = rowIndex < 2 ? "a" : "b";
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true}, new boolean[]{false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "a")}, {BaseGridTest.Expected.build(true, 0, "a")}, {BaseGridTest.Expected.build(true, 2, "b")}, {BaseGridTest.Expected.build(true, 0, "b")}});
        data.insertRow(0, (GridRow)new BaseGridRow());
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, null)}, {BaseGridTest.Expected.build(true, 2, "a")}, {BaseGridTest.Expected.build(true, 0, "a")}, {BaseGridTest.Expected.build(true, 2, "b")}, {BaseGridTest.Expected.build(true, 0, "b")}});
    }

    @Test
    public void testInsertRowAtStartEndBlock() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = rowIndex < 2 ? "a" : "b";
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true}, new boolean[]{false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "a")}, {BaseGridTest.Expected.build(true, 0, "a")}, {BaseGridTest.Expected.build(true, 2, "b")}, {BaseGridTest.Expected.build(true, 0, "b")}});
        data.insertRow(2, (GridRow)new BaseGridRow());
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "a")}, {BaseGridTest.Expected.build(true, 0, "a")}, {BaseGridTest.Expected.build(false, 1, null)}, {BaseGridTest.Expected.build(true, 2, "b")}, {BaseGridTest.Expected.build(true, 0, "b")}});
    }

    @Test
    public void testInsertRowAtMidBlock() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)"a"));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true}, new boolean[]{false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 4, "a")}, {BaseGridTest.Expected.build(true, 0, "a")}, {BaseGridTest.Expected.build(true, 0, "a")}, {BaseGridTest.Expected.build(true, 0, "a")}});
        data.insertRow(2, (GridRow)new BaseGridRow());
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "a")}, {BaseGridTest.Expected.build(true, 0, "a")}, {BaseGridTest.Expected.build(false, 1, null)}, {BaseGridTest.Expected.build(true, 2, "a")}, {BaseGridTest.Expected.build(true, 0, "a")}});
    }

    @Test
    public void testDeleteRowAtZeroIndex() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = rowIndex < 2 ? "a" : "b";
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true}, new boolean[]{false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "a")}, {BaseGridTest.Expected.build(true, 0, "a")}, {BaseGridTest.Expected.build(true, 2, "b")}, {BaseGridTest.Expected.build(true, 0, "b")}});
        data.deleteRow(0);
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(true, 2, "b")}, {BaseGridTest.Expected.build(true, 0, "b")}});
    }

    @Test
    public void testDeleteRowAtStartEndBlock() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = rowIndex < 2 ? "a" : "b";
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true}, new boolean[]{false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "a")}, {BaseGridTest.Expected.build(true, 0, "a")}, {BaseGridTest.Expected.build(true, 2, "b")}, {BaseGridTest.Expected.build(true, 0, "b")}});
        data.deleteRow(2);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "a")}, {BaseGridTest.Expected.build(true, 0, "a")}, {BaseGridTest.Expected.build(false, 1, "b")}});
    }

    @Test
    public void testDeleteRowAtMidBlock() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)"a"));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true}, new boolean[]{false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 4, "a")}, {BaseGridTest.Expected.build(true, 0, "a")}, {BaseGridTest.Expected.build(true, 0, "a")}, {BaseGridTest.Expected.build(true, 0, "a")}});
        data.deleteRow(2);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "a")}, {BaseGridTest.Expected.build(true, 0, "a")}, {BaseGridTest.Expected.build(true, 0, "a")}});
    }

    @Test
    public void testMergedBlock_MoveRowUp_Index4to3() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? (rowIndex == 4 ? "b" : "a") : Integer.toString(rowIndex);
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 4, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "4")}});
        data.moveRowTo(3, (GridRow)row4);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, false, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "4")}, {BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(false, 1, "3")}});
    }

    @Test
    public void testMergedBlock_MoveRowUp_Index3to2() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? (rowIndex == 3 ? "b" : "a") : Integer.toString(rowIndex);
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, false, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(false, 1, "4")}});
        data.moveRowTo(2, (GridRow)row3);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(true, 2, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "4")}});
    }

    @Test
    public void testMergedBlock_MoveRowUp_Index2to1() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? (rowIndex == 2 ? "b" : "a") : Integer.toString(rowIndex);
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 2, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "4")}});
        data.moveRowTo(1, (GridRow)row2);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 3, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "4")}});
    }

    @Test
    public void testMergedBlock_MoveRowUp_Index1to0() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? (rowIndex == 1 ? "b" : "a") : Integer.toString(rowIndex);
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 3, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "4")}});
        data.moveRowTo(0, (GridRow)row1);
        this.assertGridIndexes((GridData)data, new boolean[]{false, true, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 4, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "4")}});
    }

    @Test
    public void testMergedBlock_MoveRowUp_Index2to1_NewMergedBlock() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? (rowIndex == 1 ? "b" : "a") : (rowIndex < 2 ? "a" : "b");
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(true, 2, "a")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(true, 0, "a")}, {BaseGridTest.Expected.build(true, 3, "a"), BaseGridTest.Expected.build(true, 3, "b")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(true, 0, "b")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(true, 0, "b")}});
        data.moveRowTo(1, (GridRow)row2);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "a"), BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "b")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(true, 2, "a"), BaseGridTest.Expected.build(true, 2, "b")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(true, 0, "b")}});
    }

    @Test
    public void testMergedBlock_MoveRowUp_Index3to2_NewMergedBlock() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? (rowIndex == 1 ? "b" : "a") : (rowIndex == 2 ? "a" : "b");
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(true, 2, "b")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(true, 0, "b")}, {BaseGridTest.Expected.build(true, 3, "a"), BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(true, 2, "b")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(true, 0, "b")}});
        data.moveRowTo(2, (GridRow)row3);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(true, 3, "b")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(true, 0, "b")}, {BaseGridTest.Expected.build(true, 3, "a"), BaseGridTest.Expected.build(true, 0, "b")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "b")}});
    }

    @Test
    public void testMergedBlock_MoveRowDown_Index0to1() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? (rowIndex == 4 ? "b" : "a") : Integer.toString(rowIndex);
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 4, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "4")}});
        data.moveRowTo(1, (GridRow)row0);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 4, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "4")}});
    }

    @Test
    public void testMergedBlock_MoveRowDown_Index1to2() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? (rowIndex == 3 ? "b" : "a") : Integer.toString(rowIndex);
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, false, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(false, 1, "4")}});
        data.moveRowTo(2, (GridRow)row1);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, false, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(false, 1, "4")}});
    }

    @Test
    public void testMergedBlock_MoveRowDown_Index2to3() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? (rowIndex == 2 ? "b" : "a") : Integer.toString(rowIndex);
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 2, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "4")}});
        data.moveRowTo(3, (GridRow)row2);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, false, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 3, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(false, 1, "4")}});
    }

    @Test
    public void testMergedBlock_MoveRowDown_Index3to4() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? (rowIndex == 1 ? "b" : "a") : Integer.toString(rowIndex);
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 3, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "4")}});
        data.moveRowTo(4, (GridRow)row3);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(false, 1, "0")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "1")}, {BaseGridTest.Expected.build(true, 3, "a"), BaseGridTest.Expected.build(false, 1, "2")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "4")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "3")}});
    }

    @Test
    public void testMergedBlock_MoveRowDown_Index1to2_NewMergedBlock() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? (rowIndex == 1 ? "b" : "a") : (rowIndex < 2 ? "a" : "b");
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(true, 2, "a")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(true, 0, "a")}, {BaseGridTest.Expected.build(true, 3, "a"), BaseGridTest.Expected.build(true, 3, "b")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(true, 0, "b")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(true, 0, "b")}});
        data.moveRowTo(2, (GridRow)row1);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, false, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(true, 2, "a"), BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "b")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(true, 2, "a"), BaseGridTest.Expected.build(true, 2, "b")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(true, 0, "b")}});
    }

    @Test
    public void testMergedBlock_MoveRowDown_Index2to3_NewMergedBlock() {
        BaseGridData data = new BaseGridData();
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        BaseGridTest.MockMergableGridColumn gc2 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendColumn(gc2);
        BaseGridRow row0 = new BaseGridRow();
        BaseGridRow row1 = new BaseGridRow();
        BaseGridRow row2 = new BaseGridRow();
        BaseGridRow row3 = new BaseGridRow();
        BaseGridRow row4 = new BaseGridRow();
        data.appendRow((GridRow)row0);
        data.appendRow((GridRow)row1);
        data.appendRow((GridRow)row2);
        data.appendRow((GridRow)row3);
        data.appendRow((GridRow)row4);
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = columnIndex == 0 ? (rowIndex == 1 ? "b" : "a") : (rowIndex == 2 ? "a" : "b");
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(true, 2, "b")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(true, 0, "b")}, {BaseGridTest.Expected.build(true, 3, "a"), BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(true, 2, "b")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(true, 0, "b")}});
        data.moveRowTo(3, (GridRow)row2);
        this.assertGridIndexes((GridData)data, new boolean[]{true, true, true, true, true}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a"), BaseGridTest.Expected.build(true, 3, "b")}, {BaseGridTest.Expected.build(false, 1, "b"), BaseGridTest.Expected.build(true, 0, "b")}, {BaseGridTest.Expected.build(true, 3, "a"), BaseGridTest.Expected.build(true, 0, "b")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(true, 0, "a"), BaseGridTest.Expected.build(false, 1, "b")}});
    }
}

