/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.model.impl;

import org.junit.Test;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridTest;

public class GridRowsUnmergedTest
extends BaseGridTest {
    @Test
    public void testRemoveRow() {
        BaseGridData data = new BaseGridData(false);
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = rowIndex > 0 && rowIndex < 4 ? "b" : "a";
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false, false, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, "b")}, {BaseGridTest.Expected.build(false, 1, "b")}, {BaseGridTest.Expected.build(false, 1, "b")}, {BaseGridTest.Expected.build(false, 1, "a")}});
        data.deleteRow(2);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false, false}, new boolean[]{false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, "b")}, {BaseGridTest.Expected.build(false, 1, "b")}, {BaseGridTest.Expected.build(false, 1, "a")}});
    }

    @Test
    public void testAppendRow() {
        BaseGridData data = new BaseGridData(false);
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = rowIndex < 2 ? "a" : "b";
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false, false}, new boolean[]{false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, "b")}, {BaseGridTest.Expected.build(false, 1, "b")}});
        data.appendRow((GridRow)new BaseGridRow());
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false, false, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, "b")}, {BaseGridTest.Expected.build(false, 1, "b")}, {BaseGridTest.Expected.build(false, 1, null)}});
    }

    @Test
    public void testInsertRowAtZeroIndex() {
        BaseGridData data = new BaseGridData(false);
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = rowIndex < 2 ? "a" : "b";
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false, false}, new boolean[]{false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, "b")}, {BaseGridTest.Expected.build(false, 1, "b")}});
        data.insertRow(0, (GridRow)new BaseGridRow());
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false, false, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, null)}, {BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, "b")}, {BaseGridTest.Expected.build(false, 1, "b")}});
    }

    @Test
    public void testInsertRowAtStartEndBlock() {
        BaseGridData data = new BaseGridData(false);
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = rowIndex < 2 ? "a" : "b";
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false, false}, new boolean[]{false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, "b")}, {BaseGridTest.Expected.build(false, 1, "b")}});
        data.insertRow(2, (GridRow)new BaseGridRow());
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false, false, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, null)}, {BaseGridTest.Expected.build(false, 1, "b")}, {BaseGridTest.Expected.build(false, 1, "b")}});
    }

    @Test
    public void testInsertRowAtMidBlock() {
        BaseGridData data = new BaseGridData(false);
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)"a"));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false, false}, new boolean[]{false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, "a")}});
        data.insertRow(2, (GridRow)new BaseGridRow());
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false, false, false}, new boolean[]{false, false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, null)}, {BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, "a")}});
    }

    @Test
    public void testDeleteRowAtZeroIndex() {
        BaseGridData data = new BaseGridData(false);
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = rowIndex < 2 ? "a" : "b";
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false, false}, new boolean[]{false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, "b")}, {BaseGridTest.Expected.build(false, 1, "b")}});
        data.deleteRow(0);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, "b")}, {BaseGridTest.Expected.build(false, 1, "b")}});
    }

    @Test
    public void testDeleteRowAtStartEndBlock() {
        BaseGridData data = new BaseGridData(false);
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                String value = rowIndex < 2 ? "a" : "b";
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)value));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false, false}, new boolean[]{false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, "b")}, {BaseGridTest.Expected.build(false, 1, "b")}});
        data.deleteRow(2);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, "b")}});
    }

    @Test
    public void testDeleteRowAtMidBlock() {
        BaseGridData data = new BaseGridData(false);
        BaseGridTest.MockMergableGridColumn gc1 = new BaseGridTest.MockMergableGridColumn("col1", 100.0);
        data.appendColumn(gc1);
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        data.appendRow((GridRow)new BaseGridRow());
        for (int rowIndex = 0; rowIndex < data.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < data.getColumnCount(); ++columnIndex) {
                data.setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)"a"));
            }
        }
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false, false}, new boolean[]{false, false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, "a")}});
        data.deleteRow(2);
        this.assertGridIndexes((GridData)data, new boolean[]{false, false, false}, new boolean[]{false, false, false}, new BaseGridTest.Expected[][]{{BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, "a")}, {BaseGridTest.Expected.build(false, 1, "a")}});
    }
}

