/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.dnd;

import com.ait.lienzo.client.core.event.NodeMouseUpEvent;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Style;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.widget.dnd.GridWidgetDnDHandlersState;
import org.uberfire.ext.wires.core.grids.client.widget.dnd.GridWidgetDnDMouseUpHandler;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;

@RunWith(value=LienzoMockitoTestRunner.class)
public class GridWidgetDnDMouseUpHandlerTest {
    @Mock
    private GridLayer layer;
    @Mock
    private Viewport viewport;
    @Mock
    private DivElement element;
    @Mock
    private Style style;
    @Mock
    private NodeMouseUpEvent event;
    private GridWidgetDnDHandlersState state;
    private GridWidgetDnDMouseUpHandler handler;

    @Before
    public void setup() {
        Mockito.when((Object)this.layer.getViewport()).thenReturn((Object)this.viewport);
        Mockito.when((Object)this.viewport.getElement()).thenReturn((Object)this.element);
        Mockito.when((Object)this.element.getStyle()).thenReturn((Object)this.style);
        GridWidgetDnDHandlersState wrappedState = new GridWidgetDnDHandlersState();
        this.state = (GridWidgetDnDHandlersState)Mockito.spy((Object)wrappedState);
        GridWidgetDnDMouseUpHandler wrapped = new GridWidgetDnDMouseUpHandler(this.layer, this.state);
        this.handler = (GridWidgetDnDMouseUpHandler)Mockito.spy((Object)wrapped);
    }

    @Test
    public void stateIsResetOnMouseUpWhenStateIsNone() {
        this.state.setOperation(GridWidgetDnDHandlersState.GridWidgetHandlersOperation.NONE);
        this.handler.onNodeMouseUp(this.event);
        ((GridWidgetDnDHandlersState)Mockito.verify((Object)this.state, (VerificationMode)Mockito.times((int)1))).reset();
    }

    @Test
    public void stateIsResetOnMouseUpWhenStateIsColumnMovePending() {
        this.state.setOperation(GridWidgetDnDHandlersState.GridWidgetHandlersOperation.COLUMN_MOVE_PENDING);
        this.handler.onNodeMouseUp(this.event);
        ((GridWidgetDnDHandlersState)Mockito.verify((Object)this.state, (VerificationMode)Mockito.times((int)1))).reset();
    }

    @Test
    public void stateIsResetOnMouseUpWhenStateIsColumnResizePending() {
        this.state.setOperation(GridWidgetDnDHandlersState.GridWidgetHandlersOperation.COLUMN_RESIZE_PENDING);
        this.handler.onNodeMouseUp(this.event);
        ((GridWidgetDnDHandlersState)Mockito.verify((Object)this.state, (VerificationMode)Mockito.times((int)1))).reset();
    }

    @Test
    public void stateIsResetOnMouseUpWhenStateIsColumnResize() {
        this.state.setOperation(GridWidgetDnDHandlersState.GridWidgetHandlersOperation.COLUMN_RESIZE);
        this.handler.onNodeMouseUp(this.event);
        ((GridWidgetDnDHandlersState)Mockito.verify((Object)this.state, (VerificationMode)Mockito.times((int)1))).reset();
    }

    @Test
    public void stateIsResetOnMouseUpWhenStateIsColumnMove() {
        this.state.setOperation(GridWidgetDnDHandlersState.GridWidgetHandlersOperation.COLUMN_MOVE);
        this.handler.onNodeMouseUp(this.event);
        ((GridWidgetDnDHandlersState)Mockito.verify((Object)this.state, (VerificationMode)Mockito.times((int)1))).reset();
        ((GridLayer)Mockito.verify((Object)this.layer, (VerificationMode)Mockito.times((int)1))).remove(Mockito.any(IPrimitive.class));
        ((GridLayer)Mockito.verify((Object)this.layer, (VerificationMode)Mockito.times((int)1))).batch();
    }

    @Test
    public void stateIsResetOnMouseUpWhenStateIsRowMove() {
        this.state.setOperation(GridWidgetDnDHandlersState.GridWidgetHandlersOperation.ROW_MOVE);
        this.handler.onNodeMouseUp(this.event);
        ((GridWidgetDnDHandlersState)Mockito.verify((Object)this.state, (VerificationMode)Mockito.times((int)1))).reset();
        ((GridLayer)Mockito.verify((Object)this.layer, (VerificationMode)Mockito.times((int)1))).remove(Mockito.any(IPrimitive.class));
        ((GridLayer)Mockito.verify((Object)this.layer, (VerificationMode)Mockito.times((int)1))).batch();
    }
}

