/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.impl;

import com.ait.lienzo.client.core.event.NodeMouseClickEvent;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.BaseGridWidgetMouseClickHandler;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.DefaultGridLayer;

@RunWith(value=LienzoMockitoTestRunner.class)
public class BaseGridWidgetMouseClickHandlerTest {
    @Mock
    private GridWidget gridWidget;
    @Mock
    private Viewport viewport;
    @Mock
    private DefaultGridLayer layer;
    @Mock
    private GridSelectionManager selectionManager;
    @Mock
    private GridRenderer renderer;
    @Mock
    private NodeMouseClickEvent event;
    @Mock
    private GridData uiModel;
    @Mock
    private BaseGridRendererHelper helper;
    @Mock
    private GridColumn<String> uiColumn;
    @Mock
    private GridColumn<String> uiLinkedColumn;
    private BaseGridWidgetMouseClickHandler handler;

    @Before
    public void setup() {
        Mockito.when((Object)this.gridWidget.getViewport()).thenReturn((Object)this.viewport);
        Mockito.when((Object)this.gridWidget.getModel()).thenReturn((Object)this.uiModel);
        Mockito.when((Object)this.gridWidget.getRendererHelper()).thenReturn((Object)this.helper);
        Mockito.when((Object)this.gridWidget.getLayer()).thenReturn((Object)this.layer);
        Mockito.when((Object)this.renderer.getHeaderHeight()).thenReturn((Object)64.0);
        Mockito.when((Object)this.renderer.getHeaderRowHeight()).thenReturn((Object)32.0);
        Mockito.when((Object)this.uiModel.getHeaderRowCount()).thenReturn((Object)2);
        BaseGridWidgetMouseClickHandler wrapped = new BaseGridWidgetMouseClickHandler(this.gridWidget, this.selectionManager, this.renderer);
        this.handler = (BaseGridWidgetMouseClickHandler)Mockito.spy((Object)wrapped);
    }

    @Test
    public void skipInvisibleGrid() {
        Mockito.when((Object)this.gridWidget.isVisible()).thenReturn((Object)false);
        this.handler.onNodeMouseClick(this.event);
        ((BaseGridWidgetMouseClickHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).handleHeaderCellClick((NodeMouseClickEvent)Mockito.any(NodeMouseClickEvent.class));
        ((BaseGridWidgetMouseClickHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).handleBodyCellClick((NodeMouseClickEvent)Mockito.any(NodeMouseClickEvent.class));
        ((GridSelectionManager)Mockito.verify((Object)this.selectionManager, (VerificationMode)Mockito.never())).select((GridWidget)Mockito.eq((Object)this.gridWidget));
    }

    @Test
    public void selectVisibleGridHeaderNonLinkedColumn() {
        Mockito.when((Object)this.gridWidget.isVisible()).thenReturn((Object)true);
        Mockito.when((Object)this.event.getX()).thenReturn((Object)100);
        Mockito.when((Object)this.event.getY()).thenReturn((Object)100);
        Mockito.when((Object)this.gridWidget.getLocation()).thenReturn((Object)new Point2D(100.0, 100.0));
        Mockito.when((Object)this.uiColumn.isLinked()).thenReturn((Object)false);
        BaseGridRendererHelper.ColumnInformation ci = new BaseGridRendererHelper.ColumnInformation(this.uiColumn, 0, 0.0);
        Mockito.when((Object)this.helper.getColumnInformation(((Double)Mockito.any(Double.class)).doubleValue())).thenReturn((Object)ci);
        this.handler.onNodeMouseClick(this.event);
        ((BaseGridWidgetMouseClickHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).handleHeaderCellClick((NodeMouseClickEvent)Mockito.any(NodeMouseClickEvent.class));
        ((BaseGridWidgetMouseClickHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).handleBodyCellClick((NodeMouseClickEvent)Mockito.any(NodeMouseClickEvent.class));
        ((GridSelectionManager)Mockito.verify((Object)this.selectionManager, (VerificationMode)Mockito.times((int)1))).select((GridWidget)Mockito.eq((Object)this.gridWidget));
        ((GridSelectionManager)Mockito.verify((Object)this.selectionManager, (VerificationMode)Mockito.never())).selectLinkedColumn((GridColumn)Mockito.eq(this.uiColumn));
    }

    @Test
    public void selectVisibleGridHeaderLinkedColumn() {
        Mockito.when((Object)this.gridWidget.isVisible()).thenReturn((Object)true);
        Mockito.when((Object)this.event.getX()).thenReturn((Object)100);
        Mockito.when((Object)this.event.getY()).thenReturn((Object)100);
        Mockito.when((Object)this.gridWidget.getLocation()).thenReturn((Object)new Point2D(100.0, 100.0));
        Mockito.when((Object)this.uiColumn.isLinked()).thenReturn((Object)true);
        Mockito.when((Object)this.uiColumn.getLink()).thenAnswer(invocation -> this.uiLinkedColumn);
        BaseGridRendererHelper.ColumnInformation ci = new BaseGridRendererHelper.ColumnInformation(this.uiColumn, 0, 0.0);
        Mockito.when((Object)this.helper.getColumnInformation(((Double)Mockito.any(Double.class)).doubleValue())).thenReturn((Object)ci);
        this.handler.onNodeMouseClick(this.event);
        ((BaseGridWidgetMouseClickHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).handleHeaderCellClick((NodeMouseClickEvent)Mockito.any(NodeMouseClickEvent.class));
        ((BaseGridWidgetMouseClickHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).handleBodyCellClick((NodeMouseClickEvent)Mockito.any(NodeMouseClickEvent.class));
        ((GridSelectionManager)Mockito.verify((Object)this.selectionManager, (VerificationMode)Mockito.never())).select((GridWidget)Mockito.eq((Object)this.gridWidget));
        ((GridSelectionManager)Mockito.verify((Object)this.selectionManager, (VerificationMode)Mockito.times((int)1))).selectLinkedColumn((GridColumn)Mockito.eq(this.uiLinkedColumn));
    }

    @Test
    public void selectVisibleGridBody() {
        Mockito.when((Object)this.gridWidget.isVisible()).thenReturn((Object)true);
        Mockito.when((Object)this.event.getX()).thenReturn((Object)100);
        Mockito.when((Object)this.event.getY()).thenReturn((Object)200);
        Mockito.when((Object)this.gridWidget.getLocation()).thenReturn((Object)new Point2D(100.0, 100.0));
        Mockito.when((Object)this.gridWidget.getHeight()).thenReturn((Object)200.0);
        BaseGridRendererHelper.ColumnInformation ci = new BaseGridRendererHelper.ColumnInformation(this.uiColumn, 0, 0.0);
        Mockito.when((Object)this.helper.getColumnInformation(((Double)Mockito.any(Double.class)).doubleValue())).thenReturn((Object)ci);
        this.handler.onNodeMouseClick(this.event);
        ((BaseGridWidgetMouseClickHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).handleHeaderCellClick((NodeMouseClickEvent)Mockito.any(NodeMouseClickEvent.class));
        ((BaseGridWidgetMouseClickHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)1))).handleBodyCellClick((NodeMouseClickEvent)Mockito.any(NodeMouseClickEvent.class));
        ((GridSelectionManager)Mockito.verify((Object)this.selectionManager, (VerificationMode)Mockito.times((int)1))).select((GridWidget)Mockito.eq((Object)this.gridWidget));
    }
}

