/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.selections.impl;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.CellSelectionStrategy;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.impl.BaseCellSelectionStrategyTest;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.impl.RangeSelectionStrategy;

public class RangeSelectionStrategyMergedDataTest
extends BaseCellSelectionStrategyTest {
    @Override
    protected CellSelectionStrategy getStrategy() {
        return new RangeSelectionStrategy();
    }

    @Test
    public void singleCellSelection() {
        this.strategy.handleSelection(this.uiModel, 0, 0, false, false);
        List selectedCells = this.uiModel.getSelectedCells();
        Assert.assertEquals((long)2L, (long)selectedCells.size());
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(1, 0)));
    }

    @Test
    public void extendSelectionWithShiftKey() {
        this.strategy.handleSelection(this.uiModel, 0, 0, false, false);
        this.strategy.handleSelection(this.uiModel, 2, 1, true, false);
        List selectedCells = this.uiModel.getSelectedCells();
        Assert.assertEquals((long)8L, (long)selectedCells.size());
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(2, 0)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(3, 0)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(0, 1)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(1, 1)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(2, 1)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(3, 1)));
    }

    @Test
    public void extendSelectionWithControlKey() {
        this.strategy.handleSelection(this.uiModel, 0, 0, false, false);
        this.strategy.handleSelection(this.uiModel, 2, 1, false, true);
        List selectedCells = this.uiModel.getSelectedCells();
        Assert.assertEquals((long)4L, (long)selectedCells.size());
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(2, 1)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(3, 1)));
    }

    @Test
    public void extendSelectionWithColumnMovedWithShiftKey() {
        this.uiModel.moveColumnTo(0, this.gc2);
        this.strategy.handleSelection(this.uiModel, 0, 0, false, false);
        this.strategy.handleSelection(this.uiModel, 2, 1, true, false);
        List selectedCells = this.uiModel.getSelectedCells();
        Assert.assertEquals((long)8L, (long)selectedCells.size());
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(0, 0)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(1, 0)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(2, 0)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(3, 0)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(0, 1)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(1, 1)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(2, 1)));
        Assert.assertTrue((boolean)selectedCells.contains(new GridData.SelectedCell(3, 1)));
    }
}

