/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.edit;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.ModalBody;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;

public class EditorPopup
extends Modal {
    private final TextBox textBox = new TextBox();
    private final ModalBody modalBody = new ModalBody();
    private GridCellValue<String> value;
    private Callback<GridCellValue<String>> callback = null;

    public EditorPopup() {
        this.setTitle("Edit");
        this.textBox.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                if (event.getNativeKeyCode() == 13) {
                    EditorPopup.this.commit();
                }
            }
        });
        this.modalBody.add((Widget)this.textBox);
        this.add((Widget)this.modalBody);
        ModalFooter footer = new ModalFooter();
        Button okButton = new Button("OK");
        okButton.setIcon(IconType.EDIT);
        okButton.setType(ButtonType.PRIMARY);
        okButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                EditorPopup.this.commit();
            }
        });
        Button cancelButton = new Button("Cancel");
        cancelButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                EditorPopup.this.cancel();
            }
        });
        footer.add((Widget)okButton);
        footer.add((Widget)cancelButton);
        this.add((Widget)footer);
        this.addShownHandler(e -> this.textBox.setFocus(true));
    }

    public void edit(GridCellValue<String> value, Callback<GridCellValue<String>> callback) {
        this.value = value;
        this.callback = callback;
        this.textBox.setText(value == null ? "" : value.getValue());
        this.show();
    }

    private void cancel() {
        this.hide();
    }

    private void commit() {
        if (this.callback != null) {
            this.callback.callback(new BaseGridCellValue<String>(this.textBox.getText()));
        }
        this.hide();
    }
}

