/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.demo;

import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.impl.RowSelectionStrategy;

public class GridDataFactory {
    public static double FILL_FACTOR = 0.75;

    public static void populate(GridData grid, int rowCount) {
        int columnCount = grid.getColumnCount();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            BaseGridRow row = new BaseGridRow(GridDataFactory.getRowHeight());
            grid.appendRow(row);
            for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                GridColumn<?> column = grid.getColumns().get(columnIndex);
                if (column instanceof RowNumberColumn) {
                    grid.setCell(rowIndex, columnIndex, new BaseGridCellValue<Integer>(rowIndex + 1));
                    grid.getCell(rowIndex, columnIndex).setSelectionManager(RowSelectionStrategy.INSTANCE);
                    continue;
                }
                if (!(Math.random() < FILL_FACTOR)) continue;
                grid.setCell(rowIndex, columnIndex, new BaseGridCellValue<String>("(" + columnIndex + ", " + rowIndex + ")"));
            }
        }
    }

    private static double getRowHeight() {
        int r = (int)Math.round(Math.random() * 3.0);
        switch (r) {
            case 0: {
                return 20.0;
            }
            case 1: {
                return 40.0;
            }
        }
        return 60.0;
    }
}

