/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.animation;

import com.ait.lienzo.client.core.animation.AnimationTweener;
import com.ait.lienzo.client.core.animation.IAnimation;
import com.ait.lienzo.client.core.animation.IAnimationCallback;
import com.ait.lienzo.client.core.animation.IAnimationHandle;
import com.ait.lienzo.client.core.animation.TimedAnimation;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.client.core.types.Transform;
import com.google.gwt.user.client.Command;
import java.util.Set;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;

public class GridWidgetExitPinnedModeAnimation
extends TimedAnimation {
    public GridWidgetExitPinnedModeAnimation(final GridPinnedModeManager.PinnedContext state, final Set<GridWidget> gridWidgets, final Set<IPrimitive<?>> gridWidgetConnectors, final Command onCompleteCommand) {
        super(500.0, new IAnimationCallback(){
            private final double startScaleX = 1.0;
            private final double startScaleY = 1.0;
            private Point2D delta;
            private Point2D startTranslation;
            private GridWidget gridWidget;
            private double endScaleX;
            private double endScaleY;
            private AnimationTweener tweener = AnimationTweener.EASE_OUT;

            public void onStart(IAnimation animation, IAnimationHandle handle) {
                this.gridWidget = state.getGridWidget();
                Viewport vp = this.gridWidget.getViewport();
                if (vp.getTransform() == null) {
                    vp.setTransform(new Transform());
                }
                this.endScaleX = state.getScaleX();
                this.endScaleY = state.getScaleY();
                this.startTranslation = this.getViewportTranslation().mul(-1.0);
                Point2D endTranslation = new Point2D(state.getTranslateX(), state.getTranslateY());
                this.delta = new Point2D(endTranslation.getX() - this.startTranslation.getX(), endTranslation.getY() - this.startTranslation.getY());
                for (GridWidget gw : gridWidgets) {
                    gw.setVisible(true);
                }
                for (IPrimitive p : gridWidgetConnectors) {
                    p.setVisible(true);
                }
                this.gridWidget.getLayer().setListening(false);
                this.gridWidget.getLayer().batch();
            }

            public void onFrame(IAnimation animation, IAnimationHandle handle) {
                double pct = this.assertPct(animation.getPercent());
                Viewport vp = this.gridWidget.getViewport();
                Transform transform = vp.getTransform();
                transform.reset();
                Point2D frameLocation = this.startTranslation.add(this.delta.mul(pct));
                double frameScaleX = 1.0 + (this.endScaleX - 1.0) * pct;
                double frameScaleY = 1.0 + (this.endScaleY - 1.0) * pct;
                transform.translate(frameLocation.getX(), frameLocation.getY()).scale(frameScaleX, frameScaleY);
                this.showGridWidgets(pct);
                this.showGridWidgetConnectors(pct);
                this.gridWidget.getLayer().batch();
            }

            public void onClose(IAnimation animation, IAnimationHandle handle) {
                this.gridWidget.getLayer().setListening(true);
                this.gridWidget.getLayer().batch();
                onCompleteCommand.execute();
            }

            private Point2D getViewportTranslation() {
                Viewport vp = this.gridWidget.getViewport();
                Transform transform = vp.getTransform();
                Transform t = transform.copy().getInverse();
                Point2D p = new Point2D(t.getTranslateX(), t.getTranslateY());
                return p;
            }

            private double assertPct(double pct) {
                if (pct < 0.0) {
                    return 0.0;
                }
                if (pct > 1.0) {
                    return 1.0;
                }
                return this.tweener.apply(pct);
            }

            private void showGridWidgets(double pct) {
                for (GridWidget gw : gridWidgets) {
                    gw.setAlpha(pct);
                }
            }

            private void showGridWidgetConnectors(double pct) {
                for (IPrimitive p : gridWidgetConnectors) {
                    p.setAlpha(pct);
                }
            }
        });
    }
}

