/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Line;
import com.ait.lienzo.client.core.shape.MultiPath;
import com.ait.lienzo.client.core.shape.Rectangle;
import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.client.core.types.Point2DArray;
import com.ait.lienzo.client.core.types.Transform;
import java.util.List;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyColumnRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridHeaderColumnRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridHeaderRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.SelectionsTransformer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.GroupingToggle;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.SelectedRange;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.themes.GridRendererTheme;

public class BaseGridRenderer
implements GridRenderer {
    private static final int HEADER_HEIGHT = 64;
    private static final int HEADER_ROW_HEIGHT = 32;
    private static final String LINK_FONT_FAMILY = "Glyphicons Halflings";
    private static final double LINK_FONT_SIZE = 10.0;
    private static final String LINK_ICON = "\ue144";
    protected GridRendererTheme theme;

    public BaseGridRenderer(GridRendererTheme theme) {
        this.setTheme(theme);
    }

    @Override
    public double getHeaderHeight() {
        return 64.0;
    }

    @Override
    public double getHeaderRowHeight() {
        return 32.0;
    }

    @Override
    public GridRendererTheme getTheme() {
        return this.theme;
    }

    @Override
    public void setTheme(GridRendererTheme theme) {
        this.theme = (GridRendererTheme)PortablePreconditions.checkNotNull((String)"theme", (Object)theme);
    }

    @Override
    public Group renderSelector(double width, double height, BaseGridRendererHelper.RenderingInformation renderingInformation) {
        Group g = new Group();
        MultiPath selector = (MultiPath)this.theme.getSelector().M(0.5, 0.5).L(0.5, height).L(width, height).L(width, 0.5).L(0.5, 0.5).setListening(false);
        g.add((IPrimitive)selector);
        return g;
    }

    @Override
    public Group renderSelectedCells(GridData model, GridBodyRenderContext context, BaseGridRendererHelper rendererHelper) {
        List<GridColumn<?>> blockColumns = context.getBlockColumns();
        SelectionsTransformer transformer = context.getTransformer();
        int minVisibleUiColumnIndex = model.getColumns().indexOf(blockColumns.get(0));
        int maxVisibleUiColumnIndex = model.getColumns().indexOf(blockColumns.get(blockColumns.size() - 1));
        int minVisibleUiRowIndex = context.getMinVisibleRowIndex();
        int maxVisibleUiRowIndex = context.getMaxVisibleRowIndex();
        List<SelectedRange> selectedRanges = transformer.transformToSelectedRanges();
        Group g = new Group();
        for (SelectedRange selectedRange : selectedRanges) {
            Group cs;
            int rangeOriginUiColumnIndex = selectedRange.getUiColumnIndex();
            int rangeOriginUiRowIndex = selectedRange.getUiRowIndex();
            int rangeUiWidth = selectedRange.getWidth();
            int rangeUiHeight = selectedRange.getHeight();
            if (rangeOriginUiColumnIndex + rangeUiWidth - 1 < minVisibleUiColumnIndex || rangeOriginUiColumnIndex > maxVisibleUiColumnIndex || rangeOriginUiRowIndex + rangeUiHeight - 1 < minVisibleUiRowIndex || rangeOriginUiRowIndex > maxVisibleUiRowIndex) continue;
            SelectedRange _selectedRange = selectedRange;
            if (rangeOriginUiRowIndex < minVisibleUiRowIndex) {
                int dy = minVisibleUiRowIndex - rangeOriginUiRowIndex;
                _selectedRange = new SelectedRange(selectedRange.getUiRowIndex() + dy, selectedRange.getUiColumnIndex(), selectedRange.getWidth(), selectedRange.getHeight() - dy);
            }
            if ((cs = this.renderSelectedRange(model, blockColumns, minVisibleUiColumnIndex, _selectedRange)) == null) continue;
            double csx = rendererHelper.getColumnOffset(blockColumns, _selectedRange.getUiColumnIndex() - minVisibleUiColumnIndex);
            double csy = rendererHelper.getRowOffset(_selectedRange.getUiRowIndex()) - rendererHelper.getRowOffset(minVisibleUiRowIndex);
            ((Group)((Group)cs.setX(csx)).setY(csy)).setListening(false);
            g.add((IPrimitive)cs);
        }
        return g;
    }

    protected Group renderSelectedRange(GridData model, List<GridColumn<?>> blockColumns, int minVisibleUiColumnIndex, SelectedRange selectedRange) {
        Group cellSelector = new Group();
        double width = this.getSelectedRangeWidth(blockColumns, minVisibleUiColumnIndex, selectedRange);
        double height = this.getSelectedRangeHeight(model, selectedRange);
        Rectangle selector = (Rectangle)((Rectangle)this.theme.getCellSelector().setWidth(width).setHeight(height).setStrokeWidth(1.0)).setListening(false);
        Rectangle highlight = (Rectangle)((Rectangle)((Rectangle)this.theme.getCellSelector().setWidth(width).setHeight(height).setFillColor(selector.getStrokeColor())).setListening(false)).setAlpha(0.25);
        cellSelector.add((IPrimitive)highlight);
        cellSelector.add((IPrimitive)selector);
        return cellSelector;
    }

    private double getSelectedRangeWidth(List<GridColumn<?>> blockColumns, int minVisibleUiColumnIndex, SelectedRange selectedRange) {
        double width = 0.0;
        for (int columnIndex = 0; columnIndex < selectedRange.getWidth(); ++columnIndex) {
            int relativeColumnIndex = columnIndex + selectedRange.getUiColumnIndex() - minVisibleUiColumnIndex;
            width += blockColumns.get(relativeColumnIndex).getWidth();
        }
        return width;
    }

    private double getSelectedRangeHeight(GridData model, SelectedRange selectedRange) {
        double height = 0.0;
        for (int rowIndex = 0; rowIndex < selectedRange.getHeight(); ++rowIndex) {
            height += model.getRow(selectedRange.getUiRowIndex() + rowIndex).getHeight();
        }
        return height;
    }

    @Override
    public Group renderHeader(GridData model, GridHeaderRenderContext context, BaseGridRendererHelper rendererHelper, BaseGridRendererHelper.RenderingInformation renderingInformation) {
        double w;
        List<GridColumn<?>> allBlockColumns = context.getAllColumns();
        List<GridColumn<?>> visibleBlockColumns = context.getBlockColumns();
        boolean isSelectionLayer = context.isSelectionLayer();
        double headerRowsHeight = renderingInformation.getHeaderRowsHeight();
        double headerRowsYOffset = renderingInformation.getHeaderRowsYOffset();
        Group g = new Group();
        double x = 0.0;
        for (GridColumn<?> column : visibleBlockColumns) {
            if (!column.isVisible()) continue;
            w = column.getWidth();
            Rectangle header = column.isLinked() ? this.theme.getHeaderLinkBackground(column) : this.theme.getHeaderBackground(column);
            if (header != null) {
                ((Rectangle)((Rectangle)header.setWidth(w).setListening(true)).setHeight(headerRowsHeight).setY(headerRowsYOffset)).setX(x);
                g.add((IPrimitive)header);
            }
            x += w;
        }
        if (isSelectionLayer) {
            return g;
        }
        x = 0.0;
        for (GridColumn<?> column : visibleBlockColumns) {
            if (!column.isVisible()) continue;
            double columnWidth = column.getWidth();
            int columnIndex = visibleBlockColumns.indexOf(column);
            GridHeaderColumnRenderContext headerCellRenderContext = new GridHeaderColumnRenderContext(allBlockColumns, visibleBlockColumns, columnIndex, model, this);
            Group headerGroup = column.getColumnRenderer().renderHeader(column.getHeaderMetaData(), headerCellRenderContext, renderingInformation);
            headerGroup.setX(x);
            g.add((IPrimitive)headerGroup);
            x += columnWidth;
        }
        x = 0.0;
        for (GridColumn<?> column : visibleBlockColumns) {
            if (!column.isVisible()) continue;
            w = column.getWidth();
            if (column.isLinked()) {
                Text t = (Text)((Text)this.theme.getBodyText().setFontFamily(LINK_FONT_FAMILY).setFontSize(10.0).setText(LINK_ICON).setY(headerRowsYOffset + 10.0)).setX(x + w - 10.0);
                g.add((IPrimitive)t);
            }
            x += w;
        }
        Group divider = this.renderHeaderBodyDivider(x);
        g.add((IPrimitive)divider);
        return g;
    }

    @Override
    public Group renderHeaderBodyDivider(double width) {
        Group g = new Group();
        Line divider = this.theme.getGridHeaderBodyDivider();
        divider.setPoints(new Point2DArray(new Point2D(0.0, this.getHeaderHeight() + 0.5), new Point2D[]{new Point2D(width, this.getHeaderHeight() + 0.5)}));
        g.add((IPrimitive)divider);
        return g;
    }

    @Override
    public Group renderBody(GridData model, GridBodyRenderContext context, BaseGridRendererHelper rendererHelper, BaseGridRendererHelper.RenderingInformation renderingInformation) {
        double columnWidth;
        double absoluteGridX = context.getAbsoluteGridX();
        double absoluteGridY = context.getAbsoluteGridY();
        double absoluteColumnOffsetX = context.getAbsoluteColumnOffsetX();
        double clipMinY = context.getClipMinY();
        double clipMinX = context.getClipMinX();
        int minVisibleRowIndex = context.getMinVisibleRowIndex();
        int maxVisibleRowIndex = context.getMaxVisibleRowIndex();
        List<GridColumn<?>> blockColumns = context.getBlockColumns();
        boolean isSelectionLayer = context.isSelectionLayer();
        Transform transform = context.getTransform();
        GridRenderer renderer = context.getRenderer();
        BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation = renderingInformation.getFloatingBlockInformation();
        List<Double> visibleRowOffsets = renderingInformation.getVisibleRowOffsets();
        double columnHeight = visibleRowOffsets.get(maxVisibleRowIndex - minVisibleRowIndex) - visibleRowOffsets.get(0) + model.getRow(maxVisibleRowIndex).getHeight();
        Group g = new Group();
        double x = 0.0;
        for (GridColumn<?> column : blockColumns) {
            if (!column.isVisible()) continue;
            columnWidth = column.getWidth();
            Rectangle body = (Rectangle)((Rectangle)this.theme.getBodyBackground(column).setWidth(columnWidth).setListening(true)).setHeight(columnHeight).setX(x);
            g.add((IPrimitive)body);
            x += columnWidth;
        }
        if (isSelectionLayer) {
            return g;
        }
        x = 0.0;
        for (GridColumn<?> column : blockColumns) {
            if (!column.isVisible()) continue;
            columnWidth = column.getWidth();
            double columnRelativeX = rendererHelper.getColumnOffset(blockColumns, blockColumns.indexOf(column)) + absoluteColumnOffsetX;
            boolean isFloating = floatingBlockInformation.getColumns().contains(column);
            GridBodyColumnRenderContext columnContext = new GridBodyColumnRenderContext(absoluteGridX, absoluteGridY, absoluteGridX + columnRelativeX, clipMinY, clipMinX, minVisibleRowIndex, maxVisibleRowIndex, isFloating, model, transform, renderer);
            Group columnGroup = column.getColumnRenderer().renderColumn(column, columnContext, rendererHelper, renderingInformation);
            columnGroup.setX(x);
            g.add((IPrimitive)columnGroup);
            x += columnWidth;
        }
        return g;
    }

    @Override
    public Group renderGridBoundary(double width, double height) {
        Group g = new Group();
        Rectangle boundary = (Rectangle)((Rectangle)((Rectangle)this.theme.getGridBoundary().setWidth(width).setHeight(height).setListening(false)).setX(0.5)).setY(0.5);
        g.add((IPrimitive)boundary);
        return g;
    }

    @Override
    public boolean onGroupingToggle(double cellX, double cellY, double cellWidth, double cellHeight) {
        return GroupingToggle.onHotSpot(cellX, cellY, cellWidth, cellHeight);
    }
}

