/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.dom.impl;

import com.ait.lienzo.client.core.event.NodeMouseClickEvent;
import com.ait.lienzo.client.core.event.NodeMouseDownEvent;
import com.ait.lienzo.client.core.event.NodeMouseMoveEvent;
import com.ait.lienzo.client.core.event.NodeMouseUpEvent;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.types.Transform;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseEvent;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;
import org.uberfire.ext.wires.core.grids.client.util.MathUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;

public abstract class BaseDOMElement<T, W extends Widget> {
    private static final NumberFormat FORMAT = NumberFormat.getFormat((String)"0.0");
    protected final W widget;
    protected final SimplePanel widgetContainer = new SimplePanel();
    protected final GridLayer gridLayer;
    protected final GridWidget gridWidget;
    protected final AbsolutePanel domElementContainer;
    protected GridBodyCellRenderContext context;

    public BaseDOMElement(W widget, final GridLayer gridLayer, final GridWidget gridWidget) {
        this.widget = widget;
        this.gridLayer = gridLayer;
        this.gridWidget = gridWidget;
        this.domElementContainer = gridLayer.getDomElementContainer();
        final Style style = this.widgetContainer.getElement().getStyle();
        style.setPosition(Style.Position.ABSOLUTE);
        this.widgetContainer.addDomHandler((EventHandler)new MouseDownHandler(){

            public void onMouseDown(MouseDownEvent event) {
                gridLayer.onNodeMouseDown(new NodeMouseDownEvent(event){

                    public int getX() {
                        return super.getX() + BaseDOMElement.this.widgetContainer.getElement().getOffsetLeft();
                    }

                    public int getY() {
                        return super.getY() + BaseDOMElement.this.widgetContainer.getElement().getOffsetTop();
                    }
                });
            }
        }, MouseDownEvent.getType());
        this.widgetContainer.addDomHandler((EventHandler)new MouseMoveHandler(){

            public void onMouseMove(MouseMoveEvent event) {
                style.setCursor(gridLayer.getGridWidgetHandlersState().getCursor());
                gridLayer.onNodeMouseMove(new NodeMouseMoveEvent(event){

                    public int getX() {
                        return super.getX() + BaseDOMElement.this.widgetContainer.getElement().getOffsetLeft();
                    }

                    public int getY() {
                        return super.getY() + BaseDOMElement.this.widgetContainer.getElement().getOffsetTop();
                    }
                });
            }
        }, MouseMoveEvent.getType());
        this.widgetContainer.addDomHandler((EventHandler)new MouseUpHandler(){

            public void onMouseUp(MouseUpEvent event) {
                gridLayer.onNodeMouseUp(new NodeMouseUpEvent(event){

                    public int getX() {
                        return super.getX() + BaseDOMElement.this.widgetContainer.getElement().getOffsetLeft();
                    }

                    public int getY() {
                        return super.getY() + BaseDOMElement.this.widgetContainer.getElement().getOffsetTop();
                    }
                });
            }
        }, MouseUpEvent.getType());
        this.widgetContainer.addDomHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                gridWidget.onNodeMouseClick(new NodeMouseClickEvent((MouseEvent)event){

                    public int getX() {
                        return super.getX() + BaseDOMElement.this.widgetContainer.getElement().getOffsetLeft();
                    }

                    public int getY() {
                        return super.getY() + BaseDOMElement.this.widgetContainer.getElement().getOffsetTop();
                    }
                });
            }
        }, ClickEvent.getType());
    }

    public void setContext(GridBodyCellRenderContext context) {
        this.context = context;
    }

    public abstract void initialise(GridBodyCellRenderContext var1);

    public abstract void flush(T var1);

    public W getWidget() {
        return this.widget;
    }

    protected SimplePanel getContainer() {
        return this.widgetContainer;
    }

    protected void transform(GridBodyCellRenderContext context) {
        Transform transform = context.getTransform();
        double width = context.getCellWidth();
        double height = context.getCellHeight();
        Style style = this.widgetContainer.getElement().getStyle();
        style.setOpacity(this.gridWidget.getAlpha());
        style.setLeft(context.getAbsoluteCellX() * transform.getScaleX() + transform.getTranslateX(), Style.Unit.PX);
        style.setTop(context.getAbsoluteCellY() * transform.getScaleY() + transform.getTranslateY(), Style.Unit.PX);
        style.setWidth(width, Style.Unit.PX);
        style.setHeight(height, Style.Unit.PX);
        style.clearProperty("clip");
        double top = context.getAbsoluteCellY() + transform.getTranslateY();
        double left = context.getAbsoluteCellX() + transform.getTranslateX();
        boolean isFloating = context.isFloating();
        boolean clip = false;
        double ct = 0.0;
        double cr = width;
        double cb = height;
        double cl = 0.0;
        Group header = this.gridWidget.getHeader();
        double clipMinY = context.getClipMinY() + transform.getTranslateY();
        double clipMinX = context.getClipMinX() + transform.getTranslateX();
        if (header != null && top < clipMinY) {
            ct = clipMinY - top;
            clip = true;
        }
        if (!isFloating && left < clipMinX) {
            cl = clipMinX - left;
            clip = true;
        }
        if (clip) {
            style.setProperty("clip", "rect(" + (int)ct + "px," + (int)cr + "px," + (int)cb + "px," + (int)cl + "px)");
        }
        style.setProperty("WebkitBoxSizing", "border-box");
        style.setProperty("MozBoxSizing", "border-box");
        style.setProperty("boxSizing", "border-box");
        style.setProperty("lineHeight", "normal");
        if (MathUtilities.isOne(transform.getScaleX()) && MathUtilities.isOne(transform.getScaleY())) {
            style.clearProperty("WebkitTransform");
            style.clearProperty("MozTransform");
            style.clearProperty("Transform");
            style.clearProperty("MsTransform");
            return;
        }
        String scale = "scale(" + FORMAT.format(transform.getScaleX()) + ", " + FORMAT.format(transform.getScaleY()) + ")";
        String translate = "translate(" + FORMAT.format((width - width * transform.getScaleX()) / -2.0) + "px, " + FORMAT.format((height - height * transform.getScaleY()) / -2.0) + "px)";
        style.setProperty("WebkitTransform", translate + " " + scale);
        style.setProperty("MozTransform", translate + " " + scale);
        style.setProperty("Transform", translate + " " + scale);
        style.setProperty("MsTransform", translate + " " + scale);
    }

    public void attach() {
        Iterator itr = this.domElementContainer.iterator();
        while (itr.hasNext()) {
            if (!((Widget)itr.next()).equals(this.widgetContainer)) continue;
            return;
        }
        Style style = this.widgetContainer.getElement().getStyle();
        style.setPosition(Style.Position.ABSOLUTE);
        style.setProperty("WebkitUserSelect", "none");
        style.setProperty("MozUserSelect", "none");
        style.setProperty("MsUserSelect", "none");
        this.domElementContainer.add((Widget)this.widgetContainer);
    }

    public void detach() {
        Iterator itr = this.domElementContainer.iterator();
        while (itr.hasNext()) {
            if (!((Widget)itr.next()).equals(this.widgetContainer)) continue;
            itr.remove();
            return;
        }
    }
}

