/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.layer.impl;

import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.widget.LienzoPanel;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ScrollEvent;
import com.google.gwt.event.dom.client.ScrollHandler;
import com.google.gwt.event.logical.shared.AttachEvent;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.ProvidesResize;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.DefaultGridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.scrollbars.GridLienzoScrollHandler;
import org.uberfire.ext.wires.core.grids.client.widget.scrollbars.GridLienzoScrollable;

public class GridLienzoPanel
extends FocusPanel
implements RequiresResize,
ProvidesResize,
GridLienzoScrollable {
    protected final LienzoPanel lienzoPanel;
    protected final AbsolutePanel domElementContainer = new AbsolutePanel();
    private final AbsolutePanel internalScrollPanel = new AbsolutePanel();
    private final AbsolutePanel mainPanel = new AbsolutePanel();
    private final GridLienzoScrollHandler gridLienzoScrollHandler;
    private DefaultGridLayer defaultGridLayer;

    public GridLienzoPanel() {
        this(new LienzoPanel(){

            public void onResize() {
            }
        });
    }

    public GridLienzoPanel(int width, int height) {
        this(new LienzoPanel(width, height){

            public void onResize() {
            }
        });
        this.domElementContainer.setPixelSize(width, height);
    }

    private GridLienzoPanel(LienzoPanel lienzoPanel) {
        this.lienzoPanel = lienzoPanel;
        this.gridLienzoScrollHandler = new GridLienzoScrollHandler(this);
        this.setupMainPanel();
        this.setupScrollHandlers();
        this.setupDefaultHandlers();
    }

    void setupMainPanel() {
        this.getDomElementContainer().add((Widget)this.getLienzoPanel());
        this.getMainPanel().add((Widget)this.getInternalScrollPanel());
        this.getMainPanel().add((Widget)this.getDomElementContainer());
        this.add((Widget)this.getMainPanel());
    }

    void setupScrollHandlers() {
        this.getGridLienzoScrollHandler().init();
        this.addMouseUpHandler();
    }

    void addMouseUpHandler() {
        this.addMouseUpHandler(e -> this.refreshScrollPosition());
    }

    private void setupDefaultHandlers() {
        this.domElementContainer.addDomHandler((EventHandler)new ScrollHandler(){

            public void onScroll(ScrollEvent scrollEvent) {
                GridLienzoPanel.this.domElementContainer.getElement().setScrollTop(0);
                GridLienzoPanel.this.domElementContainer.getElement().setScrollLeft(0);
            }
        }, ScrollEvent.getType());
        this.addAttachHandler(new AttachEvent.Handler(){

            public void onAttachOrDetach(AttachEvent event) {
                if (event.isAttached()) {
                    GridLienzoPanel.this.onResize();
                }
            }
        });
        this.addMouseDownHandler(e -> this.setFocus(true));
    }

    public void onResize() {
        this.scheduleDeferred(() -> {
            this.updatePanelSize();
            this.refreshScrollPosition();
        });
    }

    void scheduleDeferred(Scheduler.ScheduledCommand scheduledCommand) {
        Scheduler.get().scheduleDeferred(scheduledCommand);
    }

    @Override
    public void updatePanelSize() {
        Element e = this.getElement().getParentElement();
        int width = e.getOffsetWidth();
        int height = e.getOffsetHeight();
        if (width > 0 && height > 0) {
            Integer scrollbarWidth = this.getGridLienzoScrollHandler().scrollbarWidth();
            Integer scrollbarHeight = this.getGridLienzoScrollHandler().scrollbarHeight();
            this.getDomElementContainer().setPixelSize(width - scrollbarWidth, height - scrollbarHeight);
            this.getLienzoPanel().setPixelSize(width - scrollbarWidth, height - scrollbarHeight);
            this.getMainPanel().setPixelSize(width, height);
        }
    }

    @Override
    public void refreshScrollPosition() {
        this.getGridLienzoScrollHandler().refreshScrollPosition();
    }

    @Override
    public void setBounds(Bounds bounds) {
        this.getGridLienzoScrollHandler().setBounds(bounds);
    }

    public LienzoPanel add(DefaultGridLayer layer) {
        this.defaultGridLayer = this.setupDefaultGridLayer(layer);
        layer.setDomElementContainer(this.domElementContainer);
        this.lienzoPanel.add((Layer)this.defaultGridLayer);
        return this.lienzoPanel;
    }

    private DefaultGridLayer setupDefaultGridLayer(DefaultGridLayer layer) {
        layer.addOnEnterPinnedModeCommand(this::refreshScrollPosition);
        layer.addOnExitPinnedModeCommand(this::refreshScrollPosition);
        return layer;
    }

    public final Viewport getViewport() {
        return this.lienzoPanel.getViewport();
    }

    public LienzoPanel getLienzoPanel() {
        return this.lienzoPanel;
    }

    public AbsolutePanel getMainPanel() {
        return this.mainPanel;
    }

    public AbsolutePanel getDomElementContainer() {
        return this.domElementContainer;
    }

    public AbsolutePanel getInternalScrollPanel() {
        return this.internalScrollPanel;
    }

    public DefaultGridLayer getDefaultGridLayer() {
        return this.defaultGridLayer;
    }

    GridLienzoScrollHandler getGridLienzoScrollHandler() {
        return this.gridLienzoScrollHandler;
    }
}

