/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl;

import com.ait.lienzo.client.core.mediator.IMediator;
import com.ait.lienzo.client.core.mediator.Mediators;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Transform;
import com.google.gwt.user.client.Command;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.animation.GridWidgetEnterPinnedModeAnimation;
import org.uberfire.ext.wires.core.grids.client.widget.grid.animation.GridWidgetExitPinnedModeAnimation;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.TransformMediator;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl.GridTransformMediator;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl.RestrictedMousePanMediator;

public class DefaultPinnedModeManager
implements GridPinnedModeManager {
    private final GridLayer gridLayer;
    private final List<Command> onEnterPinnedModeCommands = new ArrayList<Command>();
    private final List<Command> onExitPinnedModeCommands = new ArrayList<Command>();
    private GridPinnedModeManager.PinnedContext context = null;

    public DefaultPinnedModeManager(GridLayer gridLayer) {
        this.gridLayer = (GridLayer)PortablePreconditions.checkNotNull((String)"gridLayer", (Object)gridLayer);
    }

    @Override
    public void enterPinnedMode(GridWidget gridWidget, Command onStartCommand) {
        if (this.context != null) {
            return;
        }
        Transform transform = gridWidget.getViewport().getTransform();
        double translateX = transform.getTranslateX();
        double translateY = transform.getTranslateY();
        double scaleX = transform.getScaleX();
        double scaleY = transform.getScaleY();
        GridPinnedModeManager.PinnedContext newState = new GridPinnedModeManager.PinnedContext(gridWidget, translateX, translateY, scaleX, scaleY);
        HashSet<GridWidget> gridWidgetsToFadeFromView = new HashSet<GridWidget>(this.gridLayer.getGridWidgets());
        gridWidgetsToFadeFromView.remove(gridWidget);
        Set<IPrimitive<?>> gridWidgetConnectorsToFadeFromView = this.gridLayer.getGridWidgetConnectors();
        this.doEnterPinnedMode(() -> {
            this.context = newState;
            onStartCommand.execute();
            this.enableGridTransformMediator(gridWidget);
        }, gridWidget, gridWidgetsToFadeFromView, gridWidgetConnectorsToFadeFromView);
    }

    protected void doEnterPinnedMode(Command onStartCommand, GridWidget gridWidget, Set<GridWidget> gridWidgetsToFadeFromView, Set<IPrimitive<?>> gridWidgetConnectorsToFadeFromView) {
        GridWidgetEnterPinnedModeAnimation enterAnimation = new GridWidgetEnterPinnedModeAnimation(gridWidget, gridWidgetsToFadeFromView, gridWidgetConnectorsToFadeFromView, onStartCommand, this.onEnterPinnedModeCommands);
        enterAnimation.run();
    }

    @Override
    public void exitPinnedMode(Command onCompleteCommand) {
        if (this.context == null) {
            return;
        }
        HashSet<GridWidget> gridWidgetsToFadeIntoView = new HashSet<GridWidget>(this.gridLayer.getGridWidgets());
        gridWidgetsToFadeIntoView.remove(this.context.getGridWidget());
        Set<IPrimitive<?>> gridWidgetConnectorsToFadeIntoView = this.gridLayer.getGridWidgetConnectors();
        this.doExitPinnedMode(() -> {
            this.context = null;
            onCompleteCommand.execute();
            this.enableDefaultTransformMediator();
        }, gridWidgetsToFadeIntoView, gridWidgetConnectorsToFadeIntoView);
    }

    protected void doExitPinnedMode(Command onCompleteCommand, Set<GridWidget> gridWidgetsToFadeIntoView, Set<IPrimitive<?>> gridWidgetConnectorsToFadeIntoView) {
        GridWidgetExitPinnedModeAnimation exitAnimation = new GridWidgetExitPinnedModeAnimation(this.context, gridWidgetsToFadeIntoView, gridWidgetConnectorsToFadeIntoView, onCompleteCommand, this.onExitPinnedModeCommands);
        exitAnimation.run();
    }

    private void enableGridTransformMediator(GridWidget gridWidget) {
        for (IMediator mediator : this.getMediators()) {
            if (!(mediator instanceof RestrictedMousePanMediator)) continue;
            ((RestrictedMousePanMediator)mediator).setTransformMediator(new GridTransformMediator(gridWidget));
        }
    }

    private void enableDefaultTransformMediator() {
        for (IMediator mediator : this.getMediators()) {
            if (!(mediator instanceof RestrictedMousePanMediator)) continue;
            ((RestrictedMousePanMediator)mediator).setTransformMediator(this.getDefaultTransformMediator());
        }
    }

    private Mediators getMediators() {
        Viewport viewport = this.gridLayer.getViewport();
        Mediators mediators = viewport.getMediators();
        return mediators;
    }

    @Override
    public void updatePinnedContext(GridWidget gridWidget) throws IllegalStateException {
        if (this.context == null) {
            throw new IllegalStateException("'pinned' mode has not been entered.");
        }
        for (IMediator mediator : this.gridLayer.getViewport().getMediators()) {
            if (!(mediator instanceof RestrictedMousePanMediator)) continue;
            ((RestrictedMousePanMediator)mediator).setTransformMediator(new GridTransformMediator(gridWidget));
        }
        Transform transform = gridWidget.getViewport().getTransform();
        double scaleX = this.context.getScaleX();
        double scaleY = this.context.getScaleY();
        double translateX = transform.getTranslateX() * scaleX;
        double translateY = transform.getTranslateY() * scaleY;
        this.context = new GridPinnedModeManager.PinnedContext(gridWidget, translateX, translateY, this.context.getScaleX(), this.context.getScaleY());
    }

    @Override
    public GridPinnedModeManager.PinnedContext getPinnedContext() {
        return this.context;
    }

    @Override
    public boolean isGridPinned() {
        return this.context != null;
    }

    @Override
    public TransformMediator getDefaultTransformMediator() {
        return this.gridLayer.getDefaultTransformMediator();
    }

    @Override
    public void addOnEnterPinnedModeCommand(Command command) {
        this.onEnterPinnedModeCommands.add(command);
    }

    @Override
    public void addOnExitPinnedModeCommand(Command command) {
        this.onExitPinnedModeCommands.add(command);
    }
}

