/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl;

import com.ait.lienzo.client.core.event.NodeMouseDownEvent;
import com.ait.lienzo.client.core.event.NodeMouseMoveEvent;
import com.ait.lienzo.client.core.event.NodeMouseOutEvent;
import com.ait.lienzo.client.core.event.NodeMouseUpEvent;
import com.ait.lienzo.client.core.mediator.AbstractMediator;
import com.ait.lienzo.client.core.mediator.IEventFilter;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.client.core.types.Transform;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.shared.GwtEvent;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.TransformMediator;

public class RestrictedMousePanMediator
extends AbstractMediator {
    private GridLayer gridLayer;
    private TransformMediator transformMediator;
    private Point2D m_last = new Point2D();
    private boolean m_dragging = false;
    private Transform m_inverseTransform = null;

    public RestrictedMousePanMediator(GridLayer gridLayer) {
        this.gridLayer = gridLayer;
    }

    protected RestrictedMousePanMediator() {
    }

    public boolean isDragging() {
        return this.m_dragging;
    }

    public TransformMediator getTransformMediator() {
        return this.transformMediator;
    }

    public void setTransformMediator(TransformMediator transformMediator) {
        this.transformMediator = transformMediator;
    }

    public void cancel() {
        this.m_dragging = false;
        this.setCursor(Style.Cursor.DEFAULT);
    }

    protected void setCursor(Style.Cursor cursor) {
        this.getLayerViewport().getElement().getStyle().setCursor(cursor);
    }

    protected Viewport getLayerViewport() {
        return this.getGridLayer().getViewport();
    }

    GridLayer getGridLayer() {
        return this.gridLayer;
    }

    public boolean handleEvent(GwtEvent<?> event) {
        if (event.getAssociatedType() == NodeMouseMoveEvent.getType()) {
            if (this.m_dragging) {
                this.onMouseMove((NodeMouseMoveEvent)event);
            }
            return false;
        }
        if (event.getAssociatedType() == NodeMouseDownEvent.getType()) {
            IEventFilter filter = this.getEventFilter();
            if (null == filter || !filter.isEnabled() || filter.test(event)) {
                this.onMouseDown((NodeMouseDownEvent)event);
            }
            return false;
        }
        if (event.getAssociatedType() == NodeMouseUpEvent.getType()) {
            if (this.m_dragging) {
                this.onMouseUp((NodeMouseUpEvent)event);
            }
        } else if (event.getAssociatedType() == NodeMouseOutEvent.getType()) {
            this.cancel();
        }
        return false;
    }

    protected void onMouseDown(NodeMouseDownEvent event) {
        this.m_last = new Point2D((double)event.getX(), (double)event.getY());
        this.m_dragging = true;
        Transform transform = this.getTransform();
        if (transform == null) {
            transform = new Transform();
            this.setTransform(transform);
        }
        this.m_inverseTransform = transform.getInverse();
        this.m_inverseTransform.transform(this.m_last, this.m_last);
        this.setCursor(Style.Cursor.MOVE);
    }

    protected void onMouseMove(NodeMouseMoveEvent event) {
        Point2D curr = new Point2D((double)event.getX(), (double)event.getY());
        this.m_inverseTransform.transform(curr, curr);
        double deltaX = curr.getX() - this.m_last.getX();
        double deltaY = curr.getY() - this.m_last.getY();
        Transform newTransform = this.getTransform().copy().translate(deltaX, deltaY);
        if (this.transformMediator != null) {
            newTransform = this.transformMediator.adjust(newTransform, this.gridLayer.getVisibleBounds());
        }
        this.setTransform(newTransform);
        this.m_last = curr;
        if (this.isBatchDraw()) {
            this.getViewport().getScene().batch();
        } else {
            this.getViewport().getScene().draw();
        }
    }

    protected void onMouseUp(NodeMouseUpEvent event) {
        this.cancel();
    }
}

