/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.demo;

import com.ait.lienzo.client.core.mediator.IMediator;
import com.ait.lienzo.client.core.types.Transform;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.gwtbootstrap3.client.ui.ListBox;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.ext.wires.core.grids.client.demo.WiresGridsDemoView;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.themes.GridRendererTheme;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.themes.impl.BlueTheme;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.themes.impl.GreenTheme;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.themes.impl.MultiColouredTheme;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.themes.impl.RedTheme;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.DefaultGridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLienzoPanel;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl.BoundaryTransformMediator;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl.RestrictedMousePanMediator;

@Dependent
@Templated
public class WiresGridsDemoViewImpl
extends Composite
implements WiresGridsDemoView {
    private static final double VP_SCALE = 1.0;
    private final DefaultGridLayer gridLayer = new DefaultGridLayer();
    private final RestrictedMousePanMediator mousePanMediator = new RestrictedMousePanMediator(this.gridLayer);
    private final Map<String, GridRendererTheme> themes = new HashMap<String, GridRendererTheme>();
    @DataField(value="gridPanel")
    GridLienzoPanel gridPanel = new GridLienzoPanel(200, 200);
    @DataField(value="zoom")
    ListBox zoom;
    @DataField(value="basicRendererSelector")
    ListBox basicRendererSelector;
    @DataField(value="chkShowMerged")
    CheckBox chkShowMerged;
    @DataField(value="btnAppendRow")
    Button btnAppendRow;
    @DataField(value="btnDeleteRow")
    Button btnDeleteRow;
    private TranslationService translationService;

    @Inject
    public WiresGridsDemoViewImpl(ListBox zoom, ListBox basicRendererSelector, CheckBox chkShowMerged, Button btnAppendRow, Button btnDeleteRow, TranslationService translationService) {
        this.zoom = zoom;
        this.basicRendererSelector = basicRendererSelector;
        this.chkShowMerged = chkShowMerged;
        this.btnAppendRow = btnAppendRow;
        this.btnDeleteRow = btnDeleteRow;
        this.translationService = translationService;
    }

    @PostConstruct
    public void setup() {
        this.setupCanvas();
        this.setupZoomSelector();
        this.setupStyleSelector();
        this.chkShowMerged.setText(this.translationService.getTranslation("Options.ShowMerged"));
        this.btnAppendRow.setText(this.translationService.getTranslation("Options.AppendRow"));
        this.btnDeleteRow.setText(this.translationService.getTranslation("Options.DeleteRow"));
    }

    private void setupCanvas() {
        this.mousePanMediator.setBatchDraw(true);
        this.mousePanMediator.setTransformMediator(new BoundaryTransformMediator());
        this.gridPanel.getViewport().getMediators().push((IMediator)this.mousePanMediator);
        Transform transform = new Transform().scale(1.0);
        this.gridPanel.getViewport().setTransform(transform);
        this.gridPanel.add(this.gridLayer);
    }

    private void setupZoomSelector() {
        for (int pct = 50; pct <= 150; pct += 10) {
            this.zoom.addItem(Integer.toString(pct));
        }
        this.zoom.setSelectedIndex(5);
    }

    private void setupStyleSelector() {
        RedTheme redRenderer = new RedTheme();
        GreenTheme greenRenderer = new GreenTheme();
        BlueTheme blueRenderer = new BlueTheme();
        MultiColouredTheme multiColouredTheme = new MultiColouredTheme();
        this.themes.put(redRenderer.getName(), redRenderer);
        this.themes.put(greenRenderer.getName(), greenRenderer);
        this.themes.put(blueRenderer.getName(), blueRenderer);
        this.themes.put(multiColouredTheme.getName(), multiColouredTheme);
        for (String name : this.themes.keySet()) {
            this.basicRendererSelector.addItem(name);
        }
    }

    @Override
    public void select(GridWidget selectedGridWidget) {
        this.gridLayer.select(selectedGridWidget);
    }

    @Override
    public void selectLinkedColumn(GridColumn<?> selectedGridColumn) {
        this.gridLayer.selectLinkedColumn(selectedGridColumn);
    }

    @Override
    public Set<GridWidget> getGridWidgets() {
        return this.gridLayer.getGridWidgets();
    }

    @Override
    public void add(GridWidget gridWidget) {
        this.gridLayer.add(gridWidget);
    }

    @Override
    public void refresh() {
        this.gridLayer.batch();
        this.gridPanel.refreshScrollPosition();
    }

    @Override
    public GridLayer getGridLayer() {
        return this.gridLayer;
    }

    @Override
    public GridLienzoPanel getGridPanel() {
        return this.gridPanel;
    }

    public HandlerRegistration addKeyDownHandler(KeyDownHandler handler) {
        return this.gridPanel.addDomHandler((EventHandler)handler, KeyDownEvent.getType());
    }

    @Override
    public HandlerRegistration addZoomChangeHandler(ChangeHandler handler) {
        return this.zoom.addChangeHandler(handler);
    }

    @Override
    public int getSelectedZoomLevel() {
        int selectedIndex = this.zoom.getSelectedIndex();
        int pct = Integer.parseInt(this.zoom.getValue(selectedIndex));
        return pct;
    }

    @Override
    public void setZoom(int zoom) {
        Transform transform = new Transform();
        double tx = this.gridPanel.getViewport().getTransform().getTranslateX();
        double ty = this.gridPanel.getViewport().getTransform().getTranslateY();
        transform.translate(tx, ty);
        transform.scale((double)zoom / 100.0);
        this.gridPanel.getViewport().setTransform(transform);
        this.gridPanel.getViewport().batch();
        this.gridPanel.refreshScrollPosition();
    }

    @Override
    public HandlerRegistration addThemeChangeHandler(ChangeHandler handler) {
        return this.basicRendererSelector.addChangeHandler(handler);
    }

    @Override
    public GridRendererTheme getSelectedTheme() {
        GridRendererTheme theme = this.themes.get(this.basicRendererSelector.getItemText(this.basicRendererSelector.getSelectedIndex()));
        return theme;
    }

    @Override
    public HandlerRegistration addMergedStateValueChangeHandler(ValueChangeHandler<Boolean> handler) {
        return this.chkShowMerged.addValueChangeHandler(handler);
    }

    @Override
    public void setMergedState(boolean isMerged) {
        this.chkShowMerged.setValue(Boolean.valueOf(isMerged));
    }

    @Override
    public HandlerRegistration addAppendRowClickHandler(ClickHandler handler) {
        return this.btnAppendRow.addClickHandler(handler);
    }

    @Override
    public HandlerRegistration addDeleteRowClickHandler(ClickHandler handler) {
        return this.btnDeleteRow.addClickHandler(handler);
    }

    public void onResize() {
        this.gridPanel.onResize();
    }
}

