/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridDataIndexManager;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridDataSelectionsManager;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.dom.HasDOMElementResources;

public class BaseGridData
implements GridData {
    protected boolean isMerged = true;
    protected boolean isRowDraggingEnabled = true;
    protected boolean isColumnDraggingEnabled = true;
    protected List<GridRow> rows = new ArrayList<GridRow>();
    protected List<GridColumn<?>> columns = new ArrayList();
    protected List<GridData.SelectedCell> selectedCells = new ArrayList<GridData.SelectedCell>();
    protected int headerRowCount = 1;
    protected BaseGridDataIndexManager indexManager = new BaseGridDataIndexManager(this);
    protected BaseGridDataSelectionsManager selectionsManager = new BaseGridDataSelectionsManager(this);

    public BaseGridData() {
        this(true);
    }

    public BaseGridData(boolean isMerged) {
        this.isMerged = isMerged;
    }

    @Override
    public List<GridColumn<?>> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public void appendColumn(GridColumn<?> column) {
        column.setIndex(this.columns.size());
        this.columns.add(column);
    }

    @Override
    public void insertColumn(int index, GridColumn<?> column) {
        column.setIndex(this.columns.size());
        this.columns.add(index, column);
    }

    @Override
    public void deleteColumn(GridColumn<?> column) {
        int index = column.getIndex();
        for (GridColumn<?> c : this.columns) {
            if (c.getIndex() <= index) continue;
            c.setIndex(c.getIndex() - 1);
        }
        if (column.getColumnRenderer() instanceof HasDOMElementResources) {
            ((HasDOMElementResources)((Object)column.getColumnRenderer())).destroyResources();
        }
        this.removeColumn(column);
        for (GridRow row : this.rows) {
            ((BaseGridRow)row).deleteCell(index);
            HashMap clone = new HashMap(row.getCells());
            for (Map.Entry e : clone.entrySet()) {
                if ((Integer)e.getKey() <= index) continue;
                ((BaseGridRow)row).deleteCell((Integer)e.getKey());
                ((BaseGridRow)row).setCell((Integer)e.getKey() - 1, ((GridCell)e.getValue()).getValue());
            }
        }
        this.selectionsManager.onDeleteColumn(index);
    }

    void removeColumn(GridColumn<?> column) {
        IntStream indexes = IntStream.range(0, this.columns.size());
        OptionalInt columnIndex = indexes.filter(i -> column == this.columns.get(i)).findFirst();
        if (columnIndex.isPresent()) {
            this.columns.remove(columnIndex.getAsInt());
        } else {
            this.columns.remove(column);
        }
    }

    @Override
    public void moveColumnTo(int index, final GridColumn<?> column) {
        this.moveColumnsTo(index, new ArrayList<GridColumn<?>>(){
            {
                this.add(column);
            }
        });
    }

    @Override
    public void moveColumnsTo(int index, List<GridColumn<?>> columns) {
        if (columns == null || columns.isEmpty()) {
            return;
        }
        int currentIndex = this.columns.indexOf(columns.get(0));
        if (index < currentIndex) {
            this.columns.removeAll(columns);
            this.columns.addAll(index, columns);
        }
        if (index > currentIndex) {
            this.columns.removeAll(columns);
            this.columns.addAll(index - columns.size() + 1, columns);
        }
    }

    @Override
    public List<GridRow> getRows() {
        return Collections.unmodifiableList(this.rows);
    }

    @Override
    public GridRow getRow(int rowIndex) {
        return this.rows.get(rowIndex);
    }

    @Override
    public void appendRow(GridRow row) {
        this.rows.add(row);
    }

    @Override
    public void insertRow(int rowIndex, GridRow row) {
        this.rows.add(rowIndex, row);
        this.indexManager.onInsertRow(rowIndex);
        this.selectionsManager.onInsertRow(rowIndex);
    }

    @Override
    public GridData.Range deleteRow(int rowIndex) {
        GridRow row;
        int minRowIndex;
        int maxRowIndex = rowIndex;
        for (minRowIndex = rowIndex; (row = this.rows.get(minRowIndex)).isMerged() && row.isCollapsed() && minRowIndex > 0; --minRowIndex) {
        }
        while (++maxRowIndex < this.rows.size() && this.rows.get(maxRowIndex).isCollapsed()) {
        }
        GridData.Range range = new GridData.Range(minRowIndex, --maxRowIndex);
        for (int _rowIndex = minRowIndex; _rowIndex <= maxRowIndex; ++_rowIndex) {
            this.rows.remove(minRowIndex);
        }
        this.indexManager.onDeleteRow(range);
        this.selectionsManager.onDeleteRow(range);
        return range;
    }

    @Override
    public void moveRowTo(int index, final GridRow row) {
        this.moveRowsTo(index, (List<GridRow>)new ArrayList<GridRow>(){
            {
                this.add(row);
            }
        });
    }

    @Override
    public void moveRowsTo(int index, List<GridRow> rows) {
        if (rows == null || rows.isEmpty()) {
            return;
        }
        int oldBlockStart = this.rows.indexOf(rows.get(0));
        int oldBlockEnd = this.rows.indexOf(rows.get(rows.size() - 1));
        if (index == oldBlockStart) {
            return;
        }
        this.rows.removeAll(rows);
        if (index < oldBlockStart) {
            this.rows.addAll(index, rows);
        } else if (index > oldBlockStart) {
            this.rows.addAll(index - rows.size() + 1, rows);
        }
        GridData.Range oldBlockExtent = new GridData.Range(oldBlockStart, oldBlockEnd);
        this.indexManager.onMoveRows(rows, oldBlockExtent);
        this.selectionsManager.onMoveRows(rows, oldBlockExtent);
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getHeaderRowCount() {
        return this.headerRowCount;
    }

    @Override
    public void setHeaderRowCount(int headerRowCount) {
        PortablePreconditions.checkCondition((String)"headerRowCount", (headerRowCount > 0 ? 1 : 0) != 0);
        this.headerRowCount = headerRowCount;
    }

    @Override
    public GridCell<?> getCell(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex > this.rows.size() - 1) {
            return null;
        }
        int _columnIndex = this.columns.get(columnIndex).getIndex();
        return this.rows.get(rowIndex).getCells().get(_columnIndex);
    }

    @Override
    public GridData.SelectedCell getSelectedCellsOrigin() {
        return this.selectedCells.isEmpty() ? null : this.selectedCells.get(0);
    }

    @Override
    public List<GridData.SelectedCell> getSelectedCells() {
        return this.selectedCells;
    }

    @Override
    public void clearSelections() {
        this.selectedCells.clear();
    }

    @Override
    public void updateColumn(int index, GridColumn<?> column) {
        GridColumn<?> existing = this.columns.get(index);
        if (existing.getColumnRenderer() instanceof HasDOMElementResources) {
            ((HasDOMElementResources)((Object)existing.getColumnRenderer())).destroyResources();
        }
        column.setIndex(this.columns.get(index).getIndex());
        this.columns.set(index, column);
        for (GridRow row : this.rows) {
            ((BaseGridRow)row).deleteCell(column.getIndex());
        }
    }

    @Override
    public boolean isMerged() {
        return this.isMerged;
    }

    @Override
    public void setMerged(boolean isMerged) {
        if (this.isMerged == isMerged) {
            return;
        }
        this.isMerged = isMerged;
        this.indexManager.onMerge(isMerged);
        this.selectionsManager.onMerge(isMerged);
    }

    @Override
    public boolean isRowDraggingEnabled() {
        return this.isRowDraggingEnabled;
    }

    @Override
    public void setRowDraggingEnabled(boolean enabled) {
        this.isRowDraggingEnabled = enabled;
    }

    @Override
    public boolean isColumnDraggingEnabled() {
        return this.isColumnDraggingEnabled;
    }

    @Override
    public void setColumnDraggingEnabled(boolean enabled) {
        this.isColumnDraggingEnabled = enabled;
    }

    @Override
    public GridData.Range setCell(int rowIndex, int columnIndex, GridCellValue<?> value) {
        if (rowIndex < 0 || rowIndex > this.rows.size() - 1) {
            return new GridData.Range(rowIndex);
        }
        if (columnIndex < 0 || columnIndex > this.columns.size() - 1) {
            return new GridData.Range(rowIndex);
        }
        if (value == null) {
            return new GridData.Range(rowIndex);
        }
        int _columnIndex = this.columns.get(columnIndex).getIndex();
        if (!this.isMerged) {
            ((BaseGridRow)this.rows.get(rowIndex)).setCell(_columnIndex, value);
            return new GridData.Range(rowIndex);
        }
        int minRowIndex = this.findMinRowIndexForCellUpdate(rowIndex, _columnIndex);
        int maxRowIndex = this.findMaxRowIndexForCellUpdate(rowIndex, _columnIndex);
        GridData.Range range = new GridData.Range(minRowIndex, maxRowIndex);
        for (int i = minRowIndex; i <= maxRowIndex; ++i) {
            GridRow row = this.rows.get(i);
            ((BaseGridRow)row).setCell(_columnIndex, value);
        }
        this.indexManager.onSetCell(range, _columnIndex);
        return range;
    }

    @Override
    public GridData.Range deleteCell(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex > this.rows.size() - 1) {
            return new GridData.Range(rowIndex);
        }
        if (columnIndex < 0 || columnIndex > this.columns.size() - 1) {
            return new GridData.Range(rowIndex);
        }
        int _columnIndex = this.columns.get(columnIndex).getIndex();
        if (!this.isMerged) {
            ((BaseGridRow)this.rows.get(rowIndex)).deleteCell(_columnIndex);
            return new GridData.Range(rowIndex);
        }
        int minRowIndex = this.findMinRowIndexForCellUpdate(rowIndex, _columnIndex);
        int maxRowIndex = this.findMaxRowIndexForCellUpdate(rowIndex, _columnIndex);
        GridData.Range range = new GridData.Range(minRowIndex, maxRowIndex);
        for (int i = minRowIndex; i <= maxRowIndex; ++i) {
            GridRow row = this.rows.get(i);
            ((BaseGridRow)row).deleteCell(_columnIndex);
            row.expand();
        }
        this.indexManager.onDeleteCell(range, _columnIndex);
        return range;
    }

    @Override
    public GridData.Range selectCell(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex > this.rows.size() - 1) {
            return new GridData.Range(rowIndex);
        }
        if (columnIndex < 0 || columnIndex > this.columns.size() - 1) {
            return new GridData.Range(rowIndex);
        }
        return this.selectionsManager.onSelectCell(rowIndex, columnIndex);
    }

    @Override
    public GridData.Range selectCells(int rowIndex, int columnIndex, int width, int height) {
        if (rowIndex < 0 || rowIndex > this.rows.size() - 1) {
            return new GridData.Range(rowIndex);
        }
        if (columnIndex < 0 || columnIndex > this.columns.size() - 1) {
            return new GridData.Range(rowIndex);
        }
        return this.selectionsManager.onSelectCells(rowIndex, columnIndex, width, height);
    }

    @Override
    public void collapseCell(int rowIndex, int columnIndex) {
        if (!this.isMerged) {
            return;
        }
        int _columnIndex = this.columns.get(columnIndex).getIndex();
        GridRow row = this.rows.get(rowIndex);
        GridCell<?> cell = row.getCells().get(_columnIndex);
        if (cell == null) {
            return;
        }
        if (!cell.isMerged()) {
            return;
        }
        this.indexManager.onCollapseCell(rowIndex, _columnIndex);
    }

    @Override
    public void expandCell(int rowIndex, int columnIndex) {
        if (!this.isMerged) {
            return;
        }
        int _columnIndex = this.columns.get(columnIndex).getIndex();
        GridRow row = this.rows.get(rowIndex);
        GridCell<?> cell = row.getCells().get(_columnIndex);
        if (cell == null) {
            return;
        }
        this.indexManager.onExpandCell(rowIndex, _columnIndex);
    }

    private int findMinRowIndexForCellUpdate(int rowIndex, int columnIndex) {
        int minRowIndex;
        boolean foundTopSplitMarker;
        GridRow currentRow = this.getRow(rowIndex);
        GridCell<?> currentRowCell = currentRow.getCells().get(columnIndex);
        boolean bl = foundTopSplitMarker = currentRowCell != null && currentRowCell.getMergedCellCount() > 0;
        for (minRowIndex = rowIndex; minRowIndex > 0; --minRowIndex) {
            GridRow previousRow = this.rows.get(minRowIndex - 1);
            GridCell<?> previousRowCell = previousRow.getCells().get(columnIndex);
            if (previousRow.isCollapsed() && currentRow.isCollapsed()) continue;
            if (previousRowCell == null || previousRowCell.isCollapsed() && foundTopSplitMarker || !previousRowCell.equals(currentRowCell)) break;
            if (previousRowCell.getMergedCellCount() <= 0) continue;
            foundTopSplitMarker = true;
        }
        return minRowIndex;
    }

    private int findMaxRowIndexForCellUpdate(int rowIndex, int columnIndex) {
        int maxRowIndex;
        GridRow currentRow = this.getRow(rowIndex);
        GridCell<?> currentRowCell = currentRow.getCells().get(columnIndex);
        boolean foundBottomSplitMarker = false;
        for (maxRowIndex = rowIndex + 1; maxRowIndex < this.rows.size(); ++maxRowIndex) {
            GridRow nextRow = this.rows.get(maxRowIndex);
            GridCell<?> nextRowCell = nextRow.getCells().get(columnIndex);
            if (nextRow.isCollapsed()) continue;
            if (nextRowCell == null) break;
            if (nextRowCell.isCollapsed() && foundBottomSplitMarker) {
                --maxRowIndex;
                break;
            }
            if (!nextRowCell.equals(currentRowCell)) break;
            if (nextRowCell.getMergedCellCount() <= 0) continue;
            foundBottomSplitMarker = true;
        }
        return maxRowIndex - 1;
    }
}

