/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.selections;

import java.io.Serializable;

public enum SelectionExtension {
    LEFT((min, max, origin) -> {
        if (max > origin) {
            return max - 1;
        }
        return min - 1;
    }, (min, max, origin) -> {
        if (max > origin) {
            return max;
        }
        return min;
    }, -1, 0),
    RIGHT((min, max, origin) -> {
        if (min < origin) {
            return min + 1;
        }
        return max + 1;
    }, (min, max, origin) -> {
        if (max > origin) {
            return max;
        }
        return min;
    }, 1, 0),
    UP((min, max, origin) -> {
        if (max > origin) {
            return max;
        }
        return min;
    }, (min, max, origin) -> {
        if (max > origin) {
            return max - 1;
        }
        return min - 1;
    }, 0, -1),
    DOWN((min, max, origin) -> {
        if (max > origin) {
            return max;
        }
        return min;
    }, (min, max, origin) -> {
        if (min < origin) {
            return min + 1;
        }
        return max + 1;
    }, 0, 1);

    private NextIndexCalculator nextXCalculator;
    private NextIndexCalculator nextYCalculator;
    private int deltaX;
    private int deltaY;

    private SelectionExtension(NextIndexCalculator nextXCalculator, NextIndexCalculator nextYCalculator, int deltaX, int deltaY) {
        this.nextXCalculator = nextXCalculator;
        this.nextYCalculator = nextYCalculator;
        this.deltaX = deltaX;
        this.deltaY = deltaY;
    }

    public int getNextX(int minIndex, int maxIndex, int originIndex) {
        return this.nextXCalculator.getNext(minIndex, maxIndex, originIndex);
    }

    public int getNextY(int minIndex, int maxIndex, int originIndex) {
        return this.nextYCalculator.getNext(minIndex, maxIndex, originIndex);
    }

    public int getDeltaX() {
        return this.deltaX;
    }

    public int getDeltaY() {
        return this.deltaY;
    }

    private static interface NextIndexCalculator
    extends Serializable {
        public int getNext(int var1, int var2, int var3);
    }
}

