/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.scrollbars;

import com.ait.lienzo.client.core.event.NodeMouseMoveEvent;
import com.ait.lienzo.client.core.mediator.IMediator;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Transform;
import com.ait.lienzo.client.widget.LienzoPanel;
import com.google.gwt.event.dom.client.ScrollEvent;
import com.google.gwt.event.dom.client.ScrollHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.ui.AbsolutePanel;
import java.util.Optional;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.DefaultGridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLienzoPanel;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl.RestrictedMousePanMediator;
import org.uberfire.ext.wires.core.grids.client.widget.scrollbars.GridLienzoScrollBars;
import org.uberfire.ext.wires.core.grids.client.widget.scrollbars.GridLienzoScrollBounds;
import org.uberfire.ext.wires.core.grids.client.widget.scrollbars.GridLienzoScrollPosition;
import org.uberfire.ext.wires.core.grids.client.widget.scrollbars.GridLienzoScrollUI;

public class GridLienzoScrollHandler {
    private final GridLienzoPanel panel;
    private final GridLienzoScrollBounds gridLienzoScrollBounds;
    static final int DEFAULT_INTERNAL_SCROLL_HEIGHT = 1;
    static final int DEFAULT_INTERNAL_SCROLL_WIDTH = 1;
    private RestrictedMousePanMediator mousePanMediator;

    public GridLienzoScrollHandler(GridLienzoPanel panel) {
        this.panel = panel;
        this.gridLienzoScrollBounds = new GridLienzoScrollBounds(this);
    }

    public void init() {
        this.setupGridLienzoScrollStyle();
        this.setupScrollBarSynchronization();
        this.setupMouseDragSynchronization();
    }

    public Integer scrollbarWidth() {
        return this.getMainPanel().getElement().getOffsetWidth() - this.getMainPanel().getElement().getClientWidth();
    }

    public Integer scrollbarHeight() {
        return this.getMainPanel().getElement().getOffsetHeight() - this.getMainPanel().getElement().getClientHeight();
    }

    void setupGridLienzoScrollStyle() {
        this.gridLienzoScrollUI().setup();
    }

    GridLienzoScrollUI gridLienzoScrollUI() {
        return new GridLienzoScrollUI(this);
    }

    void setupScrollBarSynchronization() {
        this.getMainPanel().addDomHandler((EventHandler)this.onScroll(), ScrollEvent.getType());
        this.synchronizeScrollSize();
    }

    void setupMouseDragSynchronization() {
        this.mousePanMediator = this.makeRestrictedMousePanMediator();
        this.getLienzoPanel().getViewport().getMediators().push((IMediator)this.mousePanMediator);
    }

    RestrictedMousePanMediator makeRestrictedMousePanMediator() {
        return new RestrictedMousePanMediator(){

            @Override
            protected void onMouseMove(NodeMouseMoveEvent event) {
                GridLienzoScrollHandler.this.refreshScrollPosition();
            }

            @Override
            protected Viewport getLayerViewport() {
                return this.getViewport();
            }
        };
    }

    ScrollHandler onScroll() {
        return event -> {
            Boolean mouseIsNotDragging = !this.getMousePanMediator().isDragging();
            if (mouseIsNotDragging.booleanValue()) {
                this.updateGridLienzoPosition();
            }
        };
    }

    public void refreshScrollPosition() {
        this.synchronizeScrollSize();
        this.setScrollBarsPosition(this.scrollPosition().currentRelativeX(), this.scrollPosition().currentRelativeY());
    }

    void updateGridLienzoPosition() {
        Double percentageX = this.scrollBars().getHorizontalScrollPosition();
        Double percentageY = this.scrollBars().getVerticalScrollPosition();
        Double currentXPosition = this.scrollPosition().currentPositionX(percentageX);
        Double currentYPosition = this.scrollPosition().currentPositionY(percentageY);
        this.updateGridLienzoTransform(currentXPosition, currentYPosition);
    }

    void updateGridLienzoTransform(Double currentXPosition, Double currentYPosition) {
        Transform oldTransform = this.getViewport().getTransform();
        Double dx = currentXPosition - oldTransform.getTranslateX() / oldTransform.getScaleX();
        Double dy = currentYPosition - oldTransform.getTranslateY() / oldTransform.getScaleY();
        Transform newTransform = oldTransform.copy().translate(dx.doubleValue(), dy.doubleValue());
        this.getViewport().setTransform(newTransform);
        this.getDefaultGridLayer().batch();
    }

    void synchronizeScrollSize() {
        this.getInternalScrollPanel().setPixelSize(this.calculateInternalScrollPanelWidth().intValue(), this.calculateInternalScrollPanelHeight().intValue());
    }

    Integer calculateInternalScrollPanelWidth() {
        Double absWidth = this.scrollBounds().maxBoundX() - this.scrollBounds().minBoundX();
        if (this.getViewport() != null && this.scrollPosition().deltaX() != 0.0) {
            Double scaleX = this.getViewport().getTransform().getScaleX();
            Double width = absWidth * scaleX;
            return width.intValue();
        }
        return 1;
    }

    Integer calculateInternalScrollPanelHeight() {
        Double absHeight = this.scrollBounds().maxBoundY() - this.scrollBounds().minBoundY();
        if (this.getViewport() != null && this.scrollPosition().deltaY() != 0.0) {
            Double scaleY = this.getViewport().getTransform().getScaleY();
            Double height = absHeight * scaleY;
            return height.intValue();
        }
        return 1;
    }

    void setScrollBarsPosition(Double xPercentage, Double yPercentage) {
        this.scrollBars().setHorizontalScrollPosition(xPercentage);
        this.scrollBars().setVerticalScrollPosition(yPercentage);
    }

    RestrictedMousePanMediator getMousePanMediator() {
        return this.mousePanMediator;
    }

    AbsolutePanel getMainPanel() {
        return this.panel.getMainPanel();
    }

    AbsolutePanel getInternalScrollPanel() {
        return this.panel.getInternalScrollPanel();
    }

    AbsolutePanel getDomElementContainer() {
        return this.panel.getDomElementContainer();
    }

    LienzoPanel getLienzoPanel() {
        return this.panel.getLienzoPanel();
    }

    DefaultGridLayer getDefaultGridLayer() {
        return Optional.ofNullable(this.panel.getDefaultGridLayer()).orElse(this.emptyLayer());
    }

    Viewport getViewport() {
        return this.getDefaultGridLayer().getViewport();
    }

    DefaultGridLayer emptyLayer() {
        return new DefaultGridLayer();
    }

    GridLienzoScrollBars scrollBars() {
        return new GridLienzoScrollBars(this);
    }

    GridLienzoScrollPosition scrollPosition() {
        return new GridLienzoScrollPosition(this);
    }

    GridLienzoScrollBounds scrollBounds() {
        return this.gridLienzoScrollBounds;
    }

    public void setBounds(Bounds bounds) {
        this.scrollBounds().setDefaultBounds(bounds);
    }
}

