/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.impl;

import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.dom.single.HasSingletonDOMElementResource;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperation;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;

public class BaseGridWidgetKeyboardHandler
implements KeyDownHandler {
    protected GridLayer gridLayer;
    private Set<KeyboardOperation> operations = new HashSet<KeyboardOperation>();

    public BaseGridWidgetKeyboardHandler(GridLayer gridLayer) {
        this.gridLayer = Objects.requireNonNull(gridLayer, "gridLayer");
    }

    public void addOperation(KeyboardOperation ... operations) {
        for (KeyboardOperation operation : operations) {
            this.operations.add(Objects.requireNonNull(operation, "operation"));
        }
    }

    public void onKeyDown(KeyDownEvent event) {
        GridWidget selectedGridWidget = this.getSelectedGridWidget();
        if (selectedGridWidget == null) {
            return;
        }
        KeyboardOperation operation = this.getOperation(event);
        if (operation == null) {
            return;
        }
        boolean redraw = operation.perform(selectedGridWidget, event.isShiftKeyDown(), event.isControlKeyDown());
        event.preventDefault();
        event.stopPropagation();
        this.flushDOMElements(selectedGridWidget);
        if (redraw) {
            this.gridLayer.draw();
        }
    }

    private KeyboardOperation getOperation(KeyDownEvent event) {
        int keyCode = event.getNativeKeyCode();
        boolean isShiftKeyDown = event.isShiftKeyDown();
        boolean isControlKeyDown = event.isControlKeyDown();
        for (KeyboardOperation operation : this.operations) {
            if (operation.getKeyCode() != keyCode || !this.keyDownStateMatches(isShiftKeyDown, operation.isShiftKeyDown()) || !this.keyDownStateMatches(isControlKeyDown, operation.isControlKeyDown())) continue;
            return operation;
        }
        return null;
    }

    private boolean keyDownStateMatches(boolean actualKeyDownState, KeyboardOperation.TriStateBoolean requiredKeyDownState) {
        if (actualKeyDownState && (requiredKeyDownState == KeyboardOperation.TriStateBoolean.TRUE || requiredKeyDownState == KeyboardOperation.TriStateBoolean.DONT_CARE)) {
            return true;
        }
        return !actualKeyDownState && (requiredKeyDownState == KeyboardOperation.TriStateBoolean.FALSE || requiredKeyDownState == KeyboardOperation.TriStateBoolean.DONT_CARE);
    }

    private void flushDOMElements(GridWidget selectedGridWidget) {
        GridData gridModel = selectedGridWidget.getModel();
        for (GridColumn<?> column : gridModel.getColumns()) {
            if (!(column instanceof HasSingletonDOMElementResource)) continue;
            ((HasSingletonDOMElementResource)((Object)column)).flush();
            ((HasSingletonDOMElementResource)((Object)column)).destroyResources();
        }
    }

    private GridWidget getSelectedGridWidget() {
        for (GridWidget gridWidget : this.gridLayer.getGridWidgets()) {
            if (!gridWidget.isSelected()) continue;
            return gridWidget;
        }
        return null;
    }
}

