/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.model;

import java.util.List;
import java.util.function.Supplier;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;

public interface GridData {
    public List<GridColumn<?>> getColumns();

    public int getColumnCount();

    public void appendColumn(GridColumn<?> var1);

    public void insertColumn(int var1, GridColumn<?> var2);

    public void updateColumn(int var1, GridColumn<?> var2);

    public void deleteColumn(GridColumn<?> var1);

    public void moveColumnTo(int var1, GridColumn<?> var2);

    public void moveColumnsTo(int var1, List<GridColumn<?>> var2);

    public List<GridRow> getRows();

    public GridRow getRow(int var1);

    public void appendRow(GridRow var1);

    public void insertRow(int var1, GridRow var2);

    public Range deleteRow(int var1);

    public void moveRowTo(int var1, GridRow var2);

    public void moveRowsTo(int var1, List<GridRow> var2);

    public int getRowCount();

    public int getHeaderRowCount();

    public void setHeaderRowCount(int var1);

    public GridCell<?> getCell(int var1, int var2);

    public Range setCell(int var1, int var2, Supplier<GridCell<?>> var3);

    public Range setCellValue(int var1, int var2, GridCellValue<?> var3);

    public Range deleteCell(int var1, int var2);

    public Range selectCell(int var1, int var2);

    public Range selectCells(int var1, int var2, int var3, int var4);

    public SelectedCell getSelectedCellsOrigin();

    public List<SelectedCell> getSelectedCells();

    public Range selectHeaderCell(int var1, int var2);

    public List<SelectedCell> getSelectedHeaderCells();

    public void clearSelections();

    public boolean isMerged();

    public void setMerged(boolean var1);

    public boolean isRowDraggingEnabled();

    public void setRowDraggingEnabled(boolean var1);

    public boolean isColumnDraggingEnabled();

    public void setColumnDraggingEnabled(boolean var1);

    public void collapseCell(int var1, int var2);

    public void expandCell(int var1, int var2);

    public static class SelectedCell {
        private final int rowIndex;
        private final int columnIndex;

        public SelectedCell(int rowIndex, int columnIndex) {
            this.rowIndex = rowIndex;
            this.columnIndex = columnIndex;
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SelectedCell)) {
                return false;
            }
            SelectedCell that = (SelectedCell)o;
            if (this.rowIndex != that.rowIndex) {
                return false;
            }
            return this.columnIndex == that.columnIndex;
        }

        public int hashCode() {
            int result = this.rowIndex;
            result = ~(~result);
            result = 31 * result + this.columnIndex;
            result = ~(~result);
            return result;
        }
    }

    public static class Range {
        private int minRowIndex;
        private int maxRowIndex;

        public Range(int rowIndex) {
            this(rowIndex, rowIndex);
        }

        public Range(int minRowIndex, int maxRowIndex) {
            this.minRowIndex = minRowIndex;
            this.maxRowIndex = maxRowIndex;
        }

        public int getMinRowIndex() {
            return this.minRowIndex;
        }

        public int getMaxRowIndex() {
            return this.maxRowIndex;
        }
    }
}

