/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.util;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.client.core.types.Transform;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;

public class CoordinateUtilities {
    public static Point2D convertDOMToGridCoordinate(GridWidget view, Point2D point) {
        Transform transform;
        Viewport viewport = view.getViewport();
        Transform transform2 = transform = viewport != null ? viewport.getTransform() : null;
        if (transform == null) {
            transform = new Transform();
        }
        if (viewport != null) {
            view.getViewport().setTransform(transform);
        }
        transform = transform.copy().getInverse();
        Point2D p = new Point2D(point.getX(), point.getY());
        transform.transform(p, p);
        return p.add(new Point2D(view.getAbsoluteX(), view.getAbsoluteY()).mul(-1.0));
    }

    public static Integer getUiRowIndex(GridWidget gridWidget, double relativeY) {
        double headerMaxY;
        Group header = gridWidget.getHeader();
        GridData gridModel = gridWidget.getModel();
        GridRenderer renderer = gridWidget.getRenderer();
        double d = headerMaxY = header == null ? renderer.getHeaderHeight() : renderer.getHeaderHeight() + header.getY();
        if (relativeY < headerMaxY || relativeY > gridWidget.getHeight()) {
            return null;
        }
        if (gridModel.getRowCount() == 0) {
            return null;
        }
        int uiRowIndex = 0;
        double offsetY = relativeY - renderer.getHeaderHeight();
        while (true) {
            GridRow gridRow;
            GridRow row = gridModel.getRow(uiRowIndex);
            if (!(gridRow.getHeight() < offsetY)) break;
            offsetY -= row.getHeight();
            ++uiRowIndex;
        }
        if (uiRowIndex > gridModel.getRowCount() - 1) {
            return null;
        }
        return uiRowIndex;
    }

    public static Integer getUiColumnIndex(GridWidget gridWidget, double relativeX) {
        GridData gridModel = gridWidget.getModel();
        BaseGridRendererHelper rendererHelper = gridWidget.getRendererHelper();
        if (relativeX < 0.0 || relativeX > gridWidget.getWidth()) {
            return null;
        }
        BaseGridRendererHelper.ColumnInformation ci = rendererHelper.getColumnInformation(relativeX);
        GridColumn<?> uiColumn = ci.getColumn();
        int uiColumnIndex = ci.getUiColumnIndex();
        if (uiColumn == null) {
            return null;
        }
        if (uiColumnIndex < 0 || uiColumnIndex > gridModel.getColumnCount() - 1) {
            return null;
        }
        return uiColumnIndex;
    }

    public static Integer getUiHeaderRowIndex(GridWidget gridWidget, Point2D rp) {
        double headerMaxY;
        double relativeX = rp.getX();
        double relativeY = rp.getY();
        Group header = gridWidget.getHeader();
        GridRenderer renderer = gridWidget.getRenderer();
        BaseGridRendererHelper.RenderingInformation ri = gridWidget.getRendererHelper().getRenderingInformation();
        double headerRowsYOffset = ri.getHeaderRowsYOffset();
        double headerMinY = header == null ? headerRowsYOffset : header.getY() + headerRowsYOffset;
        double d = headerMaxY = header == null ? renderer.getHeaderHeight() : renderer.getHeaderHeight() + header.getY();
        if (relativeX < 0.0 || relativeX > gridWidget.getWidth()) {
            return null;
        }
        if (relativeY < headerMinY || relativeY > headerMaxY) {
            return null;
        }
        BaseGridRendererHelper rendererHelper = gridWidget.getRendererHelper();
        BaseGridRendererHelper.ColumnInformation ci = rendererHelper.getColumnInformation(relativeX);
        GridColumn<?> uiColumn = ci.getColumn();
        if (uiColumn == null) {
            return null;
        }
        int uiHeaderRowIndex = 0;
        double offsetY = relativeY - headerMinY;
        double headerRowHeight = renderer.getHeaderRowHeight();
        double headerRowsHeight = headerRowHeight * (double)gridWidget.getModel().getHeaderRowCount();
        double columnHeaderRowHeight = headerRowsHeight / (double)uiColumn.getHeaderMetaData().size();
        while (columnHeaderRowHeight < offsetY) {
            offsetY -= columnHeaderRowHeight;
            ++uiHeaderRowIndex;
        }
        if (uiHeaderRowIndex < 0 || uiHeaderRowIndex > uiColumn.getHeaderMetaData().size() - 1) {
            return null;
        }
        return uiHeaderRowIndex;
    }
}

