/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.impl;

import com.ait.lienzo.client.core.event.NodeMouseClickEvent;
import com.ait.lienzo.client.core.event.NodeMouseClickHandler;
import com.ait.lienzo.client.core.types.Point2D;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.util.CoordinateUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;

public class GridCellSelectorMouseClickHandler
implements NodeMouseClickHandler {
    protected GridData gridModel;
    protected GridWidget gridWidget;
    protected BaseGridRendererHelper rendererHelper;
    protected GridSelectionManager selectionManager;
    protected GridRenderer renderer;

    public GridCellSelectorMouseClickHandler(GridWidget gridWidget, GridSelectionManager selectionManager, GridRenderer renderer) {
        this.gridWidget = gridWidget;
        this.gridModel = gridWidget.getModel();
        this.rendererHelper = gridWidget.getRendererHelper();
        this.selectionManager = selectionManager;
        this.renderer = renderer;
    }

    public void onNodeMouseClick(NodeMouseClickEvent event) {
        if (!this.gridWidget.isVisible()) {
            return;
        }
        this.handleHeaderCellClick(event);
        this.handleBodyCellClick(event);
    }

    protected void handleHeaderCellClick(NodeMouseClickEvent event) {
        Point2D rp = CoordinateUtilities.convertDOMToGridCoordinate(this.gridWidget, new Point2D((double)event.getX(), (double)event.getY()));
        if (this.gridWidget.selectHeaderCell(rp, event.isShiftKeyDown(), event.isControlKeyDown())) {
            this.gridWidget.getLayer().batch();
        }
    }

    protected void handleBodyCellClick(NodeMouseClickEvent event) {
        Point2D ap = CoordinateUtilities.convertDOMToGridCoordinate(this.gridWidget, new Point2D((double)event.getX(), (double)event.getY()));
        if (this.gridWidget.selectCell(ap, event.isShiftKeyDown(), event.isControlKeyDown())) {
            this.gridWidget.getLayer().batch();
        }
    }
}

