/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.selections.impl;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.types.Point2D;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.util.ColumnIndexUtilities;
import org.uberfire.ext.wires.core.grids.client.util.CoordinateUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellEditContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.CellSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.CellSelectionStrategy;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.SelectionExtension;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.impl.RangeSelectionStrategy;

public class BaseCellSelectionManager
implements CellSelectionManager {
    private final GridWidget gridWidget;
    private final GridData gridModel;

    public BaseCellSelectionManager(GridWidget gridWidget) {
        this.gridWidget = Objects.requireNonNull(gridWidget, "gridWidget");
        this.gridModel = Objects.requireNonNull(gridWidget.getModel(), "gridModel");
    }

    @Override
    public boolean selectCell(Point2D rp, boolean isShiftKeyDown, boolean isControlKeyDown) {
        Integer uiRowIndex = CoordinateUtilities.getUiRowIndex(this.gridWidget, rp.getY());
        Integer uiColumnIndex = CoordinateUtilities.getUiColumnIndex(this.gridWidget, rp.getX());
        if (uiRowIndex == null || uiColumnIndex == null) {
            return false;
        }
        return this.selectCell(uiRowIndex, uiColumnIndex, isShiftKeyDown, isControlKeyDown);
    }

    @Override
    public boolean selectCell(int uiRowIndex, int uiColumnIndex, boolean isShiftKeyDown, boolean isControlKeyDown) {
        if (uiRowIndex < 0 || uiRowIndex > this.gridModel.getRowCount() - 1) {
            return false;
        }
        if (uiColumnIndex < 0 || uiColumnIndex > this.gridModel.getColumnCount() - 1) {
            return false;
        }
        GridCell<?> cell = this.gridModel.getCell(uiRowIndex, uiColumnIndex);
        CellSelectionStrategy strategy = cell == null ? RangeSelectionStrategy.INSTANCE : cell.getSelectionStrategy();
        if (strategy == null) {
            return false;
        }
        return strategy.handleSelection(this.gridModel, uiRowIndex, uiColumnIndex, isShiftKeyDown, isControlKeyDown);
    }

    @Override
    public boolean selectHeaderCell(Point2D rp, boolean isShiftKeyDown, boolean isControlKeyDown) {
        Integer uiHeaderRowIndex = CoordinateUtilities.getUiHeaderRowIndex(this.gridWidget, rp);
        Integer uiHeaderColumnIndex = CoordinateUtilities.getUiColumnIndex(this.gridWidget, rp.getX());
        if (uiHeaderRowIndex == null || uiHeaderColumnIndex == null) {
            return false;
        }
        return this.selectHeaderCell(uiHeaderRowIndex, uiHeaderColumnIndex, isShiftKeyDown, isControlKeyDown);
    }

    @Override
    public boolean selectHeaderCell(int uiHeaderRowIndex, int uiHeaderColumnIndex, boolean isShiftKeyDown, boolean isControlKeyDown) {
        if (uiHeaderColumnIndex < 0 || uiHeaderColumnIndex > this.gridModel.getColumnCount() - 1) {
            return false;
        }
        GridColumn<?> gridColumn = this.gridModel.getColumns().get(uiHeaderColumnIndex);
        List<GridColumn.HeaderMetaData> gridColumnHeaderMetaData = gridColumn.getHeaderMetaData();
        if (uiHeaderRowIndex < 0 || uiHeaderRowIndex > gridColumnHeaderMetaData.size() - 1) {
            return false;
        }
        GridColumn.HeaderMetaData headerMetaData = gridColumnHeaderMetaData.get(uiHeaderRowIndex);
        CellSelectionStrategy strategy = headerMetaData.getSelectionStrategy();
        return strategy.handleSelection(this.gridModel, uiHeaderRowIndex, uiHeaderColumnIndex, isShiftKeyDown, isControlKeyDown);
    }

    @Override
    public boolean adjustSelection(SelectionExtension direction, boolean isShiftKeyDown) {
        GridData.SelectedCell origin = this.gridModel.getSelectedCellsOrigin();
        if (origin == null) {
            return false;
        }
        if (isShiftKeyDown) {
            return this.extendSelection(origin, direction);
        }
        return this.moveSelection(origin, direction);
    }

    private boolean extendSelection(GridData.SelectedCell origin, SelectionExtension direction) {
        if (this.gridModel.getSelectedCells().isEmpty()) {
            return false;
        }
        int originUiRowIndex = origin.getRowIndex();
        int originUiColumnIndex = ColumnIndexUtilities.findUiColumnIndex(this.gridModel.getColumns(), origin.getColumnIndex());
        int minUiRowIndex = this.findMinUiRowIndex(origin);
        int maxUiRowIndex = this.findMaxUiRowIndex(origin);
        int minUiColumnIndex = this.findMinUiColumnIndex(origin);
        int maxUiColumnIndex = this.findMaxUiColumnIndex(origin);
        int proposedUiColumnIndex = direction.getNextX(minUiColumnIndex, maxUiColumnIndex, originUiColumnIndex);
        int proposedUiRowIndex = direction.getNextY(minUiRowIndex, maxUiRowIndex, originUiRowIndex);
        if (!this.isCoordinateWithinExtents(proposedUiRowIndex, proposedUiColumnIndex)) {
            return false;
        }
        return this.selectCell(proposedUiRowIndex, proposedUiColumnIndex, true, false);
    }

    private int findMinUiRowIndex(GridData.SelectedCell origin) {
        int minUiRowIndex = origin.getRowIndex();
        List<GridData.SelectedCell> selectedCells = this.gridModel.getSelectedCells();
        for (GridData.SelectedCell selectedCell : selectedCells) {
            minUiRowIndex = Math.min(selectedCell.getRowIndex(), minUiRowIndex);
        }
        return minUiRowIndex;
    }

    private int findMaxUiRowIndex(GridData.SelectedCell origin) {
        int maxUiRowIndex = origin.getRowIndex();
        List<GridData.SelectedCell> selectedCells = this.gridModel.getSelectedCells();
        for (GridData.SelectedCell selectedCell : selectedCells) {
            maxUiRowIndex = Math.max(selectedCell.getRowIndex(), maxUiRowIndex);
        }
        return maxUiRowIndex;
    }

    private int findMinUiColumnIndex(GridData.SelectedCell origin) {
        int minUiColumnIndex = ColumnIndexUtilities.findUiColumnIndex(this.gridModel.getColumns(), origin.getColumnIndex());
        List<GridData.SelectedCell> selectedCells = this.gridModel.getSelectedCells();
        for (GridData.SelectedCell selectedCell : selectedCells) {
            minUiColumnIndex = Math.min(ColumnIndexUtilities.findUiColumnIndex(this.gridModel.getColumns(), selectedCell.getColumnIndex()), minUiColumnIndex);
        }
        return minUiColumnIndex;
    }

    private int findMaxUiColumnIndex(GridData.SelectedCell origin) {
        int maxUiColumnIndex = ColumnIndexUtilities.findUiColumnIndex(this.gridModel.getColumns(), origin.getColumnIndex());
        List<GridData.SelectedCell> selectedCells = this.gridModel.getSelectedCells();
        for (GridData.SelectedCell selectedCell : selectedCells) {
            maxUiColumnIndex = Math.max(ColumnIndexUtilities.findUiColumnIndex(this.gridModel.getColumns(), selectedCell.getColumnIndex()), maxUiColumnIndex);
        }
        return maxUiColumnIndex;
    }

    private boolean moveSelection(GridData.SelectedCell origin, SelectionExtension direction) {
        int currentUiColumnIndex;
        int proposedUiColumnIndex;
        int dx = direction.getDeltaX();
        int dy = direction.getDeltaY();
        int currentUiRowIndex = origin.getRowIndex();
        int proposedUiRowIndex = currentUiRowIndex + dy;
        if (!this.isCoordinateWithinExtents(proposedUiRowIndex, proposedUiColumnIndex = (currentUiColumnIndex = ColumnIndexUtilities.findUiColumnIndex(this.gridModel.getColumns(), origin.getColumnIndex())) + dx)) {
            return false;
        }
        return this.selectCell(proposedUiRowIndex, proposedUiColumnIndex, false, false);
    }

    private boolean isCoordinateWithinExtents(int proposedUiRowIndex, int proposedUiColumnIndex) {
        if (proposedUiRowIndex < 0 || proposedUiRowIndex > this.gridModel.getRowCount() - 1) {
            return false;
        }
        return proposedUiColumnIndex >= 0 && proposedUiColumnIndex <= this.gridModel.getColumnCount() - 1;
    }

    @Override
    public boolean startEditingCell(Point2D rp) {
        Integer uiRowIndex = CoordinateUtilities.getUiRowIndex(this.gridWidget, rp.getY());
        if (uiRowIndex == null) {
            return false;
        }
        Point2D gridWidgetComputedLocation = this.gridWidget.getComputedLocation();
        BaseGridRendererHelper rendererHelper = this.gridWidget.getRendererHelper();
        BaseGridRendererHelper.ColumnInformation ci = rendererHelper.getColumnInformation(rp.getX());
        GridColumn<?> column = ci.getColumn();
        if (column == null) {
            return false;
        }
        return this.edit(uiRowIndex, ci, Optional.of(rp.add(gridWidgetComputedLocation)));
    }

    @Override
    public boolean startEditingCell(int uiRowIndex, int uiColumnIndex) {
        if (!this.isCoordinateWithinExtents(uiRowIndex, uiColumnIndex)) {
            return false;
        }
        BaseGridRendererHelper.ColumnInformation ci = this.getFloatingColumnInformation(uiColumnIndex);
        if (ci == null) {
            ci = this.getBodyColumnInformation(uiColumnIndex);
        }
        if (ci == null) {
            return false;
        }
        return this.edit(uiRowIndex, ci, Optional.empty());
    }

    private BaseGridRendererHelper.ColumnInformation getFloatingColumnInformation(int uiColumnIndex) {
        GridColumn<?> column = this.gridModel.getColumns().get(uiColumnIndex);
        BaseGridRendererHelper rendererHelper = this.gridWidget.getRendererHelper();
        BaseGridRendererHelper.RenderingInformation renderingInformation = rendererHelper.getRenderingInformation();
        BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation = renderingInformation.getFloatingBlockInformation();
        List<GridColumn<?>> floatingColumns = floatingBlockInformation.getColumns();
        if (!floatingColumns.contains(column)) {
            return null;
        }
        return new BaseGridRendererHelper.ColumnInformation(column, uiColumnIndex, floatingBlockInformation.getX() + rendererHelper.getColumnOffset(floatingColumns, floatingColumns.indexOf(column)));
    }

    private BaseGridRendererHelper.ColumnInformation getBodyColumnInformation(int uiColumnIndex) {
        GridColumn<?> column = this.gridModel.getColumns().get(uiColumnIndex);
        BaseGridRendererHelper rendererHelper = this.gridWidget.getRendererHelper();
        BaseGridRendererHelper.RenderingInformation renderingInformation = rendererHelper.getRenderingInformation();
        BaseGridRendererHelper.RenderingBlockInformation bodyBlockInformation = renderingInformation.getBodyBlockInformation();
        List<GridColumn<?>> bodyColumns = bodyBlockInformation.getColumns();
        if (!bodyColumns.contains(column)) {
            return null;
        }
        return new BaseGridRendererHelper.ColumnInformation(column, uiColumnIndex, bodyBlockInformation.getX() + rendererHelper.getColumnOffset(bodyColumns, bodyColumns.indexOf(column)));
    }

    private boolean edit(int uiRowIndex, BaseGridRendererHelper.ColumnInformation ci, Optional<Point2D> rp) {
        GridColumn<?> column = ci.getColumn();
        int uiColumnIndex = ci.getUiColumnIndex();
        double offsetX = ci.getOffsetX();
        GridRenderer renderer = this.gridWidget.getRenderer();
        BaseGridRendererHelper rendererHelper = this.gridWidget.getRendererHelper();
        BaseGridRendererHelper.RenderingInformation renderingInformation = rendererHelper.getRenderingInformation();
        if (renderingInformation == null) {
            return false;
        }
        BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation = renderingInformation.getFloatingBlockInformation();
        double floatingX = floatingBlockInformation.getX();
        double floatingWidth = floatingBlockInformation.getWidth();
        Point2D gridWidgetComputedLocation = this.gridWidget.getComputedLocation();
        double cellX = gridWidgetComputedLocation.getX() + offsetX;
        double cellY = gridWidgetComputedLocation.getY() + renderer.getHeaderHeight() + this.getRowOffset(uiRowIndex, uiColumnIndex, rendererHelper);
        double cellHeight = this.getCellHeight(uiRowIndex, uiColumnIndex);
        Group header = this.gridWidget.getHeader();
        double clipMinX = gridWidgetComputedLocation.getX() + floatingX + floatingWidth;
        double clipMinY = gridWidgetComputedLocation.getY() + (header == null ? 0.0 : header.getY()) + renderer.getHeaderHeight();
        GridBodyCellEditContext context = new GridBodyCellEditContext(cellX, cellY, column.getWidth(), cellHeight, clipMinY, clipMinX, uiRowIndex, uiColumnIndex, floatingBlockInformation.getColumns().contains(column), this.gridWidget.getViewport().getTransform(), renderer, rp);
        this.doEdit(context);
        return true;
    }

    private double getRowOffset(int uiRowIndex, int uiColumnIndex, BaseGridRendererHelper rendererHelper) {
        GridCell<?> cell = this.gridModel.getCell(uiRowIndex, uiColumnIndex);
        if (cell == null) {
            return rendererHelper.getRowOffset(uiRowIndex);
        }
        if (cell.getMergedCellCount() == 1) {
            return rendererHelper.getRowOffset(uiRowIndex);
        }
        if (cell.getMergedCellCount() > 1) {
            return rendererHelper.getRowOffset(uiRowIndex);
        }
        int _uiRowIndex = uiRowIndex;
        GridCell<?> _cell = cell;
        while (_cell.getMergedCellCount() == 0) {
            _cell = this.gridModel.getCell(--_uiRowIndex, uiColumnIndex);
        }
        return rendererHelper.getRowOffset(_uiRowIndex);
    }

    private double getCellHeight(int uiRowIndex, int uiColumnIndex) {
        GridCell<?> cell = this.gridModel.getCell(uiRowIndex, uiColumnIndex);
        if (cell == null) {
            return this.gridModel.getRow(uiRowIndex).getHeight();
        }
        if (cell.getMergedCellCount() == 1) {
            return this.gridModel.getRow(uiRowIndex).getHeight();
        }
        if (cell.getMergedCellCount() > 1) {
            return this.getMergedCellHeight(uiRowIndex, uiColumnIndex);
        }
        return this.getClippedMergedCellHeight(uiRowIndex, uiColumnIndex);
    }

    private double getMergedCellHeight(int uiRowIndex, int uiColumnIndex) {
        double height = 0.0;
        GridCell<?> cell = this.gridModel.getCell(uiRowIndex, uiColumnIndex);
        for (int i = uiRowIndex; i < uiRowIndex + cell.getMergedCellCount(); ++i) {
            height += this.gridModel.getRow(i).getHeight();
        }
        return height;
    }

    private double getClippedMergedCellHeight(int uiRowIndex, int uiColumnIndex) {
        GridCell<?> cell;
        GridCell<?> _cell = cell = this.gridModel.getCell(uiRowIndex, uiColumnIndex);
        int _uiRowIndex = uiRowIndex;
        while (_cell.getMergedCellCount() == 0) {
            _cell = this.gridModel.getCell(--_uiRowIndex, uiColumnIndex);
        }
        double height = 0.0;
        for (int i = _uiRowIndex; i < _uiRowIndex + _cell.getMergedCellCount(); ++i) {
            height += this.gridModel.getRow(i).getHeight();
        }
        return height;
    }

    protected void doEdit(GridBodyCellEditContext context) {
        int uiRowIndex = context.getRowIndex();
        int uiColumnIndex = context.getColumnIndex();
        GridData gridModel = this.gridWidget.getModel();
        GridColumn<?> column = gridModel.getColumns().get(uiColumnIndex);
        GridCell<?> cell = gridModel.getCell(uiRowIndex, uiColumnIndex);
        column.edit(cell, context, (GridCellValue<T> value) -> {
            gridModel.setCellValue(uiRowIndex, uiColumnIndex, (GridCellValue)value);
            this.gridWidget.getLayer().batch();
        });
    }
}

