/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.model;

import java.util.List;
import java.util.function.Consumer;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellEditContext;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.GridColumnRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.CellSelectionStrategy;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.impl.HeaderSingleCellSelectionStrategy;

public interface GridColumn<T> {
    public List<HeaderMetaData> getHeaderMetaData();

    public GridColumnRenderer<T> getColumnRenderer();

    default public void edit(GridCell<T> cell, GridBodyCellRenderContext context, Consumer<GridCellValue<T>> callback) {
    }

    default public void edit(GridCell<T> cell, GridBodyCellEditContext context, Consumer<GridCellValue<T>> callback) {
        this.edit(cell, (GridBodyCellRenderContext)context, callback);
    }

    public double getWidth();

    public void setWidth(double var1);

    public boolean isLinked();

    public GridColumn<?> getLink();

    public void setLink(GridColumn<?> var1);

    public int getIndex();

    public void setIndex(int var1);

    public boolean isResizable();

    public void setResizable(boolean var1);

    public boolean isMovable();

    public void setMovable(boolean var1);

    public boolean isFloatable();

    public void setFloatable(boolean var1);

    public boolean isVisible();

    public void setVisible(boolean var1);

    public Double getMinimumWidth();

    public void setMinimumWidth(Double var1);

    public Double getMaximumWidth();

    public void setMaximumWidth(Double var1);

    public ColumnWidthMode getColumnWidthMode();

    public void setColumnWidthMode(ColumnWidthMode var1);

    public static enum ColumnWidthMode {
        FIXED,
        AUTO;


        public static boolean isAuto(GridColumn<?> column) {
            return column != null && AUTO.equals((Object)column.getColumnWidthMode());
        }

        public static boolean isFixed(GridColumn<?> column) {
            return column != null && FIXED.equals((Object)column.getColumnWidthMode());
        }
    }

    public static interface HeaderMetaData {
        public String getColumnGroup();

        public void setColumnGroup(String var1);

        public String getTitle();

        public void setTitle(String var1);

        default public CellSelectionStrategy getSelectionStrategy() {
            return HeaderSingleCellSelectionStrategy.INSTANCE;
        }
    }
}

