/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.util;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.types.Point2D;
import java.util.List;
import java.util.Optional;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.util.ColumnIndexUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellEditContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;

public class CellContextUtilities {
    public static GridBodyCellEditContext makeRenderContext(GridWidget gridWidget, BaseGridRendererHelper.RenderingInformation ri, BaseGridRendererHelper.ColumnInformation ci, int uiHeaderRowIndex) {
        return CellContextUtilities.makeRenderContext(gridWidget, ri, ci, null, uiHeaderRowIndex);
    }

    public static GridBodyCellEditContext makeRenderContext(GridWidget gridWidget, BaseGridRendererHelper.RenderingInformation ri, BaseGridRendererHelper.ColumnInformation ci, Point2D rp, int uiHeaderRowIndex) {
        GridColumn<?> column = ci.getColumn();
        GridRenderer renderer = gridWidget.getRenderer();
        Group header = gridWidget.getHeader();
        double headerRowsYOffset = ri.getHeaderRowsYOffset();
        double headerMinY = header == null ? headerRowsYOffset : header.getY() + headerRowsYOffset;
        double headerRowHeight = ri.getHeaderRowsHeight() / (double)column.getHeaderMetaData().size();
        double cellX = gridWidget.getAbsoluteX() + ci.getOffsetX();
        double cellY = gridWidget.getAbsoluteY() + headerMinY + headerRowHeight * (double)uiHeaderRowIndex;
        BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation = ri.getFloatingBlockInformation();
        double floatingX = floatingBlockInformation.getX();
        double floatingWidth = floatingBlockInformation.getWidth();
        double clipMinX = gridWidget.getAbsoluteX() + floatingX + floatingWidth;
        double clipMinY = gridWidget.getAbsoluteY();
        double blockCellX = cellX;
        double blockCellWidth = column.getWidth();
        List<GridColumn<?>> gridColumns = ri.getAllColumns();
        GridColumn.HeaderMetaData clicked = column.getHeaderMetaData().get(uiHeaderRowIndex);
        if (ci.getUiColumnIndex() > 0) {
            int uiLeadColumnIndex = ci.getUiColumnIndex() - 1;
            GridColumn<?> lead = gridColumns.get(uiLeadColumnIndex);
            while (uiLeadColumnIndex >= 0 && CellContextUtilities.isSameHeaderMetaData(clicked, lead.getHeaderMetaData(), uiHeaderRowIndex)) {
                blockCellX -= lead.getWidth();
                blockCellWidth += lead.getWidth();
                if (--uiLeadColumnIndex < 0) continue;
                lead = gridColumns.get(uiLeadColumnIndex);
            }
        }
        if (ci.getUiColumnIndex() < gridColumns.size() - 1) {
            int uiTailColumnIndex = ci.getUiColumnIndex() + 1;
            GridColumn<?> tail = gridColumns.get(uiTailColumnIndex);
            while (uiTailColumnIndex < gridColumns.size() && CellContextUtilities.isSameHeaderMetaData(clicked, tail.getHeaderMetaData(), uiHeaderRowIndex)) {
                blockCellWidth += tail.getWidth();
                tail = gridColumns.get(uiTailColumnIndex);
                if (++uiTailColumnIndex >= gridColumns.size()) continue;
                tail = gridColumns.get(uiTailColumnIndex);
            }
        }
        return new GridBodyCellEditContext(blockCellX, cellY, blockCellWidth, headerRowHeight, clipMinY, clipMinX, uiHeaderRowIndex, ci.getUiColumnIndex(), floatingBlockInformation.getColumns().contains(column), gridWidget.getViewport().getTransform(), renderer, Optional.ofNullable(rp));
    }

    public static void editSelectedCell(GridWidget gridWidget) {
        GridData gridModel = gridWidget.getModel();
        if (gridModel.getSelectedHeaderCells().size() > 0) {
            GridData.SelectedCell selectedCell = gridModel.getSelectedHeaderCells().get(0);
            int uiHeaderRowIndex = selectedCell.getRowIndex();
            int uiColumnIndex = ColumnIndexUtilities.findUiColumnIndex(gridModel.getColumns(), selectedCell.getColumnIndex());
            GridColumn<?> column = gridModel.getColumns().get(uiColumnIndex);
            GridColumn.HeaderMetaData headerMetaData = column.getHeaderMetaData().get(uiHeaderRowIndex);
            BaseGridRendererHelper rendererHelper = gridWidget.getRendererHelper();
            BaseGridRendererHelper.RenderingInformation ri = rendererHelper.getRenderingInformation();
            double columnXCoordinate = rendererHelper.getColumnOffset(column) + column.getWidth() / 2.0;
            BaseGridRendererHelper.ColumnInformation ci = rendererHelper.getColumnInformation(columnXCoordinate);
            GridBodyCellEditContext context = CellContextUtilities.makeRenderContext(gridWidget, ri, ci, null, uiHeaderRowIndex);
            headerMetaData.edit(context);
        } else if (gridModel.getSelectedCells().size() > 0) {
            GridData.SelectedCell origin = gridModel.getSelectedCellsOrigin();
            if (origin == null) {
                return;
            }
            gridWidget.startEditingCell(origin.getRowIndex(), ColumnIndexUtilities.findUiColumnIndex(gridModel.getColumns(), origin.getColumnIndex()));
        }
    }

    private static boolean isSameHeaderMetaData(GridColumn.HeaderMetaData clickedHeaderMetaData, List<GridColumn.HeaderMetaData> columnHeaderMetaData, int uiHeaderRowIndex) {
        if (uiHeaderRowIndex > columnHeaderMetaData.size() - 1) {
            return false;
        }
        return clickedHeaderMetaData.equals(columnHeaderMetaData.get(uiHeaderRowIndex));
    }
}

