/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.util;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.types.Point2D;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.util.ColumnIndexUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellEditContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;

public class CellContextUtilities {
    public static GridBodyCellEditContext makeCellRenderContext(GridWidget gridWidget, BaseGridRendererHelper.RenderingInformation ri, BaseGridRendererHelper.ColumnInformation ci, int uiRowIndex) {
        GridColumn<?> column = ci.getColumn();
        GridRenderer renderer = gridWidget.getRenderer();
        GridRow gridRow = gridWidget.getModel().getRow(uiRowIndex);
        double headerRowsHeight = ri.getHeaderRowsHeight();
        double rowYOffset = gridWidget.getRendererHelper().getRowOffset(gridRow);
        double cellX = CellContextUtilities.getCellX(gridWidget, ci);
        double cellY = CellContextUtilities.getHeaderY(gridWidget, ri) + headerRowsHeight + rowYOffset;
        BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation = ri.getFloatingBlockInformation();
        double clipMinX = CellContextUtilities.getClipMinX(gridWidget, floatingBlockInformation);
        double clipMinY = CellContextUtilities.getClipMinY(gridWidget);
        double blockCellWidth = column.getWidth();
        double blockCellHeight = gridRow.getHeight();
        return new GridBodyCellEditContext(cellX, cellY, blockCellWidth, blockCellHeight, clipMinY, clipMinX, uiRowIndex, ci.getUiColumnIndex(), floatingBlockInformation.getColumns().contains(column), gridWidget.getViewport().getTransform(), renderer, Optional.empty());
    }

    public static GridBodyCellEditContext makeHeaderCellRenderContext(GridWidget gridWidget, BaseGridRendererHelper.RenderingInformation ri, BaseGridRendererHelper.ColumnInformation ci, int uiHeaderRowIndex) {
        return CellContextUtilities.makeHeaderCellRenderContext(gridWidget, ri, ci, null, uiHeaderRowIndex);
    }

    public static GridBodyCellEditContext makeHeaderCellRenderContext(GridWidget gridWidget, BaseGridRendererHelper.RenderingInformation ri, BaseGridRendererHelper.ColumnInformation ci, Point2D rp, int uiHeaderRowIndex) {
        GridColumn<?> column = ci.getColumn();
        GridRenderer renderer = gridWidget.getRenderer();
        double headerRowHeight = CellContextUtilities.getHeaderRowHeight(ri, column);
        double cellX = CellContextUtilities.getCellX(gridWidget, ci);
        double cellY = CellContextUtilities.getHeaderY(gridWidget, ri) + headerRowHeight * (double)uiHeaderRowIndex;
        BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation = ri.getFloatingBlockInformation();
        double clipMinX = CellContextUtilities.getClipMinX(gridWidget, floatingBlockInformation);
        double clipMinY = CellContextUtilities.getClipMinY(gridWidget);
        List<GridColumn<?>> gridColumns = ri.getAllColumns();
        GridColumn.HeaderMetaData headerMetaData = column.getHeaderMetaData().get(uiHeaderRowIndex);
        int blockStartColumnIndex = ColumnIndexUtilities.getHeaderBlockStartColumnIndex(gridColumns, headerMetaData, uiHeaderRowIndex, ci.getUiColumnIndex());
        int blockEndColumnIndex = ColumnIndexUtilities.getHeaderBlockEndColumnIndex(gridColumns, headerMetaData, uiHeaderRowIndex, ci.getUiColumnIndex());
        double blockCellWidth = IntStream.rangeClosed(blockStartColumnIndex, blockEndColumnIndex).mapToDouble(uiHeaderColumnIndex -> ((GridColumn)gridColumns.get(uiHeaderColumnIndex)).getWidth()).sum();
        return new GridBodyCellEditContext(cellX, cellY, blockCellWidth, headerRowHeight, clipMinY, clipMinX, uiHeaderRowIndex, ci.getUiColumnIndex(), floatingBlockInformation.getColumns().contains(column), gridWidget.getViewport().getTransform(), renderer, Optional.ofNullable(rp));
    }

    public static void editSelectedCell(GridWidget gridWidget) {
        GridData gridModel = gridWidget.getModel();
        if (gridModel.getSelectedHeaderCells().size() > 0) {
            GridData.SelectedCell selectedCell = gridModel.getSelectedHeaderCells().get(0);
            int uiHeaderRowIndex = selectedCell.getRowIndex();
            int uiColumnIndex = ColumnIndexUtilities.findUiColumnIndex(gridModel.getColumns(), selectedCell.getColumnIndex());
            GridColumn<?> column = gridModel.getColumns().get(uiColumnIndex);
            GridColumn.HeaderMetaData headerMetaData = column.getHeaderMetaData().get(uiHeaderRowIndex);
            BaseGridRendererHelper rendererHelper = gridWidget.getRendererHelper();
            BaseGridRendererHelper.RenderingInformation ri = rendererHelper.getRenderingInformation();
            double columnXCoordinate = rendererHelper.getColumnOffset(column) + column.getWidth() / 2.0;
            BaseGridRendererHelper.ColumnInformation ci = rendererHelper.getColumnInformation(columnXCoordinate);
            GridBodyCellEditContext context = CellContextUtilities.makeHeaderCellRenderContext(gridWidget, ri, ci, uiHeaderRowIndex);
            headerMetaData.edit(context);
        } else if (gridModel.getSelectedCells().size() > 0) {
            GridData.SelectedCell origin = gridModel.getSelectedCellsOrigin();
            if (origin == null) {
                return;
            }
            gridWidget.startEditingCell(origin.getRowIndex(), ColumnIndexUtilities.findUiColumnIndex(gridModel.getColumns(), origin.getColumnIndex()));
        }
    }

    private static double getCellX(GridWidget gridWidget, BaseGridRendererHelper.ColumnInformation ci) {
        return gridWidget.getComputedLocation().getX() + ci.getOffsetX();
    }

    private static double getHeaderY(GridWidget gridWidget, BaseGridRendererHelper.RenderingInformation ri) {
        Group header = gridWidget.getHeader();
        double headerRowsYOffset = ri.getHeaderRowsYOffset();
        double headerMinY = header == null ? headerRowsYOffset : header.getY() + headerRowsYOffset;
        return gridWidget.getComputedLocation().getY() + headerMinY;
    }

    private static double getHeaderRowHeight(BaseGridRendererHelper.RenderingInformation ri, GridColumn<?> column) {
        if (column.getHeaderMetaData() == null || column.getHeaderMetaData().size() == 0) {
            return 0.0;
        }
        return ri.getHeaderRowsHeight() / (double)column.getHeaderMetaData().size();
    }

    private static double getClipMinX(GridWidget gridWidget, BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation) {
        double floatingX = floatingBlockInformation.getX();
        double floatingWidth = floatingBlockInformation.getWidth();
        return gridWidget.getComputedLocation().getX() + floatingX + floatingWidth;
    }

    private static double getClipMinY(GridWidget gridWidget) {
        return gridWidget.getComputedLocation().getY();
    }
}

