/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.impl;

import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.util.ColumnIndexUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.BaseKeyboardOperation;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperation;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;

public class KeyboardOperationInvokeContextMenuForSelectedCell
extends BaseKeyboardOperation {
    public KeyboardOperationInvokeContextMenuForSelectedCell(GridLayer gridLayer) {
        super(gridLayer);
    }

    @Override
    public KeyboardOperation.TriStateBoolean isControlKeyDown() {
        return KeyboardOperation.TriStateBoolean.TRUE;
    }

    @Override
    public int getKeyCode() {
        return 32;
    }

    @Override
    public boolean isExecutable(GridWidget gridWidget) {
        GridData model = gridWidget.getModel();
        return model.getSelectedCells().size() > 0;
    }

    @Override
    public boolean perform(GridWidget gridWidget, boolean isShiftKeyDown, boolean isControlKeyDown) {
        GridData model = gridWidget.getModel();
        GridData.SelectedCell origin = model.getSelectedCellsOrigin();
        if (origin == null) {
            return false;
        }
        int rowIndex = origin.getRowIndex();
        int columnIndex = ColumnIndexUtilities.findUiColumnIndex(model.getColumns(), origin.getColumnIndex());
        return gridWidget.showContextMenuForCell(rowIndex, columnIndex);
    }
}

