/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.layer.impl;

import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.widget.LienzoPanel;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ScrollEvent;
import com.google.gwt.event.dom.client.ScrollHandler;
import com.google.gwt.event.logical.shared.AttachEvent;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.ProvidesResize;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.DefaultGridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.scrollbars.GridLienzoScrollHandler;
import org.uberfire.ext.wires.core.grids.client.widget.scrollbars.GridLienzoScrollable;

public class GridLienzoPanel
extends FocusPanel
implements RequiresResize,
ProvidesResize,
GridLienzoScrollable {
    protected final LienzoPanel lienzoPanel;
    protected final AbsolutePanel domElementContainer = new AbsolutePanel();
    private final AbsolutePanel internalScrollPanel = new AbsolutePanel();
    private final AbsolutePanel scrollPanel = new AbsolutePanel();
    private final AbsolutePanel rootPanel = new AbsolutePanel();
    private final GridLienzoScrollHandler gridLienzoScrollHandler;
    private DefaultGridLayer defaultGridLayer;

    public GridLienzoPanel() {
        this(new LienzoPanel(){

            public void onResize() {
            }
        });
    }

    public GridLienzoPanel(int width, int height) {
        this(new LienzoPanel(width, height){

            public void onResize() {
            }
        });
        this.updatePanelSize(width, height);
    }

    private GridLienzoPanel(LienzoPanel lienzoPanel) {
        this.lienzoPanel = lienzoPanel;
        this.gridLienzoScrollHandler = new GridLienzoScrollHandler(this);
        this.setupPanels();
        this.setupScrollHandlers();
        this.setupDefaultHandlers();
    }

    void setupPanels() {
        this.setupScrollPanel();
        this.setupDomElementContainer();
        this.setupRootPanel();
        this.add((Widget)this.getRootPanel());
        this.getElement().getStyle().setOutlineStyle(Style.OutlineStyle.NONE);
    }

    void setupScrollPanel() {
        this.getScrollPanel().add((Widget)this.getInternalScrollPanel());
    }

    void setupDomElementContainer() {
        this.getDomElementContainer().add((Widget)this.getLienzoPanel());
    }

    void setupRootPanel() {
        this.getRootPanel().add((Widget)this.getDomElementContainer());
        this.getRootPanel().add((Widget)this.getScrollPanel());
    }

    void setupScrollHandlers() {
        this.getGridLienzoScrollHandler().init();
        this.addMouseUpHandler();
    }

    void addMouseUpHandler() {
        this.addMouseUpHandler(e -> this.refreshScrollPosition());
    }

    private void setupDefaultHandlers() {
        this.domElementContainer.addDomHandler((EventHandler)new ScrollHandler(){

            public void onScroll(ScrollEvent scrollEvent) {
                GridLienzoPanel.this.domElementContainer.getElement().setScrollTop(0);
                GridLienzoPanel.this.domElementContainer.getElement().setScrollLeft(0);
            }
        }, ScrollEvent.getType());
        this.addAttachHandler(new AttachEvent.Handler(){

            public void onAttachOrDetach(AttachEvent event) {
                if (event.isAttached()) {
                    GridLienzoPanel.this.onResize();
                }
            }
        });
        this.addMouseDownHandler(e -> this.setFocus(true));
    }

    public void onResize() {
        this.scheduleDeferred(() -> {
            this.updatePanelSize();
            this.refreshScrollPosition();
        });
    }

    void scheduleDeferred(Scheduler.ScheduledCommand scheduledCommand) {
        Scheduler.get().scheduleDeferred(scheduledCommand);
    }

    @Override
    public void updatePanelSize() {
        Element parentElement = this.getElement().getParentElement();
        Integer width = parentElement.getOffsetWidth();
        Integer height = parentElement.getOffsetHeight();
        if (width > 0 && height > 0) {
            this.updatePanelSize(width, height);
        }
    }

    @Override
    public void updatePanelSize(Integer width, Integer height) {
        this.updateScrollPanelSize(width, height);
        this.updateInternalPanelsSizes(width, height);
    }

    private void updateInternalPanelsSizes(int width, int height) {
        Integer scrollbarWidth = this.getGridLienzoScrollHandler().scrollbarWidth();
        Integer scrollbarHeight = this.getGridLienzoScrollHandler().scrollbarHeight();
        int visibleWidth = width - scrollbarWidth;
        int visibleHeight = height - scrollbarHeight;
        this.getDomElementContainer().setPixelSize(visibleWidth, visibleHeight);
        this.getLienzoPanel().setPixelSize(visibleWidth, visibleHeight);
        this.propagateNewPanelSize(visibleWidth, visibleHeight);
    }

    private void updateScrollPanelSize(int width, int height) {
        this.getScrollPanel().setPixelSize(width, height);
    }

    protected void propagateNewPanelSize(int visibleWidth, int visibleHeight) {
        if (this.getDefaultGridLayer() == null) {
            return;
        }
        boolean toRefresh = false;
        for (GridWidget gridWidget : this.getDefaultGridLayer().getGridWidgets()) {
            toRefresh = toRefresh || gridWidget.getModel().setVisibleSizeAndRefresh(visibleWidth, visibleHeight);
        }
        if (toRefresh) {
            this.getDefaultGridLayer().batch();
        }
    }

    @Override
    public void refreshScrollPosition() {
        this.getGridLienzoScrollHandler().refreshScrollPosition();
    }

    @Override
    public void setBounds(Bounds bounds) {
        this.getGridLienzoScrollHandler().setBounds(bounds);
    }

    public LienzoPanel add(DefaultGridLayer layer) {
        this.defaultGridLayer = this.setupDefaultGridLayer(layer);
        layer.setDomElementContainer(this.domElementContainer);
        this.lienzoPanel.add((Layer)this.defaultGridLayer);
        return this.lienzoPanel;
    }

    private DefaultGridLayer setupDefaultGridLayer(DefaultGridLayer layer) {
        layer.addOnEnterPinnedModeCommand(this::refreshScrollPosition);
        layer.addOnExitPinnedModeCommand(this::refreshScrollPosition);
        return layer;
    }

    public final Viewport getViewport() {
        return this.lienzoPanel.getViewport();
    }

    public LienzoPanel getLienzoPanel() {
        return this.lienzoPanel;
    }

    public AbsolutePanel getScrollPanel() {
        return this.scrollPanel;
    }

    public AbsolutePanel getDomElementContainer() {
        return this.domElementContainer;
    }

    public AbsolutePanel getInternalScrollPanel() {
        return this.internalScrollPanel;
    }

    public DefaultGridLayer getDefaultGridLayer() {
        return this.defaultGridLayer;
    }

    AbsolutePanel getRootPanel() {
        return this.rootPanel;
    }

    GridLienzoScrollHandler getGridLienzoScrollHandler() {
        return this.gridLienzoScrollHandler;
    }
}

