/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.GridColumnRenderer;

public class BaseGridColumn<T>
implements GridColumn<T> {
    private static final double COLUMN_MIN_WIDTH = 100.0;
    private double width;
    private boolean isResizable = true;
    private boolean isMovable = true;
    private boolean isFloatable = false;
    private boolean isVisible = true;
    private Double minimumWidth = 100.0;
    private Double maximumWidth = null;
    private GridColumn<?> link;
    private int index = -1;
    private List<GridColumn.HeaderMetaData> headerMetaData = new ArrayList<GridColumn.HeaderMetaData>();
    private GridColumnRenderer<T> columnRenderer;

    public BaseGridColumn(GridColumn.HeaderMetaData headerMetaData, GridColumnRenderer<T> columnRenderer, double width) {
        PortablePreconditions.checkNotNull((String)"headerMetaData", (Object)headerMetaData);
        PortablePreconditions.checkNotNull((String)"columnRenderer", columnRenderer);
        this.headerMetaData.add(headerMetaData);
        this.columnRenderer = columnRenderer;
        this.width = width;
    }

    public BaseGridColumn(List<GridColumn.HeaderMetaData> headerMetaData, GridColumnRenderer<T> columnRenderer, double width) {
        PortablePreconditions.checkNotNull((String)"headerMetaData", headerMetaData);
        PortablePreconditions.checkCondition((String)"headerMetaData has at least one entry", (headerMetaData.size() > 0 ? 1 : 0) != 0);
        PortablePreconditions.checkNotNull((String)"columnRenderer", columnRenderer);
        this.headerMetaData.addAll(headerMetaData);
        this.columnRenderer = columnRenderer;
        this.width = width;
    }

    @Override
    public List<GridColumn.HeaderMetaData> getHeaderMetaData() {
        return this.headerMetaData;
    }

    @Override
    public GridColumnRenderer<T> getColumnRenderer() {
        return this.columnRenderer;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(double width) {
        this.width = width;
    }

    @Override
    public boolean isLinked() {
        return this.link != null;
    }

    @Override
    public GridColumn<?> getLink() {
        return this.link;
    }

    @Override
    public void setLink(GridColumn<?> link) {
        this.link = link;
    }

    @Override
    public int getIndex() {
        if (this.index == -1) {
            throw new IllegalStateException("Column has not been added to a Grid and hence has no index.");
        }
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public boolean isResizable() {
        return this.isResizable;
    }

    @Override
    public void setResizable(boolean isResizable) {
        this.isResizable = isResizable;
    }

    @Override
    public boolean isMovable() {
        return this.isMovable;
    }

    @Override
    public void setMovable(boolean isMovable) {
        this.isMovable = isMovable;
    }

    @Override
    public boolean isFloatable() {
        return this.isFloatable;
    }

    @Override
    public void setFloatable(boolean isFloatable) {
        this.isFloatable = isFloatable;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    @Override
    public Double getMinimumWidth() {
        return this.minimumWidth;
    }

    @Override
    public void setMinimumWidth(Double minimumWidth) {
        this.minimumWidth = minimumWidth;
    }

    @Override
    public Double getMaximumWidth() {
        return this.maximumWidth;
    }

    @Override
    public void setMaximumWidth(Double maximumWidth) {
        this.maximumWidth = maximumWidth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseGridColumn)) {
            return false;
        }
        BaseGridColumn that = (BaseGridColumn)o;
        if (Double.compare(that.width, this.width) != 0) {
            return false;
        }
        if (this.isResizable != that.isResizable) {
            return false;
        }
        if (this.isMovable != that.isMovable) {
            return false;
        }
        if (this.isVisible != that.isVisible) {
            return false;
        }
        if (this.index != that.index) {
            return false;
        }
        if (this.minimumWidth != null ? !this.minimumWidth.equals(that.minimumWidth) : that.minimumWidth != null) {
            return false;
        }
        if (this.maximumWidth != null ? !this.maximumWidth.equals(that.maximumWidth) : that.maximumWidth != null) {
            return false;
        }
        if (this.link != null ? !this.link.equals(that.link) : that.link != null) {
            return false;
        }
        return this.headerMetaData.equals(that.headerMetaData);
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.width);
        int result = (int)(temp ^ temp >>> 32);
        result = ~(~result);
        result = 31 * result + (this.isResizable ? 1 : 0);
        result = ~(~result);
        result = 31 * result + (this.isMovable ? 1 : 0);
        result = ~(~result);
        result = 31 * result + (this.isVisible ? 1 : 0);
        result = ~(~result);
        result = 31 * result + (this.minimumWidth != null ? this.minimumWidth.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.maximumWidth != null ? this.maximumWidth.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.link != null ? this.link.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + this.index;
        result = ~(~result);
        result = 31 * result + this.headerMetaData.hashCode();
        result = ~(~result);
        return result;
    }
}

